/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal.nativeimage;

import com.github.ajalt.mordant.internal.MppImpls;
import com.github.ajalt.mordant.internal.nativeimage.WinKernel32Lib;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.PointerBase;
import org.jetbrains.annotations.Nullable;

@Platforms(value={Platform.WINDOWS.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/github/ajalt/mordant/internal/nativeimage/NativeImageWin32MppImpls;", "Lcom/github/ajalt/mordant/internal/MppImpls;", "()V", "getTerminalSize", "Lkotlin/Pair;", "", "stderrInteractive", "", "stdinInteractive", "stdoutInteractive", "mordant"})
public final class NativeImageWin32MppImpls
implements MppImpls {
    @Override
    public boolean stdoutInteractive() {
        PointerBase handle = WinKernel32Lib.INSTANCE.GetStdHandle(WinKernel32Lib.INSTANCE.STD_OUTPUT_HANDLE());
        return WinKernel32Lib.INSTANCE.GetConsoleMode(handle, (CIntPointer)StackValue.get(CIntPointer.class));
    }

    @Override
    public boolean stderrInteractive() {
        PointerBase handle = WinKernel32Lib.INSTANCE.GetStdHandle(WinKernel32Lib.INSTANCE.STD_ERROR_HANDLE());
        return WinKernel32Lib.INSTANCE.GetConsoleMode(handle, (CIntPointer)StackValue.get(CIntPointer.class));
    }

    @Override
    public boolean stdinInteractive() {
        PointerBase handle = WinKernel32Lib.INSTANCE.GetStdHandle(WinKernel32Lib.INSTANCE.STD_INPUT_HANDLE());
        return WinKernel32Lib.INSTANCE.GetConsoleMode(handle, (CIntPointer)StackValue.get(CIntPointer.class));
    }

    @Override
    @Nullable
    public Pair<Integer, Integer> getTerminalSize() {
        WinKernel32Lib.CONSOLE_SCREEN_BUFFER_INFO csbi = (WinKernel32Lib.CONSOLE_SCREEN_BUFFER_INFO)StackValue.get(WinKernel32Lib.CONSOLE_SCREEN_BUFFER_INFO.class);
        PointerBase handle = WinKernel32Lib.INSTANCE.GetStdHandle(WinKernel32Lib.INSTANCE.STD_OUTPUT_HANDLE());
        return !WinKernel32Lib.INSTANCE.GetConsoleScreenBufferInfo(handle, csbi.rawValue()) ? null : TuplesKt.to(csbi.getRight() - csbi.getLeft() + 1, csbi.getBottom() - csbi.getTop() + 1);
    }
}

