/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.EvaluationListener;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.MapFunction;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.spi.cache.Cache;
import com.jayway.jsonpath.spi.cache.CacheProvider;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonContext
implements DocumentContext {
    private static final Logger logger = LoggerFactory.getLogger(JsonContext.class);
    private final Configuration configuration;
    private final Object json;

    JsonContext(Object json, Configuration configuration) {
        Utils.notNull(json, "json can not be null");
        Utils.notNull(configuration, "configuration can not be null");
        this.configuration = configuration;
        this.json = json;
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    public Object json() {
        return this.json;
    }

    @Override
    public String jsonString() {
        return this.configuration.jsonProvider().toJson(this.json);
    }

    @Override
    public <T> T read(String path2, Predicate ... filters) {
        Utils.notEmpty(path2, "path can not be null or empty");
        return this.read(this.pathFromCache(path2, filters));
    }

    @Override
    public <T> T read(String path2, Class<T> type2, Predicate ... filters) {
        return this.convert(this.read(path2, filters), type2, this.configuration);
    }

    @Override
    public <T> T read(JsonPath path2) {
        Utils.notNull(path2, "path can not be null");
        return path2.read(this.json, this.configuration);
    }

    @Override
    public <T> T read(JsonPath path2, Class<T> type2) {
        return this.convert(this.read(path2), type2, this.configuration);
    }

    @Override
    public <T> T read(JsonPath path2, TypeRef<T> type2) {
        return this.convert(this.read(path2), type2, this.configuration);
    }

    @Override
    public <T> T read(String path2, TypeRef<T> type2) {
        return this.convert(this.read(path2, new Predicate[0]), type2, this.configuration);
    }

    @Override
    public ReadContext limit(int maxResults) {
        return this.withListeners(new LimitingEvaluationListener(maxResults));
    }

    @Override
    public ReadContext withListeners(EvaluationListener ... listener) {
        return new JsonContext(this.json, this.configuration.setEvaluationListeners(listener));
    }

    private <T> T convert(Object obj, Class<T> targetType, Configuration configuration) {
        return configuration.mappingProvider().map(obj, targetType, configuration);
    }

    private <T> T convert(Object obj, TypeRef<T> targetType, Configuration configuration) {
        return configuration.mappingProvider().map(obj, targetType, configuration);
    }

    @Override
    public DocumentContext set(String path2, Object newValue, Predicate ... filters) {
        return this.set(this.pathFromCache(path2, filters), newValue);
    }

    @Override
    public DocumentContext set(JsonPath path2, Object newValue) {
        List modified = (List)path2.set(this.json, newValue, this.configuration.addOptions(Option.AS_PATH_LIST));
        if (logger.isDebugEnabled()) {
            for (String p : modified) {
                logger.debug("Set path {} new value {}", (Object)p, newValue);
            }
        }
        return this;
    }

    @Override
    public DocumentContext map(String path2, MapFunction mapFunction, Predicate ... filters) {
        this.map(this.pathFromCache(path2, filters), mapFunction);
        return this;
    }

    @Override
    public DocumentContext map(JsonPath path2, MapFunction mapFunction) {
        Object obj = path2.map(this.json, mapFunction, this.configuration);
        return obj == null ? null : this;
    }

    @Override
    public DocumentContext delete(String path2, Predicate ... filters) {
        return this.delete(this.pathFromCache(path2, filters));
    }

    @Override
    public DocumentContext delete(JsonPath path2) {
        List modified = (List)path2.delete(this.json, this.configuration.addOptions(Option.AS_PATH_LIST));
        if (logger.isDebugEnabled()) {
            for (String p : modified) {
                logger.debug("Delete path {}", (Object)p);
            }
        }
        return this;
    }

    @Override
    public DocumentContext add(String path2, Object value, Predicate ... filters) {
        return this.add(this.pathFromCache(path2, filters), value);
    }

    @Override
    public DocumentContext add(JsonPath path2, Object value) {
        List modified = (List)path2.add(this.json, value, this.configuration.addOptions(Option.AS_PATH_LIST));
        if (logger.isDebugEnabled()) {
            for (String p : modified) {
                logger.debug("Add path {} new value {}", (Object)p, value);
            }
        }
        return this;
    }

    @Override
    public DocumentContext put(String path2, String key, Object value, Predicate ... filters) {
        return this.put(this.pathFromCache(path2, filters), key, value);
    }

    @Override
    public DocumentContext renameKey(String path2, String oldKeyName, String newKeyName, Predicate ... filters) {
        return this.renameKey(this.pathFromCache(path2, filters), oldKeyName, newKeyName);
    }

    @Override
    public DocumentContext renameKey(JsonPath path2, String oldKeyName, String newKeyName) {
        List modified = (List)path2.renameKey(this.json, oldKeyName, newKeyName, this.configuration.addOptions(Option.AS_PATH_LIST));
        if (logger.isDebugEnabled()) {
            for (String p : modified) {
                logger.debug("Rename path {} new value {}", (Object)p, (Object)newKeyName);
            }
        }
        return this;
    }

    @Override
    public DocumentContext put(JsonPath path2, String key, Object value) {
        List modified = (List)path2.put(this.json, key, value, this.configuration.addOptions(Option.AS_PATH_LIST));
        if (logger.isDebugEnabled()) {
            for (String p : modified) {
                logger.debug("Put path {} key {} value {}", p, key, value);
            }
        }
        return this;
    }

    private JsonPath pathFromCache(String path2, Predicate[] filters) {
        String cacheKey;
        Cache cache2 = CacheProvider.getCache();
        JsonPath jsonPath = cache2.get(cacheKey = filters == null || filters.length == 0 ? path2 : Utils.concat(path2, Arrays.toString(filters)));
        if (jsonPath == null) {
            jsonPath = JsonPath.compile(path2, filters);
            cache2.put(cacheKey, jsonPath);
        }
        return jsonPath;
    }

    private static final class LimitingEvaluationListener
    implements EvaluationListener {
        final int limit;

        private LimitingEvaluationListener(int limit) {
            this.limit = limit;
        }

        @Override
        public EvaluationListener.EvaluationContinuation resultFound(EvaluationListener.FoundResult found) {
            if (found.index() == this.limit - 1) {
                return EvaluationListener.EvaluationContinuation.ABORT;
            }
            return EvaluationListener.EvaluationContinuation.CONTINUE;
        }
    }
}

