/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal;

import com.jayway.jsonpath.JsonPathException;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;

public final class Utils {
    public static String join(String delimiter, String wrap, Iterable<?> objs) {
        Iterator<?> iter = objs.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(wrap).append(iter.next()).append(wrap);
        while (iter.hasNext()) {
            buffer.append(delimiter).append(wrap).append(iter.next()).append(wrap);
        }
        return buffer.toString();
    }

    public static String join(String delimiter, Iterable<?> objs) {
        return Utils.join(delimiter, "", objs);
    }

    public static String concat(CharSequence ... strings) {
        if (strings.length == 0) {
            return "";
        }
        if (strings.length == 1) {
            return strings[0].toString();
        }
        int length = 0;
        int indexOfSingleNonEmptyString = -1;
        for (int i = 0; i < strings.length; ++i) {
            CharSequence charSequence = strings[i];
            int len = charSequence.length();
            length += len;
            if (indexOfSingleNonEmptyString == -2 || len <= 0) continue;
            indexOfSingleNonEmptyString = indexOfSingleNonEmptyString == -1 ? i : -2;
        }
        if (length == 0) {
            return "";
        }
        if (indexOfSingleNonEmptyString > 0) {
            return strings[indexOfSingleNonEmptyString].toString();
        }
        StringBuilder sb = new StringBuilder(length);
        for (CharSequence charSequence : strings) {
            sb.append(charSequence);
        }
        return sb.toString();
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String escape(String str, boolean escapeSingleQuote) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringWriter writer2 = new StringWriter(len * 2);
        block13: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                writer2.write("\\u" + Utils.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                writer2.write("\\u0" + Utils.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                writer2.write("\\u00" + Utils.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        writer2.write(92);
                        writer2.write(98);
                        break;
                    }
                    case '\n': {
                        writer2.write(92);
                        writer2.write(110);
                        break;
                    }
                    case '\t': {
                        writer2.write(92);
                        writer2.write(116);
                        break;
                    }
                    case '\f': {
                        writer2.write(92);
                        writer2.write(102);
                        break;
                    }
                    case '\r': {
                        writer2.write(92);
                        writer2.write(114);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            writer2.write("\\u00" + Utils.hex(ch));
                            break;
                        }
                        writer2.write("\\u000" + Utils.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    if (escapeSingleQuote) {
                        writer2.write(92);
                    }
                    writer2.write(39);
                    continue block13;
                }
                case '\"': {
                    writer2.write(92);
                    writer2.write(34);
                    continue block13;
                }
                case '\\': {
                    writer2.write(92);
                    writer2.write(92);
                    continue block13;
                }
                case '/': {
                    writer2.write(92);
                    writer2.write(47);
                    continue block13;
                }
                default: {
                    writer2.write(ch);
                }
            }
        }
        return writer2.toString();
    }

    public static String unescape(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringWriter writer2 = new StringWriter(len);
        StringBuilder unicode = new StringBuilder(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    writer2.write((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new JsonPathException("Unable to parse unicode value: " + unicode, nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        writer2.write(92);
                        break;
                    }
                    case '\'': {
                        writer2.write(39);
                        break;
                    }
                    case '\"': {
                        writer2.write(34);
                        break;
                    }
                    case 'r': {
                        writer2.write(13);
                        break;
                    }
                    case 'f': {
                        writer2.write(12);
                        break;
                    }
                    case 't': {
                        writer2.write(9);
                        break;
                    }
                    case 'n': {
                        writer2.write(10);
                        break;
                    }
                    case 'b': {
                        writer2.write(8);
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    default: {
                        writer2.write(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            writer2.write(ch);
        }
        if (hadSlash) {
            writer2.write(92);
        }
        return writer2.toString();
    }

    public static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase();
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    static int indexOf(CharSequence cs, CharSequence searchChar, int start2) {
        return cs.toString().indexOf(searchChar.toString(), start2);
    }

    public static <T> T notNull(T object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
        return object;
    }

    public static <T> T notNull(T object, String message, Object ... values2) {
        if (object == null) {
            throw new IllegalArgumentException(String.format(message, values2));
        }
        return object;
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void onlyOneIsTrue(String message, boolean ... expressions) {
        if (!Utils.onlyOneIsTrueNonThrow(expressions)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean onlyOneIsTrueNonThrow(boolean ... expressions) {
        int count2 = 0;
        for (boolean expression : expressions) {
            if (!expression || ++count2 <= 1) continue;
            return false;
        }
        return 1 == count2;
    }

    public static <T extends CharSequence> T notEmpty(T chars, String message) {
        if (chars == null || chars.length() == 0) {
            throw new IllegalArgumentException(message);
        }
        return chars;
    }

    public static byte[] notEmpty(byte[] bytes, String message) {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException(message);
        }
        return bytes;
    }

    public static <T extends CharSequence> T notEmpty(T chars, String message, Object ... values2) {
        if (chars == null || chars.length() == 0) {
            throw new IllegalArgumentException(String.format(message, values2));
        }
        return chars;
    }

    public static String toString(Object o) {
        if (null == o) {
            return null;
        }
        return o.toString();
    }

    private Utils() {
    }
}

