/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.function;

import com.jayway.jsonpath.internal.EvaluationContext;
import com.jayway.jsonpath.internal.Path;
import com.jayway.jsonpath.internal.function.ParamType;
import com.jayway.jsonpath.internal.function.latebinding.ILateBindingValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Parameter {
    private ParamType type;
    private Path path;
    private ILateBindingValue lateBinding;
    private Boolean evaluated = false;
    private String json;

    public Parameter() {
    }

    public Parameter(String json) {
        this.json = json;
        this.type = ParamType.JSON;
    }

    public Parameter(Path path2) {
        this.path = path2;
        this.type = ParamType.PATH;
    }

    public Object getValue() {
        return this.lateBinding.get();
    }

    public void setLateBinding(ILateBindingValue lateBinding) {
        this.lateBinding = lateBinding;
    }

    public Path getPath() {
        return this.path;
    }

    public void setEvaluated(Boolean evaluated) {
        this.evaluated = evaluated;
    }

    public boolean hasEvaluated() {
        return this.evaluated;
    }

    public ParamType getType() {
        return this.type;
    }

    public void setType(ParamType type2) {
        this.type = type2;
    }

    public void setPath(Path path2) {
        this.path = path2;
    }

    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public ILateBindingValue getILateBingValue() {
        return this.lateBinding;
    }

    public static <T> List<T> toList(Class<T> type2, EvaluationContext ctx, List<Parameter> parameters2) {
        ArrayList values2 = new ArrayList();
        if (null != parameters2) {
            for (Parameter param2 : parameters2) {
                Parameter.consume(type2, ctx, values2, param2.getValue());
            }
        }
        return values2;
    }

    public static void consume(Class expectedType, EvaluationContext ctx, Collection collection, Object value) {
        if (ctx.configuration().jsonProvider().isArray(value)) {
            for (Object o : ctx.configuration().jsonProvider().toIterable(value)) {
                if (o != null && expectedType.isAssignableFrom(o.getClass())) {
                    collection.add(o);
                    continue;
                }
                if (o == null || expectedType != String.class) continue;
                collection.add(o.toString());
            }
        } else if (value != null && expectedType.isAssignableFrom(value.getClass())) {
            collection.add(value);
        } else if (value != null && expectedType == String.class) {
            collection.add(value.toString());
        }
    }
}

