/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.function.numeric;

import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.internal.EvaluationContext;
import com.jayway.jsonpath.internal.PathRef;
import com.jayway.jsonpath.internal.function.Parameter;
import com.jayway.jsonpath.internal.function.PathFunction;
import java.util.List;

public abstract class AbstractAggregation
implements PathFunction {
    protected abstract void next(Number var1);

    protected abstract Number getValue();

    @Override
    public Object invoke(String currentPath, PathRef parent, Object model, EvaluationContext ctx, List<Parameter> parameters2) {
        int count2 = 0;
        if (ctx.configuration().jsonProvider().isArray(model)) {
            Iterable<?> objects = ctx.configuration().jsonProvider().toIterable(model);
            for (Object obj : objects) {
                if (!(obj instanceof Number)) continue;
                Number value = (Number)obj;
                ++count2;
                this.next(value);
            }
        }
        if (parameters2 != null) {
            for (Number value : Parameter.toList(Number.class, ctx, parameters2)) {
                ++count2;
                this.next(value);
            }
        }
        if (count2 != 0) {
            return this.getValue();
        }
        throw new JsonPathException("Aggregation function attempted to calculate value using empty array");
    }
}

