/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.path;

import com.jayway.jsonpath.internal.Path;
import com.jayway.jsonpath.internal.PathRef;
import com.jayway.jsonpath.internal.function.Parameter;
import com.jayway.jsonpath.internal.function.PathFunction;
import com.jayway.jsonpath.internal.function.PathFunctionFactory;
import com.jayway.jsonpath.internal.function.latebinding.JsonLateBindingValue;
import com.jayway.jsonpath.internal.function.latebinding.PathLateBindingValue;
import com.jayway.jsonpath.internal.path.CompiledPath;
import com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import com.jayway.jsonpath.internal.path.PathToken;
import com.jayway.jsonpath.internal.path.RootPathToken;
import com.jayway.jsonpath.internal.path.WildcardPathToken;
import java.util.List;

public class FunctionPathToken
extends PathToken {
    private final String functionName;
    private final String pathFragment;
    private List<Parameter> functionParams;

    public FunctionPathToken(String pathFragment, List<Parameter> parameters2) {
        this.pathFragment = pathFragment + (parameters2 != null && parameters2.size() > 0 ? "(...)" : "()");
        if (null != pathFragment) {
            this.functionName = pathFragment;
            this.functionParams = parameters2;
        } else {
            this.functionName = null;
            this.functionParams = null;
        }
    }

    @Override
    public void evaluate(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        PathFunction pathFunction = PathFunctionFactory.newFunction(this.functionName);
        this.evaluateParameters(currentPath, parent, model, ctx);
        Object result2 = pathFunction.invoke(currentPath, parent, model, ctx, this.functionParams);
        ctx.addResult(currentPath + "." + this.functionName, parent, result2);
        this.cleanWildcardPathToken();
        if (!this.isLeaf()) {
            this.next().evaluate(currentPath, parent, result2, ctx);
        }
    }

    private void cleanWildcardPathToken() {
        Path path2;
        if (null != this.functionParams && this.functionParams.size() > 0 && null != (path2 = this.functionParams.get(0).getPath()) && !path2.isFunctionPath() && path2 instanceof CompiledPath) {
            RootPathToken root = ((CompiledPath)path2).getRoot();
            for (PathToken tail = root.getNext(); null != tail && null != tail.getNext(); tail = tail.getNext()) {
                if (!(tail.getNext() instanceof WildcardPathToken)) continue;
                tail.setNext(tail.getNext().getNext());
                break;
            }
        }
    }

    private void evaluateParameters(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        if (null != this.functionParams) {
            for (Parameter param2 : this.functionParams) {
                switch (param2.getType()) {
                    case PATH: {
                        PathLateBindingValue pathLateBindingValue = new PathLateBindingValue(param2.getPath(), ctx.rootDocument(), ctx.configuration());
                        if (param2.hasEvaluated() && pathLateBindingValue.equals(param2.getILateBingValue())) break;
                        param2.setLateBinding(pathLateBindingValue);
                        param2.setEvaluated(true);
                        break;
                    }
                    case JSON: {
                        if (param2.hasEvaluated()) break;
                        param2.setLateBinding(new JsonLateBindingValue(ctx.configuration().jsonProvider(), param2));
                        param2.setEvaluated(true);
                    }
                }
            }
        }
    }

    @Override
    public boolean isTokenDefinite() {
        return true;
    }

    @Override
    public String getPathFragment() {
        return "." + this.pathFragment;
    }

    public void setParameters(List<Parameter> parameters2) {
        this.functionParams = parameters2;
    }

    public List<Parameter> getParameters() {
        return this.functionParams;
    }

    public String getFunctionName() {
        return this.functionName;
    }
}

