/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.path;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.Path;
import com.jayway.jsonpath.spi.mapper.MappingException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredicateContextImpl
implements Predicate.PredicateContext {
    private static final Logger logger = LoggerFactory.getLogger(PredicateContextImpl.class);
    private final Object contextDocument;
    private final Object rootDocument;
    private final Configuration configuration;
    private final HashMap<Path, Object> documentPathCache;

    public PredicateContextImpl(Object contextDocument, Object rootDocument, Configuration configuration, HashMap<Path, Object> documentPathCache) {
        this.contextDocument = contextDocument;
        this.rootDocument = rootDocument;
        this.configuration = configuration;
        this.documentPathCache = documentPathCache;
    }

    public Object evaluate(Path path2) {
        Object result2;
        if (path2.isRootPath()) {
            if (this.documentPathCache.containsKey(path2)) {
                logger.debug("Using cached result for root path: " + path2.toString());
                result2 = this.documentPathCache.get(path2);
            } else {
                result2 = path2.evaluate(this.rootDocument, this.rootDocument, this.configuration).getValue();
                this.documentPathCache.put(path2, result2);
            }
        } else {
            result2 = path2.evaluate(this.contextDocument, this.rootDocument, this.configuration).getValue();
        }
        return result2;
    }

    public HashMap<Path, Object> documentPathCache() {
        return this.documentPathCache;
    }

    @Override
    public Object item() {
        return this.contextDocument;
    }

    @Override
    public <T> T item(Class<T> clazz) throws MappingException {
        return this.configuration().mappingProvider().map(this.contextDocument, clazz, this.configuration);
    }

    @Override
    public Object root() {
        return this.rootDocument;
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }
}

