/*
 * Decompiled with CFR 0.152.
 */
package com.knuddels.jtokkit;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

final class ImmutableByteArray {
    private final byte[] array;

    public static ImmutableByteArray from(String string) {
        Objects.requireNonNull(string, "String must not be null");
        return new ImmutableByteArray(string.getBytes(StandardCharsets.UTF_8));
    }

    public static ImmutableByteArray from(byte[] array) {
        Objects.requireNonNull(array, "Byte array must not be null");
        return new ImmutableByteArray((byte[])array.clone());
    }

    private ImmutableByteArray(byte[] array) {
        this.array = array;
    }

    public int length() {
        return this.array.length;
    }

    public ImmutableByteArray getBytesBetween(int startIndex, int endIndex) {
        if (startIndex < 0 || startIndex >= this.array.length) {
            throw new IndexOutOfBoundsException("startIndex out of bounds: " + startIndex + " (" + this + ")");
        }
        if (endIndex < 0 || endIndex > this.array.length) {
            throw new IndexOutOfBoundsException("endIndex out of bounds: " + endIndex + " (" + this + ")");
        }
        if (startIndex >= endIndex) {
            throw new IllegalArgumentException("startIndex must be less than endIndex: " + startIndex + " >= " + endIndex);
        }
        int length = endIndex - startIndex;
        byte[] result2 = new byte[length];
        System.arraycopy(this.array, startIndex, result2, 0, length);
        return new ImmutableByteArray(result2);
    }

    public byte[] getRawArray() {
        return (byte[])this.array.clone();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ImmutableByteArray that = (ImmutableByteArray)other;
        return Arrays.equals(this.array, that.array);
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public String toString() {
        return Arrays.toString(this.array);
    }
}

