/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.completion.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.theokanning.openai.completion.chat.ChatFunctionCall;
import lombok.NonNull;

public class ChatMessage {
    @NonNull
    String role;
    @JsonInclude
    String content;
    String name;
    @JsonProperty(value="function_call")
    ChatFunctionCall functionCall;

    public ChatMessage(String role, String content) {
        this.role = role;
        this.content = content;
    }

    public ChatMessage(String role, String content, String name) {
        this.role = role;
        this.content = content;
        this.name = name;
    }

    @NonNull
    public String getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public ChatFunctionCall getFunctionCall() {
        return this.functionCall;
    }

    public void setRole(@NonNull String role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.role = role;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="function_call")
    public void setFunctionCall(ChatFunctionCall functionCall) {
        this.functionCall = functionCall;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatMessage)) {
            return false;
        }
        ChatMessage other = (ChatMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ChatFunctionCall this$functionCall = this.getFunctionCall();
        ChatFunctionCall other$functionCall = other.getFunctionCall();
        return !(this$functionCall == null ? other$functionCall != null : !((Object)this$functionCall).equals(other$functionCall));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        String $role = this.getRole();
        result2 = result2 * 59 + ($role == null ? 43 : $role.hashCode());
        String $content = this.getContent();
        result2 = result2 * 59 + ($content == null ? 43 : $content.hashCode());
        String $name = this.getName();
        result2 = result2 * 59 + ($name == null ? 43 : $name.hashCode());
        ChatFunctionCall $functionCall = this.getFunctionCall();
        result2 = result2 * 59 + ($functionCall == null ? 43 : ((Object)$functionCall).hashCode());
        return result2;
    }

    public String toString() {
        return "ChatMessage(role=" + this.getRole() + ", content=" + this.getContent() + ", name=" + this.getName() + ", functionCall=" + this.getFunctionCall() + ")";
    }

    public ChatMessage() {
    }

    public ChatMessage(@NonNull String role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.role = role;
    }

    public ChatMessage(@NonNull String role, String content, String name, ChatFunctionCall functionCall) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.role = role;
        this.content = content;
        this.name = name;
        this.functionCall = functionCall;
    }
}

