/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.theokanning.openai.completion.chat.ChatFunction;
import com.theokanning.openai.completion.chat.ChatFunctionCall;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.completion.chat.ChatMessageRole;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FunctionExecutor {
    private ObjectMapper MAPPER = new ObjectMapper();
    private final Map<String, ChatFunction> FUNCTIONS = new HashMap<String, ChatFunction>();

    public FunctionExecutor(List<ChatFunction> functions2) {
        this.setFunctions(functions2);
    }

    public FunctionExecutor(List<ChatFunction> functions2, ObjectMapper objectMapper) {
        this.setFunctions(functions2);
        this.setObjectMapper(objectMapper);
    }

    public Optional<ChatMessage> executeAndConvertToMessageSafely(ChatFunctionCall call) {
        try {
            return Optional.ofNullable(this.executeAndConvertToMessage(call));
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }

    public ChatMessage executeAndConvertToMessageHandlingExceptions(ChatFunctionCall call) {
        try {
            return this.executeAndConvertToMessage(call);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.convertExceptionToMessage(exception);
        }
    }

    public ChatMessage convertExceptionToMessage(Exception exception) {
        String error = exception.getMessage() == null ? exception.toString() : exception.getMessage();
        return new ChatMessage(ChatMessageRole.FUNCTION.value(), "{\"error\": \"" + error + "\"}", "error");
    }

    public ChatMessage executeAndConvertToMessage(ChatFunctionCall call) {
        return new ChatMessage(ChatMessageRole.FUNCTION.value(), this.executeAndConvertToJson(call).toPrettyString(), call.getName());
    }

    public JsonNode executeAndConvertToJson(ChatFunctionCall call) {
        try {
            Object execution = this.execute(call);
            if (execution instanceof TextNode) {
                JsonNode objectNode = this.MAPPER.readTree(((TextNode)execution).asText());
                if (objectNode.isMissingNode()) {
                    return (JsonNode)execution;
                }
                return objectNode;
            }
            if (execution instanceof ObjectNode) {
                return (JsonNode)execution;
            }
            if (execution instanceof String) {
                JsonNode objectNode = this.MAPPER.readTree((String)execution);
                if (objectNode.isMissingNode()) {
                    throw new RuntimeException("Parsing exception");
                }
                return objectNode;
            }
            return this.MAPPER.readValue(this.MAPPER.writeValueAsString(execution), JsonNode.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T execute(ChatFunctionCall call) {
        Object obj;
        ChatFunction function = this.FUNCTIONS.get(call.getName());
        try {
            JsonNode arguments2 = call.getArguments();
            obj = this.MAPPER.readValue(arguments2 instanceof TextNode ? arguments2.asText() : arguments2.toPrettyString(), function.getParametersClass());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return (T)function.getExecutor().apply(obj);
    }

    public List<ChatFunction> getFunctions() {
        return new ArrayList<ChatFunction>(this.FUNCTIONS.values());
    }

    public void setFunctions(List<ChatFunction> functions2) {
        this.FUNCTIONS.clear();
        functions2.forEach(f -> this.FUNCTIONS.put(f.getName(), (ChatFunction)f));
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.MAPPER = objectMapper;
    }
}

