/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.BaseTypeSignature;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassRefTypeSignature;
import io.github.classgraph.ScanResult;
import io.github.classgraph.ScanResultObject;
import io.github.classgraph.TypeSignature;
import java.util.Set;
import nonapi.io.github.classgraph.types.ParseException;

public class AnnotationClassRef
extends ScanResultObject {
    private String typeDescriptorStr;
    private transient TypeSignature typeSignature;
    private transient String className;

    AnnotationClassRef() {
    }

    AnnotationClassRef(String typeDescriptorStr) {
        this.typeDescriptorStr = typeDescriptorStr;
    }

    public String getName() {
        return this.getClassName();
    }

    private TypeSignature getTypeSignature() {
        if (this.typeSignature == null) {
            try {
                this.typeSignature = TypeSignature.parse(this.typeDescriptorStr, null);
                this.typeSignature.setScanResult(this.scanResult);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.typeSignature;
    }

    @Override
    public Class<?> loadClass(boolean ignoreExceptions) {
        this.getTypeSignature();
        if (this.typeSignature instanceof BaseTypeSignature) {
            return ((BaseTypeSignature)this.typeSignature).getType();
        }
        if (this.typeSignature instanceof ClassRefTypeSignature) {
            return ((ClassRefTypeSignature)this.typeSignature).loadClass(ignoreExceptions);
        }
        throw new IllegalArgumentException("Got unexpected type " + this.typeSignature.getClass().getName() + " for ref type signature: " + this.typeDescriptorStr);
    }

    @Override
    public Class<?> loadClass() {
        return this.loadClass(false);
    }

    @Override
    protected String getClassName() {
        if (this.className == null) {
            this.getTypeSignature();
            if (this.typeSignature instanceof BaseTypeSignature) {
                this.className = ((BaseTypeSignature)this.typeSignature).getType().getName();
            } else if (this.typeSignature instanceof ClassRefTypeSignature) {
                this.className = ((ClassRefTypeSignature)this.typeSignature).getFullyQualifiedClassName();
            } else {
                throw new IllegalArgumentException("Got unexpected type " + this.typeSignature.getClass().getName() + " for ref type signature: " + this.typeDescriptorStr);
            }
        }
        return this.className;
    }

    @Override
    public ClassInfo getClassInfo() {
        this.getClassName();
        return super.getClassInfo();
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        super.setScanResult(scanResult);
        if (this.typeSignature != null) {
            this.typeSignature.setScanResult(scanResult);
        }
    }

    @Override
    protected void findReferencedClassNames(Set<String> classNames2) {
        classNames2.add(this.getClassName());
    }

    public int hashCode() {
        return this.getTypeSignature().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AnnotationClassRef)) {
            return false;
        }
        return this.getTypeSignature().equals(((AnnotationClassRef)obj).getTypeSignature());
    }

    public String toString() {
        ClassInfo ci;
        String prefix = "class ";
        if (this.scanResult != null && (ci = this.getClassInfo()) != null && ci.isInterfaceOrAnnotation()) {
            prefix = "interface ";
        }
        return prefix + this.getTypeSignature().toString();
    }
}

