/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.Resource;
import io.github.classgraph.Scanner;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.concurrency.WorkQueue;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.JarUtils;
import nonapi.io.github.classgraph.utils.LogNode;

abstract class ClasspathElement {
    List<String> nestedClasspathRootPrefixes;
    boolean skipClasspathElement;
    boolean containsSpecificallyWhitelistedClasspathElementResourcePath;
    final Queue<Map.Entry<Integer, ClasspathElement>> childClasspathElementsIndexed = new ConcurrentLinkedQueue<Map.Entry<Integer, ClasspathElement>>();
    List<ClasspathElement> childClasspathElementsOrdered;
    protected final Collection<Resource> whitelistedResources = new ConcurrentLinkedQueue<Resource>();
    protected Collection<Resource> whitelistedClassfileResources = new ConcurrentLinkedQueue<Resource>();
    protected final Map<File, Long> fileToLastModified = new ConcurrentHashMap<File, Long>();
    protected final AtomicBoolean scanned = new AtomicBoolean(false);
    protected ClassLoader classLoader;
    String moduleNameFromModuleDescriptor;
    final ScanSpec scanSpec;

    ClasspathElement(ClassLoader classLoader, ScanSpec scanSpec) {
        this.classLoader = classLoader;
        this.scanSpec = scanSpec;
    }

    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    int getNumClassfileMatches() {
        return this.whitelistedClassfileResources == null ? 0 : this.whitelistedClassfileResources.size();
    }

    protected void checkResourcePathWhiteBlackList(String relativePath, LogNode log) {
        if (!this.scanSpec.classpathElementResourcePathWhiteBlackList.whitelistAndBlacklistAreEmpty()) {
            if (this.scanSpec.classpathElementResourcePathWhiteBlackList.isBlacklisted(relativePath)) {
                if (log != null) {
                    log.log("Reached blacklisted classpath element resource path, stopping scanning: " + relativePath);
                }
                this.skipClasspathElement = true;
                return;
            }
            if (this.scanSpec.classpathElementResourcePathWhiteBlackList.isSpecificallyWhitelisted(relativePath)) {
                if (log != null) {
                    log.log("Reached specifically whitelisted classpath element resource path: " + relativePath);
                }
                this.containsSpecificallyWhitelistedClasspathElementResourcePath = true;
            }
        }
    }

    void maskClassfiles(int classpathIdx, Set<String> classpathRelativePathsFound, LogNode log) {
        if (!this.scanSpec.performScan) {
            throw new IllegalArgumentException("performScan is false");
        }
        ArrayList<Resource> whitelistedClassfileResourcesFiltered = new ArrayList<Resource>(this.whitelistedClassfileResources.size());
        boolean foundMasked = false;
        for (Resource res : this.whitelistedClassfileResources) {
            String pathRelativeToPackageRoot = res.getPath();
            if (!(pathRelativeToPackageRoot.equals("module-info.class") || pathRelativeToPackageRoot.endsWith("/module-info.class") || pathRelativeToPackageRoot.equals("package-info.class") || pathRelativeToPackageRoot.endsWith("/package-info.class") || classpathRelativePathsFound.add(pathRelativeToPackageRoot))) {
                foundMasked = true;
                if (log == null) continue;
                log.log(String.format("%06d-1", classpathIdx), "Ignoring duplicate (masked) class " + JarUtils.classfilePathToClassName(pathRelativeToPackageRoot) + " found at " + res);
                continue;
            }
            whitelistedClassfileResourcesFiltered.add(res);
        }
        if (foundMasked) {
            this.whitelistedClassfileResources = whitelistedClassfileResourcesFiltered;
        }
    }

    protected void addWhitelistedResource(Resource resource, ScanSpec.ScanSpecPathMatch parentMatchStatus, LogNode log) {
        String path2 = resource.getPath();
        boolean isClassFile = FileUtils.isClassfile(path2);
        boolean isWhitelisted = false;
        if (isClassFile) {
            if (this.scanSpec.enableClassInfo && !this.scanSpec.classfilePathWhiteBlackList.isBlacklisted(path2)) {
                this.whitelistedClassfileResources.add(resource);
                isWhitelisted = true;
            }
        } else {
            isWhitelisted = true;
        }
        this.whitelistedResources.add(resource);
        if (log != null && isWhitelisted) {
            String logStr;
            String type2 = isClassFile ? "classfile" : "resource";
            switch (parentMatchStatus) {
                case HAS_WHITELISTED_PATH_PREFIX: {
                    logStr = "Found " + type2 + " within subpackage of whitelisted package: ";
                    break;
                }
                case AT_WHITELISTED_PATH: {
                    logStr = "Found " + type2 + " within whitelisted package: ";
                    break;
                }
                case AT_WHITELISTED_CLASS_PACKAGE: {
                    logStr = "Found specifically-whitelisted " + type2 + ": ";
                    break;
                }
                default: {
                    logStr = "Found whitelisted " + type2 + ": ";
                }
            }
            resource.scanLog = log.log("0:" + path2, logStr + path2 + (path2.equals(resource.getPathRelativeToClasspathElement()) ? "" : " ; full path: " + resource.getPathRelativeToClasspathElement()));
        }
    }

    protected void finishScanPaths(LogNode log) {
        if (log != null) {
            if (this.whitelistedResources.isEmpty() && this.whitelistedClassfileResources.isEmpty()) {
                log.log(this.scanSpec.enableClassInfo ? "No whitelisted classfiles or resources found" : "Classfile scanning is disabled, and no whitelisted resources found");
            } else if (this.whitelistedResources.isEmpty()) {
                log.log("No whitelisted resources found");
            } else if (this.whitelistedClassfileResources.isEmpty()) {
                log.log(this.scanSpec.enableClassInfo ? "No whitelisted classfiles found" : "Classfile scanning is disabled");
            }
        }
        if (log != null) {
            log.addElapsedTime();
        }
    }

    abstract void open(WorkQueue<Scanner.ClasspathEntryWorkUnit> var1, LogNode var2) throws InterruptedException;

    abstract void scanPaths(LogNode var1);

    abstract Resource getResource(String var1);

    abstract URI getURI();

    abstract File getFile();

    abstract String getModuleName();
}

