/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Scheduler;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public final class CompletableTimeout
extends Completable {
    final CompletableSource source;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final CompletableSource other;

    public CompletableTimeout(CompletableSource source, long timeout, TimeUnit unit, Scheduler scheduler, CompletableSource other) {
        this.source = source;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.other = other;
    }

    @Override
    public void subscribeActual(final CompletableObserver s) {
        final CompositeDisposable set = new CompositeDisposable();
        s.onSubscribe(set);
        final AtomicBoolean once = new AtomicBoolean();
        Disposable timer2 = this.scheduler.scheduleDirect(new Runnable(){

            @Override
            public void run() {
                if (once.compareAndSet(false, true)) {
                    set.clear();
                    if (CompletableTimeout.this.other == null) {
                        s.onError(new TimeoutException());
                    } else {
                        CompletableTimeout.this.other.subscribe(new CompletableObserver(){

                            @Override
                            public void onSubscribe(Disposable d) {
                                set.add(d);
                            }

                            @Override
                            public void onError(Throwable e) {
                                set.dispose();
                                s.onError(e);
                            }

                            @Override
                            public void onComplete() {
                                set.dispose();
                                s.onComplete();
                            }
                        });
                    }
                }
            }
        }, this.timeout, this.unit);
        set.add(timer2);
        this.source.subscribe(new CompletableObserver(){

            @Override
            public void onSubscribe(Disposable d) {
                set.add(d);
            }

            @Override
            public void onError(Throwable e) {
                if (once.compareAndSet(false, true)) {
                    set.dispose();
                    s.onError(e);
                } else {
                    RxJavaPlugins.onError(e);
                }
            }

            @Override
            public void onComplete() {
                if (once.compareAndSet(false, true)) {
                    set.dispose();
                    s.onComplete();
                }
            }
        });
    }
}

