/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.FlowableMap;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableCombineLatest<T, R>
extends Flowable<R> {
    final Publisher<? extends T>[] array;
    final Iterable<? extends Publisher<? extends T>> iterable;
    final Function<? super Object[], ? extends R> combiner;
    final int bufferSize;
    final boolean delayErrors;

    public FlowableCombineLatest(Publisher<? extends T>[] array, Function<? super Object[], ? extends R> combiner, int bufferSize, boolean delayErrors) {
        this.array = array;
        this.iterable = null;
        this.combiner = combiner;
        this.bufferSize = bufferSize;
        this.delayErrors = delayErrors;
    }

    public FlowableCombineLatest(Iterable<? extends Publisher<? extends T>> iterable, Function<? super Object[], ? extends R> combiner, int bufferSize, boolean delayErrors) {
        this.array = null;
        this.iterable = iterable;
        this.combiner = combiner;
        this.bufferSize = bufferSize;
        this.delayErrors = delayErrors;
    }

    @Override
    public void subscribeActual(Subscriber<? super R> s) {
        int n;
        Publisher<? extends T>[] a;
        block11: {
            a = this.array;
            if (a == null) {
                Iterator<Publisher<T>> it;
                n = 0;
                a = new Publisher[8];
                try {
                    it = ObjectHelper.requireNonNull(this.iterable.iterator(), "The iterator returned is null");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    EmptySubscription.error(e, s);
                    return;
                }
                while (true) {
                    Publisher<? extends T> p;
                    boolean b;
                    try {
                        b = it.hasNext();
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal(e);
                        EmptySubscription.error(e, s);
                        return;
                    }
                    if (!b) break block11;
                    try {
                        p = ObjectHelper.requireNonNull(it.next(), "The publisher returned by the iterator is null");
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal(e);
                        EmptySubscription.error(e, s);
                        return;
                    }
                    if (n == a.length) {
                        Publisher[] c = new Publisher[n + (n >> 2)];
                        System.arraycopy(a, 0, c, 0, n);
                        a = c;
                    }
                    a[n++] = p;
                }
            }
            n = a.length;
        }
        if (n == 0) {
            EmptySubscription.complete(s);
            return;
        }
        if (n == 1) {
            new FlowableMap(a[0], new Function<T, R>(){

                @Override
                public R apply(T t) throws Exception {
                    return FlowableCombineLatest.this.combiner.apply((Object[])new Object[]{t});
                }
            }).subscribe(s);
            return;
        }
        CombineLatestCoordinator<? extends T, R> coordinator = new CombineLatestCoordinator<T, R>(s, this.combiner, n, this.bufferSize, this.delayErrors);
        s.onSubscribe(coordinator);
        coordinator.subscribe(a, n);
    }

    static final class CombineLatestInnerSubscriber<T>
    extends AtomicReference<Subscription>
    implements Subscriber<T> {
        private static final long serialVersionUID = -8730235182291002949L;
        final CombineLatestCoordinator<T, ?> parent;
        final int index;
        final int prefetch;
        final int limit;
        int produced;

        CombineLatestInnerSubscriber(CombineLatestCoordinator<T, ?> parent, int index, int prefetch) {
            this.parent = parent;
            this.index = index;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this, s)) {
                s.request(this.prefetch);
            }
        }

        @Override
        public void onNext(T t) {
            this.parent.innerValue(this.index, t);
        }

        @Override
        public void onError(Throwable t) {
            this.parent.innerError(this.index, t);
        }

        @Override
        public void onComplete() {
            this.parent.innerComplete(this.index);
        }

        public void cancel() {
            SubscriptionHelper.cancel(this);
        }

        public void requestOne() {
            int p = this.produced + 1;
            if (p == this.limit) {
                this.produced = 0;
                ((Subscription)this.get()).request(p);
            } else {
                this.produced = p;
            }
        }
    }

    static final class CombineLatestCoordinator<T, R>
    extends BasicIntQueueSubscription<R> {
        private static final long serialVersionUID = -5082275438355852221L;
        final Subscriber<? super R> actual;
        final Function<? super Object[], ? extends R> combiner;
        final CombineLatestInnerSubscriber<T>[] subscribers;
        final SpscLinkedArrayQueue<Object> queue;
        final Object[] latest;
        final boolean delayErrors;
        boolean outputFused;
        int nonEmptySources;
        int completedSources;
        volatile boolean cancelled;
        final AtomicLong requested;
        volatile boolean done;
        final AtomicReference<Throwable> error;

        CombineLatestCoordinator(Subscriber<? super R> actual2, Function<? super Object[], ? extends R> combiner, int n, int bufferSize, boolean delayErrors) {
            this.actual = actual2;
            this.combiner = combiner;
            CombineLatestInnerSubscriber[] a = new CombineLatestInnerSubscriber[n];
            for (int i = 0; i < n; ++i) {
                a[i] = new CombineLatestInnerSubscriber(this, i, bufferSize);
            }
            this.subscribers = a;
            this.latest = new Object[n];
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.requested = new AtomicLong();
            this.error = new AtomicReference();
            this.delayErrors = delayErrors;
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.cancelAll();
        }

        void subscribe(Publisher<? extends T>[] sources, int n) {
            CombineLatestInnerSubscriber<T>[] a = this.subscribers;
            for (int i = 0; i < n; ++i) {
                if (this.done || this.cancelled) {
                    return;
                }
                sources[i].subscribe(a[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void innerValue(int index, T value) {
            boolean replenishInsteadOfDrain;
            CombineLatestCoordinator combineLatestCoordinator = this;
            synchronized (combineLatestCoordinator) {
                Object[] os = this.latest;
                int localNonEmptySources = this.nonEmptySources;
                if (os[index] == null) {
                    this.nonEmptySources = ++localNonEmptySources;
                }
                os[index] = value;
                if (os.length == localNonEmptySources) {
                    this.queue.offer(this.subscribers[index], os.clone());
                    replenishInsteadOfDrain = false;
                } else {
                    replenishInsteadOfDrain = true;
                }
            }
            if (replenishInsteadOfDrain) {
                this.subscribers[index].requestOne();
            } else {
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void innerComplete(int index) {
            CombineLatestCoordinator combineLatestCoordinator = this;
            synchronized (combineLatestCoordinator) {
                Object[] os = this.latest;
                if (os[index] != null) {
                    int localCompletedSources = this.completedSources + 1;
                    if (localCompletedSources != os.length) {
                        this.completedSources = localCompletedSources;
                        return;
                    }
                    this.done = true;
                } else {
                    this.done = true;
                }
            }
            this.drain();
        }

        void innerError(int index, Throwable e) {
            if (ExceptionHelper.addThrowable(this.error, e)) {
                if (!this.delayErrors) {
                    this.cancelAll();
                    this.done = true;
                    this.drain();
                } else {
                    this.innerComplete(index);
                }
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        void drainOutput() {
            Subscriber<R> a = this.actual;
            SpscLinkedArrayQueue<Object> q = this.queue;
            int missed = 1;
            do {
                if (this.cancelled) {
                    q.clear();
                    return;
                }
                Throwable ex = this.error.get();
                if (ex != null) {
                    q.clear();
                    a.onError(ex);
                    return;
                }
                boolean d = this.done;
                boolean empty2 = q.isEmpty();
                if (!empty2) {
                    a.onNext(null);
                }
                if (!d || !empty2) continue;
                a.onComplete();
                return;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        void drainAsync() {
            Subscriber<R> a = this.actual;
            SpscLinkedArrayQueue<Object> q = this.queue;
            int missed = 1;
            do {
                long e;
                long r = this.requested.get();
                for (e = 0L; e != r; ++e) {
                    R w;
                    boolean empty2;
                    boolean d = this.done;
                    Object v = q.poll();
                    boolean bl = empty2 = v == null;
                    if (this.checkTerminated(d, empty2, a, q)) {
                        return;
                    }
                    if (empty2) break;
                    Object[] va = (Object[])q.poll();
                    try {
                        w = ObjectHelper.requireNonNull(this.combiner.apply((Object[])va), "The combiner returned a null value");
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.cancelAll();
                        ExceptionHelper.addThrowable(this.error, ex);
                        ex = ExceptionHelper.terminate(this.error);
                        a.onError(ex);
                        return;
                    }
                    a.onNext(w);
                    ((CombineLatestInnerSubscriber)v).requestOne();
                }
                if (e == r && this.checkTerminated(this.done, q.isEmpty(), a, q)) {
                    return;
                }
                if (e == 0L || r == Long.MAX_VALUE) continue;
                this.requested.addAndGet(-e);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            if (this.outputFused) {
                this.drainOutput();
            } else {
                this.drainAsync();
            }
        }

        boolean checkTerminated(boolean d, boolean empty2, Subscriber<?> a, SpscLinkedArrayQueue<?> q) {
            if (this.cancelled) {
                this.cancelAll();
                q.clear();
                return true;
            }
            if (d) {
                if (this.delayErrors) {
                    if (empty2) {
                        Throwable e = ExceptionHelper.terminate(this.error);
                        if (e != null && e != ExceptionHelper.TERMINATED) {
                            a.onError(e);
                        } else {
                            a.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable e = ExceptionHelper.terminate(this.error);
                    if (e != null && e != ExceptionHelper.TERMINATED) {
                        this.cancelAll();
                        q.clear();
                        a.onError(e);
                        return true;
                    }
                    if (empty2) {
                        this.cancelAll();
                        a.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }

        void cancelAll() {
            for (CombineLatestInnerSubscriber<T> inner2 : this.subscribers) {
                inner2.cancel();
            }
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 4) != 0) {
                return 0;
            }
            int m = requestedMode & 2;
            this.outputFused = m != 0;
            return m;
        }

        @Override
        public R poll() throws Exception {
            Object e = this.queue.poll();
            if (e == null) {
                return null;
            }
            Object[] a = (Object[])this.queue.poll();
            R r = this.combiner.apply((Object[])a);
            ((CombineLatestInnerSubscriber)e).requestOne();
            return r;
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }
    }
}

