/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.fuseable.FuseToFlowable;
import io.reactivex.internal.operators.flowable.FlowableElementAt;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.NoSuchElementException;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableElementAtSingle<T>
extends Single<T>
implements FuseToFlowable<T> {
    final Publisher<T> source;
    final long index;
    final T defaultValue;

    public FlowableElementAtSingle(Publisher<T> source, long index, T defaultValue) {
        this.source = source;
        this.index = index;
        this.defaultValue = defaultValue;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> s) {
        this.source.subscribe(new ElementAtSubscriber<T>(s, this.index, this.defaultValue));
    }

    @Override
    public Flowable<T> fuseToFlowable() {
        return RxJavaPlugins.onAssembly(new FlowableElementAt<T>(this.source, this.index, this.defaultValue));
    }

    static final class ElementAtSubscriber<T>
    implements Subscriber<T>,
    Disposable {
        final SingleObserver<? super T> actual;
        final long index;
        final T defaultValue;
        Subscription s;
        long count;
        boolean done;

        ElementAtSubscriber(SingleObserver<? super T> actual2, long index, T defaultValue) {
            this.actual = actual2;
            this.index = index;
            this.defaultValue = defaultValue;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            long c = this.count;
            if (c == this.index) {
                this.done = true;
                this.s.cancel();
                this.s = SubscriptionHelper.CANCELLED;
                this.actual.onSuccess(t);
                return;
            }
            this.count = c + 1L;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.s = SubscriptionHelper.CANCELLED;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.s = SubscriptionHelper.CANCELLED;
            if (!this.done) {
                this.done = true;
                T v = this.defaultValue;
                if (v != null) {
                    this.actual.onSuccess(v);
                } else {
                    this.actual.onError(new NoSuchElementException());
                }
            }
        }

        @Override
        public void dispose() {
            this.s.cancel();
            this.s = SubscriptionHelper.CANCELLED;
        }

        @Override
        public boolean isDisposed() {
            return this.s == SubscriptionHelper.CANCELLED;
        }
    }
}

