/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscribers.BasicFuseableConditionalSubscriber;
import io.reactivex.internal.subscribers.BasicFuseableSubscriber;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public final class FlowableMap<T, U>
extends AbstractFlowableWithUpstream<T, U> {
    final Function<? super T, ? extends U> mapper;

    public FlowableMap(Publisher<T> source, Function<? super T, ? extends U> mapper) {
        super(source);
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s) {
        if (s instanceof ConditionalSubscriber) {
            this.source.subscribe(new MapConditionalSubscriber<T, U>((ConditionalSubscriber)s, this.mapper));
        } else {
            this.source.subscribe(new MapSubscriber<T, U>(s, this.mapper));
        }
    }

    static final class MapConditionalSubscriber<T, U>
    extends BasicFuseableConditionalSubscriber<T, U> {
        final Function<? super T, ? extends U> mapper;

        MapConditionalSubscriber(ConditionalSubscriber<? super U> actual2, Function<? super T, ? extends U> function) {
            super(actual2);
            this.mapper = function;
        }

        @Override
        public void onNext(T t) {
            U v;
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.actual.onNext(null);
                return;
            }
            try {
                v = ObjectHelper.requireNonNull(this.mapper.apply(t), "The mapper function returned a null value.");
            }
            catch (Throwable ex) {
                this.fail(ex);
                return;
            }
            this.actual.onNext(v);
        }

        @Override
        public boolean tryOnNext(T t) {
            U v;
            if (this.done) {
                return false;
            }
            try {
                v = ObjectHelper.requireNonNull(this.mapper.apply(t), "The mapper function returned a null value.");
            }
            catch (Throwable ex) {
                this.fail(ex);
                return true;
            }
            return this.actual.tryOnNext(v);
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        public U poll() throws Exception {
            Object t = this.qs.poll();
            return t != null ? (U)ObjectHelper.requireNonNull(this.mapper.apply(t), "The mapper function returned a null value.") : null;
        }
    }

    static final class MapSubscriber<T, U>
    extends BasicFuseableSubscriber<T, U> {
        final Function<? super T, ? extends U> mapper;

        MapSubscriber(Subscriber<? super U> actual2, Function<? super T, ? extends U> mapper) {
            super(actual2);
            this.mapper = mapper;
        }

        @Override
        public void onNext(T t) {
            U v;
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.actual.onNext(null);
                return;
            }
            try {
                v = ObjectHelper.requireNonNull(this.mapper.apply(t), "The mapper function returned a null value.");
            }
            catch (Throwable ex) {
                this.fail(ex);
                return;
            }
            this.actual.onNext(v);
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        public U poll() throws Exception {
            Object t = this.qs.poll();
            return t != null ? (U)ObjectHelper.requireNonNull(this.mapper.apply(t), "The mapper function returned a null value.") : null;
        }
    }
}

