/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.BackpressureOverflowStrategy;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Action;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableOnBackpressureBufferStrategy<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long bufferSize;
    final Action onOverflow;
    final BackpressureOverflowStrategy strategy;

    public FlowableOnBackpressureBufferStrategy(Publisher<T> source, long bufferSize, Action onOverflow, BackpressureOverflowStrategy strategy) {
        super(source);
        this.bufferSize = bufferSize;
        this.onOverflow = onOverflow;
        this.strategy = strategy;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new OnBackpressureBufferStrategySubscriber<T>(s, this.onOverflow, this.strategy, this.bufferSize));
    }

    static final class OnBackpressureBufferStrategySubscriber<T>
    extends AtomicInteger
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = 3240706908776709697L;
        final Subscriber<? super T> actual;
        final Action onOverflow;
        final BackpressureOverflowStrategy strategy;
        final long bufferSize;
        final AtomicLong requested;
        final Deque<T> deque;
        Subscription s;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;

        OnBackpressureBufferStrategySubscriber(Subscriber<? super T> actual2, Action onOverflow, BackpressureOverflowStrategy strategy, long bufferSize) {
            this.actual = actual2;
            this.onOverflow = onOverflow;
            this.strategy = strategy;
            this.bufferSize = bufferSize;
            this.requested = new AtomicLong();
            this.deque = new ArrayDeque<T>();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            Deque<T> dq;
            if (this.done) {
                return;
            }
            boolean callOnOverflow = false;
            boolean callError = false;
            Deque<T> deque = dq = this.deque;
            synchronized (deque) {
                if ((long)dq.size() == this.bufferSize) {
                    switch (this.strategy) {
                        case DROP_LATEST: {
                            dq.pollLast();
                            dq.offer(t);
                            callOnOverflow = true;
                            break;
                        }
                        case DROP_OLDEST: {
                            dq.poll();
                            dq.offer(t);
                            callOnOverflow = true;
                            break;
                        }
                        default: {
                            callError = true;
                            break;
                        }
                    }
                } else {
                    dq.offer(t);
                }
            }
            if (callOnOverflow) {
                if (this.onOverflow != null) {
                    try {
                        this.onOverflow.run();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.s.cancel();
                        this.onError(ex);
                    }
                }
            } else if (callError) {
                this.s.cancel();
                this.onError(new MissingBackpressureException());
            } else {
                this.drain();
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.error = t;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.s.cancel();
            if (this.getAndIncrement() == 0) {
                this.clear(this.deque);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear(Deque<T> dq) {
            Deque<T> deque = dq;
            synchronized (deque) {
                dq.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Deque<T> dq = this.deque;
            Subscriber<T> a = this.actual;
            do {
                boolean d;
                long e;
                long r = this.requested.get();
                for (e = 0L; e != r; ++e) {
                    boolean empty2;
                    T v;
                    if (this.cancelled) {
                        this.clear(dq);
                        return;
                    }
                    d = this.done;
                    Deque<T> deque = dq;
                    synchronized (deque) {
                        v = dq.poll();
                    }
                    boolean bl = empty2 = v == null;
                    if (d) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.clear(dq);
                            a.onError(ex);
                            return;
                        }
                        if (empty2) {
                            a.onComplete();
                            return;
                        }
                    }
                    if (empty2) break;
                    a.onNext(v);
                }
                if (e == r) {
                    boolean empty3;
                    if (this.cancelled) {
                        this.clear(dq);
                        return;
                    }
                    d = this.done;
                    Deque<T> empty2 = dq;
                    synchronized (empty2) {
                        empty3 = dq.isEmpty();
                    }
                    if (d) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.clear(dq);
                            a.onError(ex);
                            return;
                        }
                        if (empty3) {
                            a.onComplete();
                            return;
                        }
                    }
                }
                if (e == 0L) continue;
                BackpressureHelper.produced(this.requested, e);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

