/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscribers.SinglePostCompleteSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public final class FlowableScanSeed<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final BiFunction<R, ? super T, R> accumulator;
    final Callable<R> seedSupplier;

    public FlowableScanSeed(Publisher<T> source, Callable<R> seedSupplier, BiFunction<R, ? super T, R> accumulator) {
        super(source);
        this.accumulator = accumulator;
        this.seedSupplier = seedSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        R r;
        try {
            r = ObjectHelper.requireNonNull(this.seedSupplier.call(), "The seed supplied is null");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptySubscription.error(e, s);
            return;
        }
        this.source.subscribe(new ScanSeedSubscriber<T, R>(s, this.accumulator, r));
    }

    static final class ScanSeedSubscriber<T, R>
    extends SinglePostCompleteSubscriber<T, R> {
        private static final long serialVersionUID = -1776795561228106469L;
        final BiFunction<R, ? super T, R> accumulator;

        ScanSeedSubscriber(Subscriber<? super R> actual2, BiFunction<R, ? super T, R> accumulator, R value) {
            super(actual2);
            this.accumulator = accumulator;
            this.value = value;
        }

        @Override
        public void onNext(T t) {
            R u;
            Object v = this.value;
            try {
                u = ObjectHelper.requireNonNull(this.accumulator.apply(v, t), "The accumulator returned a null value");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.s.cancel();
                this.onError(e);
                return;
            }
            this.value = u;
            ++this.produced;
            this.actual.onNext(v);
        }

        @Override
        public void onError(Throwable t) {
            this.value = null;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.complete(this.value);
        }
    }
}

