/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.operators.flowable.FlowableScalarXMap;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSwitchMap<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final int bufferSize;
    final boolean delayErrors;

    public FlowableSwitchMap(Publisher<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, int bufferSize, boolean delayErrors) {
        super(source);
        this.mapper = mapper;
        this.bufferSize = bufferSize;
        this.delayErrors = delayErrors;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        if (FlowableScalarXMap.tryScalarXMapSubscribe(this.source, s, this.mapper)) {
            return;
        }
        this.source.subscribe(new SwitchMapSubscriber<T, R>(s, this.mapper, this.bufferSize, this.delayErrors));
    }

    static final class SwitchMapInnerSubscriber<T, R>
    extends AtomicReference<Subscription>
    implements Subscriber<R> {
        private static final long serialVersionUID = 3837284832786408377L;
        final SwitchMapSubscriber<T, R> parent;
        final long index;
        final int bufferSize;
        volatile SimpleQueue<R> queue;
        volatile boolean done;
        int fusionMode;

        SwitchMapInnerSubscriber(SwitchMapSubscriber<T, R> parent, long index, int bufferSize) {
            this.parent = parent;
            this.index = index;
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this, s)) {
                if (s instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s;
                    int m = qs.requestFusion(3);
                    if (m == 1) {
                        this.fusionMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m == 2) {
                        this.fusionMode = m;
                        this.queue = qs;
                        s.request(this.bufferSize);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<R>(this.bufferSize);
                s.request(this.bufferSize);
            }
        }

        @Override
        public void onNext(R t) {
            SwitchMapSubscriber<T, R> p = this.parent;
            if (this.index == p.unique) {
                if (this.fusionMode == 0 && !this.queue.offer(t)) {
                    this.onError(new MissingBackpressureException("Queue full?!"));
                    return;
                }
                p.drain();
            }
        }

        @Override
        public void onError(Throwable t) {
            SwitchMapSubscriber<T, R> p = this.parent;
            if (this.index == p.unique && p.error.addThrowable(t)) {
                if (!p.delayErrors) {
                    p.s.cancel();
                }
                this.done = true;
                p.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            SwitchMapSubscriber<T, R> p = this.parent;
            if (this.index == p.unique) {
                this.done = true;
                p.drain();
            }
        }

        public void cancel() {
            SubscriptionHelper.cancel(this);
        }
    }

    static final class SwitchMapSubscriber<T, R>
    extends AtomicInteger
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = -3491074160481096299L;
        final Subscriber<? super R> actual;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final int bufferSize;
        final boolean delayErrors;
        volatile boolean done;
        final AtomicThrowable error;
        volatile boolean cancelled;
        Subscription s;
        final AtomicReference<SwitchMapInnerSubscriber<T, R>> active = new AtomicReference();
        final AtomicLong requested = new AtomicLong();
        static final SwitchMapInnerSubscriber<Object, Object> CANCELLED = new SwitchMapInnerSubscriber(null, -1L, 1);
        volatile long unique;

        SwitchMapSubscriber(Subscriber<? super R> actual2, Function<? super T, ? extends Publisher<? extends R>> mapper, int bufferSize, boolean delayErrors) {
            this.actual = actual2;
            this.mapper = mapper;
            this.bufferSize = bufferSize;
            this.delayErrors = delayErrors;
            this.error = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            Publisher<R> p;
            long c;
            if (this.done) {
                return;
            }
            this.unique = c = this.unique + 1L;
            SwitchMapInnerSubscriber<T, R> inner2 = this.active.get();
            if (inner2 != null) {
                inner2.cancel();
            }
            try {
                p = ObjectHelper.requireNonNull(this.mapper.apply(t), "The publisher returned is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.s.cancel();
                this.onError(e);
                return;
            }
            SwitchMapInnerSubscriber nextInner = new SwitchMapInnerSubscriber(this, c, this.bufferSize);
            while ((inner2 = this.active.get()) != CANCELLED) {
                if (!this.active.compareAndSet(inner2, nextInner)) continue;
                p.subscribe(nextInner);
                break;
            }
        }

        @Override
        public void onError(Throwable t) {
            if (!this.done && this.error.addThrowable(t)) {
                if (!this.delayErrors) {
                    this.disposeInner();
                }
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                if (this.unique == 0L) {
                    this.s.request(Long.MAX_VALUE);
                } else {
                    this.drain();
                }
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.cancel();
                this.disposeInner();
            }
        }

        void disposeInner() {
            SwitchMapInnerSubscriber<Object, Object> a = this.active.get();
            if (a != CANCELLED && (a = this.active.getAndSet(CANCELLED)) != CANCELLED && a != null) {
                a.cancel();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Subscriber<R> a = this.actual;
            int missing = 1;
            while (true) {
                SwitchMapInnerSubscriber<T, R> inner2;
                SimpleQueue q;
                if (this.cancelled) {
                    this.active.lazySet(null);
                    return;
                }
                if (this.done) {
                    Throwable err;
                    if (this.delayErrors) {
                        if (this.active.get() == null) {
                            err = (Throwable)this.error.get();
                            if (err != null) {
                                a.onError(this.error.terminate());
                            } else {
                                a.onComplete();
                            }
                            return;
                        }
                    } else {
                        err = (Throwable)this.error.get();
                        if (err != null) {
                            this.disposeInner();
                            a.onError(this.error.terminate());
                            return;
                        }
                        if (this.active.get() == null) {
                            a.onComplete();
                            return;
                        }
                    }
                }
                SimpleQueue simpleQueue = q = (inner2 = this.active.get()) != null ? inner2.queue : null;
                if (q != null) {
                    long e;
                    if (inner2.done) {
                        if (!this.delayErrors) {
                            Throwable err = (Throwable)this.error.get();
                            if (err != null) {
                                this.disposeInner();
                                a.onError(this.error.terminate());
                                return;
                            }
                            if (q.isEmpty()) {
                                this.active.compareAndSet(inner2, null);
                                continue;
                            }
                        } else if (q.isEmpty()) {
                            this.active.compareAndSet(inner2, null);
                            continue;
                        }
                    }
                    long r = this.requested.get();
                    boolean retry2 = false;
                    for (e = 0L; e != r; ++e) {
                        boolean empty2;
                        Object v;
                        if (this.cancelled) {
                            return;
                        }
                        boolean d = inner2.done;
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            inner2.cancel();
                            this.error.addThrowable(ex);
                            d = true;
                            v = null;
                        }
                        boolean bl = empty2 = v == null;
                        if (inner2 != this.active.get()) {
                            retry2 = true;
                            break;
                        }
                        if (d) {
                            if (!this.delayErrors) {
                                Throwable err = (Throwable)this.error.get();
                                if (err != null) {
                                    a.onError(this.error.terminate());
                                    return;
                                }
                                if (empty2) {
                                    this.active.compareAndSet(inner2, null);
                                    retry2 = true;
                                    break;
                                }
                            } else if (empty2) {
                                this.active.compareAndSet(inner2, null);
                                retry2 = true;
                                break;
                            }
                        }
                        if (empty2) break;
                        a.onNext(v);
                    }
                    if (e != 0L && !this.cancelled) {
                        if (r != Long.MAX_VALUE) {
                            this.requested.addAndGet(-e);
                        }
                        ((Subscription)inner2.get()).request(e);
                    }
                    if (retry2) continue;
                }
                if ((missing = this.addAndGet(-missing)) == 0) break;
            }
        }

        static {
            CANCELLED.cancel();
        }
    }
}

