/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;

public final class MaybeAmb<T>
extends Maybe<T> {
    private final MaybeSource<? extends T>[] sources;
    private final Iterable<? extends MaybeSource<? extends T>> sourcesIterable;

    public MaybeAmb(MaybeSource<? extends T>[] sources, Iterable<? extends MaybeSource<? extends T>> sourcesIterable) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        void var5_8;
        MaybeSource<? extends T>[] sources = this.sources;
        int count2 = 0;
        if (sources == null) {
            sources = new MaybeSource[8];
            try {
                for (MaybeSource<? extends T> maybeSource : this.sourcesIterable) {
                    if (maybeSource == null) {
                        EmptyDisposable.error((Throwable)new NullPointerException("One of the sources is null"), observer);
                        return;
                    }
                    if (count2 == sources.length) {
                        MaybeSource[] b = new MaybeSource[count2 + (count2 >> 2)];
                        System.arraycopy(sources, 0, b, 0, count2);
                        sources = b;
                    }
                    sources[count2++] = maybeSource;
                }
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                EmptyDisposable.error(e, observer);
                return;
            }
        } else {
            count2 = sources.length;
        }
        AmbMaybeObserver<T> parent = new AmbMaybeObserver<T>(observer);
        observer.onSubscribe(parent);
        boolean bl = false;
        while (var5_8 < count2) {
            MaybeSource<T> s = sources[var5_8];
            if (parent.isDisposed()) {
                return;
            }
            if (s == null) {
                parent.onError(new NullPointerException("One of the MaybeSources is null"));
                return;
            }
            s.subscribe(parent);
            ++var5_8;
        }
        if (count2 == 0) {
            observer.onComplete();
        }
    }

    static final class AmbMaybeObserver<T>
    extends AtomicBoolean
    implements MaybeObserver<T>,
    Disposable {
        private static final long serialVersionUID = -7044685185359438206L;
        final MaybeObserver<? super T> actual;
        final CompositeDisposable set;

        AmbMaybeObserver(MaybeObserver<? super T> actual2) {
            this.actual = actual2;
            this.set = new CompositeDisposable();
        }

        @Override
        public void dispose() {
            if (this.compareAndSet(false, true)) {
                this.set.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get();
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.set.add(d);
        }

        @Override
        public void onSuccess(T value) {
            if (this.compareAndSet(false, true)) {
                this.set.dispose();
                this.actual.onSuccess(value);
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.compareAndSet(false, true)) {
                this.set.dispose();
                this.actual.onError(e);
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            if (this.compareAndSet(false, true)) {
                this.set.dispose();
                this.actual.onComplete();
            }
        }
    }
}

