/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.maybe.AbstractMaybeWithUpstream;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeOnErrorNext<T>
extends AbstractMaybeWithUpstream<T, T> {
    final Function<? super Throwable, ? extends MaybeSource<? extends T>> resumeFunction;
    final boolean allowFatal;

    public MaybeOnErrorNext(MaybeSource<T> source, Function<? super Throwable, ? extends MaybeSource<? extends T>> resumeFunction, boolean allowFatal) {
        super(source);
        this.resumeFunction = resumeFunction;
        this.allowFatal = allowFatal;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new OnErrorNextMaybeObserver<T>(observer, this.resumeFunction, this.allowFatal));
    }

    static final class OnErrorNextMaybeObserver<T>
    extends AtomicReference<Disposable>
    implements MaybeObserver<T>,
    Disposable {
        private static final long serialVersionUID = 2026620218879969836L;
        final MaybeObserver<? super T> actual;
        final Function<? super Throwable, ? extends MaybeSource<? extends T>> resumeFunction;
        final boolean allowFatal;

        OnErrorNextMaybeObserver(MaybeObserver<? super T> actual2, Function<? super Throwable, ? extends MaybeSource<? extends T>> resumeFunction, boolean allowFatal) {
            this.actual = actual2;
            this.resumeFunction = resumeFunction;
            this.allowFatal = allowFatal;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.setOnce(this, d)) {
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.actual.onSuccess(value);
        }

        @Override
        public void onError(Throwable e) {
            MaybeSource<? super T> m;
            if (!this.allowFatal && !(e instanceof Exception)) {
                this.actual.onError(e);
                return;
            }
            try {
                m = ObjectHelper.requireNonNull(this.resumeFunction.apply(e), "The resumeFunction returned a null MaybeSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.actual.onError(new CompositeException(e, ex));
                return;
            }
            DisposableHelper.replace(this, null);
            m.subscribe(new NextMaybeObserver<T>(this.actual, this));
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
        }

        static final class NextMaybeObserver<T>
        implements MaybeObserver<T> {
            final MaybeObserver<? super T> actual;
            final AtomicReference<Disposable> d;

            NextMaybeObserver(MaybeObserver<? super T> actual2, AtomicReference<Disposable> d) {
                this.actual = actual2;
                this.d = d;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this.d, d);
            }

            @Override
            public void onSuccess(T value) {
                this.actual.onSuccess(value);
            }

            @Override
            public void onError(Throwable e) {
                this.actual.onError(e);
            }

            @Override
            public void onComplete() {
                this.actual.onComplete();
            }
        }
    }
}

