/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableAmb<T>
extends Observable<T> {
    final ObservableSource<? extends T>[] sources;
    final Iterable<? extends ObservableSource<? extends T>> sourcesIterable;

    public ObservableAmb(ObservableSource<? extends T>[] sources, Iterable<? extends ObservableSource<? extends T>> sourcesIterable) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
    }

    @Override
    public void subscribeActual(Observer<? super T> s) {
        ObservableSource<? extends T>[] sources = this.sources;
        int count2 = 0;
        if (sources == null) {
            sources = new Observable[8];
            try {
                for (ObservableSource<? extends T> observableSource : this.sourcesIterable) {
                    if (observableSource == null) {
                        EmptyDisposable.error((Throwable)new NullPointerException("One of the sources is null"), s);
                        return;
                    }
                    if (count2 == sources.length) {
                        ObservableSource[] b = new ObservableSource[count2 + (count2 >> 2)];
                        System.arraycopy(sources, 0, b, 0, count2);
                        sources = b;
                    }
                    sources[count2++] = observableSource;
                }
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                EmptyDisposable.error(e, s);
                return;
            }
        } else {
            count2 = sources.length;
        }
        if (count2 == 0) {
            EmptyDisposable.complete(s);
            return;
        }
        if (count2 == 1) {
            sources[0].subscribe(s);
            return;
        }
        AmbCoordinator<? extends T> ac = new AmbCoordinator<T>(s, count2);
        ac.subscribe(sources);
    }

    static final class AmbInnerObserver<T>
    extends AtomicReference<Disposable>
    implements Observer<T> {
        private static final long serialVersionUID = -1185974347409665484L;
        final AmbCoordinator<T> parent;
        final int index;
        final Observer<? super T> actual;
        boolean won;

        AmbInnerObserver(AmbCoordinator<T> parent, int index, Observer<? super T> actual2) {
            this.parent = parent;
            this.index = index;
            this.actual = actual2;
        }

        @Override
        public void onSubscribe(Disposable s) {
            DisposableHelper.setOnce(this, s);
        }

        @Override
        public void onNext(T t) {
            if (this.won) {
                this.actual.onNext(t);
            } else if (this.parent.win(this.index)) {
                this.won = true;
                this.actual.onNext(t);
            } else {
                ((Disposable)this.get()).dispose();
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.won) {
                this.actual.onError(t);
            } else if (this.parent.win(this.index)) {
                this.won = true;
                this.actual.onError(t);
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (this.won) {
                this.actual.onComplete();
            } else if (this.parent.win(this.index)) {
                this.won = true;
                this.actual.onComplete();
            }
        }

        public void dispose() {
            DisposableHelper.dispose(this);
        }
    }

    static final class AmbCoordinator<T>
    implements Disposable {
        final Observer<? super T> actual;
        final AmbInnerObserver<T>[] observers;
        final AtomicInteger winner = new AtomicInteger();

        AmbCoordinator(Observer<? super T> actual2, int count2) {
            this.actual = actual2;
            this.observers = new AmbInnerObserver[count2];
        }

        public void subscribe(ObservableSource<? extends T>[] sources) {
            int i;
            AmbInnerObserver<T>[] as = this.observers;
            int len = as.length;
            for (i = 0; i < len; ++i) {
                as[i] = new AmbInnerObserver<T>(this, i + 1, this.actual);
            }
            this.winner.lazySet(0);
            this.actual.onSubscribe(this);
            for (i = 0; i < len; ++i) {
                if (this.winner.get() != 0) {
                    return;
                }
                sources[i].subscribe(as[i]);
            }
        }

        public boolean win(int index) {
            int w = this.winner.get();
            if (w == 0) {
                if (this.winner.compareAndSet(0, index)) {
                    AmbInnerObserver<T>[] a = this.observers;
                    int n = a.length;
                    for (int i = 0; i < n; ++i) {
                        if (i + 1 == index) continue;
                        a[i].dispose();
                    }
                    return true;
                }
                return false;
            }
            return w == index;
        }

        @Override
        public void dispose() {
            if (this.winner.get() != -1) {
                this.winner.lazySet(-1);
                for (AmbInnerObserver<T> a : this.observers) {
                    a.dispose();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.winner.get() == -1;
        }
    }
}

