/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.functions.BiPredicate;
import io.reactivex.functions.Function;
import io.reactivex.internal.observers.BasicFuseableObserver;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableDistinctUntilChanged<T, K>
extends AbstractObservableWithUpstream<T, T> {
    final Function<? super T, K> keySelector;
    final BiPredicate<? super K, ? super K> comparer;

    public ObservableDistinctUntilChanged(ObservableSource<T> source, Function<? super T, K> keySelector, BiPredicate<? super K, ? super K> comparer) {
        super(source);
        this.keySelector = keySelector;
        this.comparer = comparer;
    }

    @Override
    protected void subscribeActual(Observer<? super T> s) {
        this.source.subscribe(new DistinctUntilChangedObserver<T, K>(s, this.keySelector, this.comparer));
    }

    static final class DistinctUntilChangedObserver<T, K>
    extends BasicFuseableObserver<T, T> {
        final Function<? super T, K> keySelector;
        final BiPredicate<? super K, ? super K> comparer;
        K last;
        boolean hasValue;

        DistinctUntilChangedObserver(Observer<? super T> actual2, Function<? super T, K> keySelector, BiPredicate<? super K, ? super K> comparer) {
            super(actual2);
            this.keySelector = keySelector;
            this.comparer = comparer;
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.actual.onNext(t);
                return;
            }
            try {
                K key = this.keySelector.apply(t);
                if (this.hasValue) {
                    boolean equal = this.comparer.test(this.last, key);
                    this.last = key;
                    if (equal) {
                        return;
                    }
                } else {
                    this.hasValue = true;
                    this.last = key;
                }
            }
            catch (Throwable ex) {
                this.fail(ex);
                return;
            }
            this.actual.onNext(t);
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        public T poll() throws Exception {
            Object v;
            while ((v = this.qs.poll()) != null) {
                K key = this.keySelector.apply(v);
                if (!this.hasValue) {
                    this.hasValue = true;
                    this.last = key;
                    return v;
                }
                if (!this.comparer.test(this.last, key)) {
                    this.last = key;
                    return v;
                }
                this.last = key;
            }
            return null;
        }
    }
}

