/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableRetryPredicate<T>
extends AbstractObservableWithUpstream<T, T> {
    final Predicate<? super Throwable> predicate;
    final long count;

    public ObservableRetryPredicate(Observable<T> source, long count2, Predicate<? super Throwable> predicate) {
        super(source);
        this.predicate = predicate;
        this.count = count2;
    }

    @Override
    public void subscribeActual(Observer<? super T> s) {
        SequentialDisposable sa = new SequentialDisposable();
        s.onSubscribe(sa);
        RepeatObserver<T> rs = new RepeatObserver<T>(s, this.count, this.predicate, sa, this.source);
        rs.subscribeNext();
    }

    static final class RepeatObserver<T>
    extends AtomicInteger
    implements Observer<T> {
        private static final long serialVersionUID = -7098360935104053232L;
        final Observer<? super T> actual;
        final SequentialDisposable sa;
        final ObservableSource<? extends T> source;
        final Predicate<? super Throwable> predicate;
        long remaining;

        RepeatObserver(Observer<? super T> actual2, long count2, Predicate<? super Throwable> predicate, SequentialDisposable sa, ObservableSource<? extends T> source) {
            this.actual = actual2;
            this.sa = sa;
            this.source = source;
            this.predicate = predicate;
            this.remaining = count2;
        }

        @Override
        public void onSubscribe(Disposable s) {
            this.sa.update(s);
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            long r = this.remaining;
            if (r != Long.MAX_VALUE) {
                this.remaining = r - 1L;
            }
            if (r == 0L) {
                this.actual.onError(t);
            } else {
                boolean b;
                try {
                    b = this.predicate.test(t);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.actual.onError(new CompositeException(t, e));
                    return;
                }
                if (!b) {
                    this.actual.onError(t);
                    return;
                }
                this.subscribeNext();
            }
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
        }

        void subscribeNext() {
            block2: {
                if (this.getAndIncrement() != 0) break block2;
                int missed = 1;
                do {
                    if (this.sa.isDisposed()) {
                        return;
                    }
                    this.source.subscribe(this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

