/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.ObserverFullArbiter;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.FullArbiterObserver;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.observers.SerializedObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableTimeout<T, U, V>
extends AbstractObservableWithUpstream<T, T> {
    final ObservableSource<U> firstTimeoutIndicator;
    final Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator;
    final ObservableSource<? extends T> other;

    public ObservableTimeout(ObservableSource<T> source, ObservableSource<U> firstTimeoutIndicator, Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator, ObservableSource<? extends T> other) {
        super(source);
        this.firstTimeoutIndicator = firstTimeoutIndicator;
        this.itemTimeoutIndicator = itemTimeoutIndicator;
        this.other = other;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        if (this.other == null) {
            this.source.subscribe(new TimeoutObserver(new SerializedObserver<T>(t), this.firstTimeoutIndicator, this.itemTimeoutIndicator));
        } else {
            this.source.subscribe(new TimeoutOtherObserver(t, this.firstTimeoutIndicator, this.itemTimeoutIndicator, this.other));
        }
    }

    static final class TimeoutOtherObserver<T, U, V>
    extends AtomicReference<Disposable>
    implements Observer<T>,
    Disposable,
    OnTimeout {
        private static final long serialVersionUID = -1957813281749686898L;
        final Observer<? super T> actual;
        final ObservableSource<U> firstTimeoutIndicator;
        final Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator;
        final ObservableSource<? extends T> other;
        final ObserverFullArbiter<T> arbiter;
        Disposable s;
        boolean done;
        volatile long index;

        TimeoutOtherObserver(Observer<? super T> actual2, ObservableSource<U> firstTimeoutIndicator, Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator, ObservableSource<? extends T> other) {
            this.actual = actual2;
            this.firstTimeoutIndicator = firstTimeoutIndicator;
            this.itemTimeoutIndicator = itemTimeoutIndicator;
            this.other = other;
            this.arbiter = new ObserverFullArbiter<T>(actual2, this, 8);
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.arbiter.setDisposable(s);
                Observer<T> a = this.actual;
                ObservableSource<U> p = this.firstTimeoutIndicator;
                if (p != null) {
                    TimeoutInnerObserver tis = new TimeoutInnerObserver(this, 0L);
                    if (this.compareAndSet(null, tis)) {
                        a.onSubscribe(this.arbiter);
                        p.subscribe(tis);
                    }
                } else {
                    a.onSubscribe(this.arbiter);
                }
            }
        }

        @Override
        public void onNext(T t) {
            ObservableSource<V> p;
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            if (!this.arbiter.onNext(t, this.s)) {
                return;
            }
            Disposable d = (Disposable)this.get();
            if (d != null) {
                d.dispose();
            }
            try {
                p = ObjectHelper.requireNonNull(this.itemTimeoutIndicator.apply(t), "The ObservableSource returned is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(e);
                return;
            }
            TimeoutInnerObserver tis = new TimeoutInnerObserver(this, idx);
            if (this.compareAndSet(d, tis)) {
                p.subscribe(tis);
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.dispose();
            this.arbiter.onError(t, this.s);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.dispose();
            this.arbiter.onComplete(this.s);
        }

        @Override
        public void dispose() {
            if (DisposableHelper.dispose(this)) {
                this.s.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void timeout(long idx) {
            if (idx == this.index) {
                this.dispose();
                this.other.subscribe(new FullArbiterObserver<T>(this.arbiter));
            }
        }

        @Override
        public void innerError(Throwable e) {
            this.s.dispose();
            this.actual.onError(e);
        }
    }

    static final class TimeoutInnerObserver<T, U, V>
    extends DisposableObserver<Object> {
        final OnTimeout parent;
        final long index;
        boolean done;

        TimeoutInnerObserver(OnTimeout parent, long index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onNext(Object t) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.dispose();
            this.parent.timeout(this.index);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.parent.innerError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.timeout(this.index);
        }
    }

    static interface OnTimeout {
        public void timeout(long var1);

        public void innerError(Throwable var1);
    }

    static final class TimeoutObserver<T, U, V>
    extends AtomicReference<Disposable>
    implements Observer<T>,
    Disposable,
    OnTimeout {
        private static final long serialVersionUID = 2672739326310051084L;
        final Observer<? super T> actual;
        final ObservableSource<U> firstTimeoutIndicator;
        final Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator;
        Disposable s;
        volatile long index;

        TimeoutObserver(Observer<? super T> actual2, ObservableSource<U> firstTimeoutIndicator, Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator) {
            this.actual = actual2;
            this.firstTimeoutIndicator = firstTimeoutIndicator;
            this.itemTimeoutIndicator = itemTimeoutIndicator;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                Observer<T> a = this.actual;
                ObservableSource<U> p = this.firstTimeoutIndicator;
                if (p != null) {
                    TimeoutInnerObserver tis = new TimeoutInnerObserver(this, 0L);
                    if (this.compareAndSet(null, tis)) {
                        a.onSubscribe(this);
                        p.subscribe(tis);
                    }
                } else {
                    a.onSubscribe(this);
                }
            }
        }

        @Override
        public void onNext(T t) {
            ObservableSource<V> p;
            long idx;
            this.index = idx = this.index + 1L;
            this.actual.onNext(t);
            Disposable d = (Disposable)this.get();
            if (d != null) {
                d.dispose();
            }
            try {
                p = ObjectHelper.requireNonNull(this.itemTimeoutIndicator.apply(t), "The ObservableSource returned is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.dispose();
                this.actual.onError(e);
                return;
            }
            TimeoutInnerObserver tis = new TimeoutInnerObserver(this, idx);
            if (this.compareAndSet(d, tis)) {
                p.subscribe(tis);
            }
        }

        @Override
        public void onError(Throwable t) {
            DisposableHelper.dispose(this);
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            DisposableHelper.dispose(this);
            this.actual.onComplete();
        }

        @Override
        public void dispose() {
            if (DisposableHelper.dispose(this)) {
                this.s.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void timeout(long idx) {
            if (idx == this.index) {
                this.dispose();
                this.actual.onError(new TimeoutException());
            }
        }

        @Override
        public void innerError(Throwable e) {
            this.s.dispose();
            this.actual.onError(e);
        }
    }
}

