/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;

public final class SingleDoOnError<T>
extends Single<T> {
    final SingleSource<T> source;
    final Consumer<? super Throwable> onError;

    public SingleDoOnError(SingleSource<T> source, Consumer<? super Throwable> onError2) {
        this.source = source;
        this.onError = onError2;
    }

    @Override
    protected void subscribeActual(final SingleObserver<? super T> s) {
        this.source.subscribe(new SingleObserver<T>(){

            @Override
            public void onSubscribe(Disposable d) {
                s.onSubscribe(d);
            }

            @Override
            public void onSuccess(T value) {
                s.onSuccess(value);
            }

            @Override
            public void onError(Throwable e) {
                try {
                    SingleDoOnError.this.onError.accept(e);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    e = new CompositeException(e, ex);
                }
                s.onError(e);
            }
        });
    }
}

