/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.plugins.RxJavaPlugins;

public final class SingleDoOnSubscribe<T>
extends Single<T> {
    final SingleSource<T> source;
    final Consumer<? super Disposable> onSubscribe;

    public SingleDoOnSubscribe(SingleSource<T> source, Consumer<? super Disposable> onSubscribe) {
        this.source = source;
        this.onSubscribe = onSubscribe;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> s) {
        this.source.subscribe(new DoOnSubscribeSingleObserver<T>(s, this.onSubscribe));
    }

    static final class DoOnSubscribeSingleObserver<T>
    implements SingleObserver<T> {
        final SingleObserver<? super T> actual;
        final Consumer<? super Disposable> onSubscribe;
        boolean done;

        DoOnSubscribeSingleObserver(SingleObserver<? super T> actual2, Consumer<? super Disposable> onSubscribe) {
            this.actual = actual2;
            this.onSubscribe = onSubscribe;
        }

        @Override
        public void onSubscribe(Disposable d) {
            try {
                this.onSubscribe.accept(d);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.done = true;
                d.dispose();
                EmptyDisposable.error(ex, this.actual);
                return;
            }
            this.actual.onSubscribe(d);
        }

        @Override
        public void onSuccess(T value) {
            if (this.done) {
                return;
            }
            this.actual.onSuccess(value);
        }

        @Override
        public void onError(Throwable e) {
            if (this.done) {
                RxJavaPlugins.onError(e);
                return;
            }
            this.actual.onError(e);
        }
    }
}

