/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;

public final class SingleEquals<T>
extends Single<Boolean> {
    final SingleSource<? extends T> first;
    final SingleSource<? extends T> second;

    public SingleEquals(SingleSource<? extends T> first2, SingleSource<? extends T> second2) {
        this.first = first2;
        this.second = second2;
    }

    @Override
    protected void subscribeActual(final SingleObserver<? super Boolean> s) {
        final AtomicInteger count2 = new AtomicInteger();
        final Object[] values2 = new Object[]{null, null};
        final CompositeDisposable set = new CompositeDisposable();
        s.onSubscribe(set);
        class InnerObserver
        implements SingleObserver<T> {
            final int index;

            InnerObserver(int index) {
                this.index = index;
            }

            @Override
            public void onSubscribe(Disposable d) {
                set.add(d);
            }

            @Override
            public void onSuccess(T value) {
                values2[this.index] = value;
                if (count2.incrementAndGet() == 2) {
                    s.onSuccess(ObjectHelper.equals(values2[0], values2[1]));
                }
            }

            @Override
            public void onError(Throwable e) {
                int state;
                do {
                    if ((state = count2.get()) < 2) continue;
                    RxJavaPlugins.onError(e);
                    return;
                } while (!count2.compareAndSet(state, 2));
                set.dispose();
                s.onError(e);
            }
        }
        this.first.subscribe(new InnerObserver(0));
        this.second.subscribe(new InnerObserver(1));
    }
}

