/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;

public final class SingleHide<T>
extends Single<T> {
    final SingleSource<? extends T> source;

    public SingleHide(SingleSource<? extends T> source) {
        this.source = source;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> subscriber) {
        this.source.subscribe(new HideSingleObserver<T>(subscriber));
    }

    static final class HideSingleObserver<T>
    implements SingleObserver<T>,
    Disposable {
        final SingleObserver<? super T> actual;
        Disposable d;

        HideSingleObserver(SingleObserver<? super T> actual2) {
            this.actual = actual2;
        }

        @Override
        public void dispose() {
            this.d.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.actual.onSuccess(value);
        }

        @Override
        public void onError(Throwable e) {
            this.actual.onError(e);
        }
    }
}

