/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SingleTimeout<T>
extends Single<T> {
    final SingleSource<T> source;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final SingleSource<? extends T> other;

    public SingleTimeout(SingleSource<T> source, long timeout, TimeUnit unit, Scheduler scheduler, SingleSource<? extends T> other) {
        this.source = source;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.other = other;
    }

    @Override
    protected void subscribeActual(final SingleObserver<? super T> s) {
        final CompositeDisposable set = new CompositeDisposable();
        s.onSubscribe(set);
        final AtomicBoolean once = new AtomicBoolean();
        Disposable timer2 = this.scheduler.scheduleDirect(new Runnable(){

            @Override
            public void run() {
                if (once.compareAndSet(false, true)) {
                    if (SingleTimeout.this.other != null) {
                        set.clear();
                        SingleTimeout.this.other.subscribe(new SingleObserver<T>(){

                            @Override
                            public void onError(Throwable e) {
                                set.dispose();
                                s.onError(e);
                            }

                            @Override
                            public void onSubscribe(Disposable d) {
                                set.add(d);
                            }

                            @Override
                            public void onSuccess(T value) {
                                set.dispose();
                                s.onSuccess(value);
                            }
                        });
                    } else {
                        set.dispose();
                        s.onError(new TimeoutException());
                    }
                }
            }
        }, this.timeout, this.unit);
        set.add(timer2);
        this.source.subscribe(new SingleObserver<T>(){

            @Override
            public void onError(Throwable e) {
                if (once.compareAndSet(false, true)) {
                    set.dispose();
                    s.onError(e);
                }
            }

            @Override
            public void onSubscribe(Disposable d) {
                set.add(d);
            }

            @Override
            public void onSuccess(T value) {
                if (once.compareAndSet(false, true)) {
                    set.dispose();
                    s.onSuccess(value);
                }
            }
        });
    }
}

