/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleUsing<T, U>
extends Single<T> {
    final Callable<U> resourceSupplier;
    final Function<? super U, ? extends SingleSource<? extends T>> singleFunction;
    final Consumer<? super U> disposer;
    final boolean eager;

    public SingleUsing(Callable<U> resourceSupplier, Function<? super U, ? extends SingleSource<? extends T>> singleFunction, Consumer<? super U> disposer, boolean eager) {
        this.resourceSupplier = resourceSupplier;
        this.singleFunction = singleFunction;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> s) {
        SingleSource<T> source;
        U resource;
        try {
            resource = this.resourceSupplier.call();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptyDisposable.error(ex, s);
            return;
        }
        try {
            source = ObjectHelper.requireNonNull(this.singleFunction.apply(resource), "The singleFunction returned a null SingleSource");
        }
        catch (Throwable ex2) {
            CompositeException ex2;
            Exceptions.throwIfFatal(ex2);
            if (this.eager) {
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal(exc);
                    ex2 = new CompositeException(ex2, exc);
                }
            }
            EmptyDisposable.error((Throwable)ex2, s);
            if (!this.eager) {
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal(exc);
                    RxJavaPlugins.onError(exc);
                }
            }
            return;
        }
        source.subscribe(new UsingSingleObserver<T, U>(s, resource, this.eager, this.disposer));
    }

    static final class UsingSingleObserver<T, U>
    extends AtomicReference<Object>
    implements SingleObserver<T>,
    Disposable {
        private static final long serialVersionUID = -5331524057054083935L;
        final SingleObserver<? super T> actual;
        final Consumer<? super U> disposer;
        final boolean eager;
        Disposable d;

        UsingSingleObserver(SingleObserver<? super T> actual2, U resource, boolean eager, Consumer<? super U> disposer) {
            super(resource);
            this.actual = actual2;
            this.eager = eager;
            this.disposer = disposer;
        }

        @Override
        public void dispose() {
            this.d.dispose();
            this.d = DisposableHelper.DISPOSED;
            this.disposeAfter();
        }

        @Override
        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.d = DisposableHelper.DISPOSED;
            if (this.eager) {
                UsingSingleObserver u = this.getAndSet(this);
                if (u != this) {
                    try {
                        this.disposer.accept(u);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.actual.onError(ex);
                        return;
                    }
                } else {
                    return;
                }
            }
            this.actual.onSuccess(value);
            if (!this.eager) {
                this.disposeAfter();
            }
        }

        @Override
        public void onError(Throwable e) {
            this.d = DisposableHelper.DISPOSED;
            if (this.eager) {
                UsingSingleObserver u = this.getAndSet(this);
                if (u != this) {
                    try {
                        this.disposer.accept(u);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        e = new CompositeException(e, ex);
                    }
                } else {
                    return;
                }
            }
            this.actual.onError(e);
            if (!this.eager) {
                this.disposeAfter();
            }
        }

        void disposeAfter() {
            UsingSingleObserver u = this.getAndSet(this);
            if (u != this) {
                try {
                    this.disposer.accept(u);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaPlugins.onError(ex);
                }
            }
        }
    }
}

