/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.Scheduler;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.schedulers.DisposeOnCancel;
import io.reactivex.internal.schedulers.ScheduledRunnable;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class ExecutorScheduler
extends Scheduler {
    final Executor executor;
    static final Scheduler HELPER = Schedulers.single();

    public ExecutorScheduler(Executor executor) {
        this.executor = executor;
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new ExecutorWorker(this.executor);
    }

    @Override
    public Disposable scheduleDirect(Runnable run) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        try {
            if (this.executor instanceof ExecutorService) {
                Future<?> f = ((ExecutorService)this.executor).submit(decoratedRun);
                return Disposables.fromFuture(f);
            }
            ExecutorWorker.BooleanRunnable br = new ExecutorWorker.BooleanRunnable(decoratedRun);
            this.executor.execute(br);
            return br;
        }
        catch (RejectedExecutionException ex) {
            RxJavaPlugins.onError(ex);
            return EmptyDisposable.INSTANCE;
        }
    }

    @Override
    public Disposable scheduleDirect(Runnable run, long delay, TimeUnit unit) {
        final Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        if (this.executor instanceof ScheduledExecutorService) {
            try {
                ScheduledFuture<?> f = ((ScheduledExecutorService)this.executor).schedule(decoratedRun, delay, unit);
                return Disposables.fromFuture(f);
            }
            catch (RejectedExecutionException ex) {
                RxJavaPlugins.onError(ex);
                return EmptyDisposable.INSTANCE;
            }
        }
        SequentialDisposable first2 = new SequentialDisposable();
        final SequentialDisposable mar = new SequentialDisposable(first2);
        Disposable delayed = HELPER.scheduleDirect(new Runnable(){

            @Override
            public void run() {
                mar.replace(ExecutorScheduler.this.scheduleDirect(decoratedRun));
            }
        }, delay, unit);
        first2.replace(delayed);
        return mar;
    }

    @Override
    public Disposable schedulePeriodicallyDirect(Runnable run, long initialDelay, long period, TimeUnit unit) {
        if (this.executor instanceof ScheduledExecutorService) {
            Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
            try {
                ScheduledFuture<?> f = ((ScheduledExecutorService)this.executor).scheduleAtFixedRate(decoratedRun, initialDelay, period, unit);
                return Disposables.fromFuture(f);
            }
            catch (RejectedExecutionException ex) {
                RxJavaPlugins.onError(ex);
                return EmptyDisposable.INSTANCE;
            }
        }
        return super.schedulePeriodicallyDirect(run, initialDelay, period, unit);
    }

    public static final class ExecutorWorker
    extends Scheduler.Worker
    implements Runnable {
        final Executor executor;
        final MpscLinkedQueue<Runnable> queue;
        volatile boolean disposed;
        final AtomicInteger wip = new AtomicInteger();
        final CompositeDisposable tasks = new CompositeDisposable();

        public ExecutorWorker(Executor executor) {
            this.executor = executor;
            this.queue = new MpscLinkedQueue();
        }

        @Override
        public Disposable schedule(Runnable run) {
            if (this.disposed) {
                return EmptyDisposable.INSTANCE;
            }
            Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
            BooleanRunnable br = new BooleanRunnable(decoratedRun);
            this.queue.offer(br);
            if (this.wip.getAndIncrement() == 0) {
                try {
                    this.executor.execute(this);
                }
                catch (RejectedExecutionException ex) {
                    this.disposed = true;
                    this.queue.clear();
                    RxJavaPlugins.onError(ex);
                    return EmptyDisposable.INSTANCE;
                }
            }
            return br;
        }

        @Override
        public Disposable schedule(Runnable run, long delay, TimeUnit unit) {
            if (delay <= 0L) {
                return this.schedule(run);
            }
            if (this.disposed) {
                return EmptyDisposable.INSTANCE;
            }
            SequentialDisposable first2 = new SequentialDisposable();
            final SequentialDisposable mar = new SequentialDisposable(first2);
            final Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
            ScheduledRunnable sr = new ScheduledRunnable(new Runnable(){

                @Override
                public void run() {
                    mar.replace(ExecutorWorker.this.schedule(decoratedRun));
                }
            }, this.tasks);
            this.tasks.add(sr);
            if (this.executor instanceof ScheduledExecutorService) {
                try {
                    ScheduledFuture<Object> f = ((ScheduledExecutorService)this.executor).schedule(sr, delay, unit);
                    sr.setFuture(f);
                }
                catch (RejectedExecutionException ex) {
                    this.disposed = true;
                    RxJavaPlugins.onError(ex);
                    return EmptyDisposable.INSTANCE;
                }
            } else {
                Disposable d = HELPER.scheduleDirect(sr, delay, unit);
                sr.setFuture(new DisposeOnCancel(d));
            }
            first2.replace(sr);
            return mar;
        }

        @Override
        public void dispose() {
            if (!this.disposed) {
                this.disposed = true;
                this.tasks.dispose();
                if (this.wip.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        public void run() {
            int missed = 1;
            MpscLinkedQueue<Runnable> q = this.queue;
            do {
                Runnable run;
                if (this.disposed) {
                    q.clear();
                    return;
                }
                while ((run = q.poll()) != null) {
                    run.run();
                    if (!this.disposed) continue;
                    q.clear();
                    return;
                }
                if (!this.disposed) continue;
                q.clear();
                return;
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        static final class BooleanRunnable
        extends AtomicBoolean
        implements Runnable,
        Disposable {
            private static final long serialVersionUID = -2421395018820541164L;
            final Runnable actual;

            BooleanRunnable(Runnable actual2) {
                this.actual = actual2;
            }

            @Override
            public void run() {
                if (this.get()) {
                    return;
                }
                this.actual.run();
            }

            @Override
            public void dispose() {
                this.lazySet(true);
            }

            @Override
            public boolean isDisposed() {
                return this.get();
            }
        }
    }
}

