/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.core;

import io.reactivex.rxjava3.annotations.BackpressureKind;
import io.reactivex.rxjava3.annotations.BackpressureSupport;
import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.Experimental;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.annotations.SchedulerSupport;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Emitter;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Notification;
import io.reactivex.rxjava3.core.ObservableConverter;
import io.reactivex.rxjava3.core.ObservableOnSubscribe;
import io.reactivex.rxjava3.core.ObservableOperator;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.disposables.DisposableContainer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.BiConsumer;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.BiPredicate;
import io.reactivex.rxjava3.functions.BooleanSupplier;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Function3;
import io.reactivex.rxjava3.functions.Function4;
import io.reactivex.rxjava3.functions.Function5;
import io.reactivex.rxjava3.functions.Function6;
import io.reactivex.rxjava3.functions.Function7;
import io.reactivex.rxjava3.functions.Function8;
import io.reactivex.rxjava3.functions.Function9;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.jdk8.ObservableCollectWithCollectorSingle;
import io.reactivex.rxjava3.internal.jdk8.ObservableFirstStageObserver;
import io.reactivex.rxjava3.internal.jdk8.ObservableFlatMapStream;
import io.reactivex.rxjava3.internal.jdk8.ObservableFromCompletionStage;
import io.reactivex.rxjava3.internal.jdk8.ObservableFromStream;
import io.reactivex.rxjava3.internal.jdk8.ObservableLastStageObserver;
import io.reactivex.rxjava3.internal.jdk8.ObservableMapOptional;
import io.reactivex.rxjava3.internal.jdk8.ObservableSingleStageObserver;
import io.reactivex.rxjava3.internal.observers.BlockingFirstObserver;
import io.reactivex.rxjava3.internal.observers.BlockingLastObserver;
import io.reactivex.rxjava3.internal.observers.DisposableAutoReleaseObserver;
import io.reactivex.rxjava3.internal.observers.ForEachWhileObserver;
import io.reactivex.rxjava3.internal.observers.FutureObserver;
import io.reactivex.rxjava3.internal.observers.LambdaObserver;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableFromObservable;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableOnBackpressureError;
import io.reactivex.rxjava3.internal.operators.maybe.MaybeToObservable;
import io.reactivex.rxjava3.internal.operators.mixed.ObservableConcatMapCompletable;
import io.reactivex.rxjava3.internal.operators.mixed.ObservableConcatMapMaybe;
import io.reactivex.rxjava3.internal.operators.mixed.ObservableConcatMapSingle;
import io.reactivex.rxjava3.internal.operators.mixed.ObservableSwitchMapCompletable;
import io.reactivex.rxjava3.internal.operators.mixed.ObservableSwitchMapMaybe;
import io.reactivex.rxjava3.internal.operators.mixed.ObservableSwitchMapSingle;
import io.reactivex.rxjava3.internal.operators.observable.BlockingObservableIterable;
import io.reactivex.rxjava3.internal.operators.observable.BlockingObservableLatest;
import io.reactivex.rxjava3.internal.operators.observable.BlockingObservableMostRecent;
import io.reactivex.rxjava3.internal.operators.observable.BlockingObservableNext;
import io.reactivex.rxjava3.internal.operators.observable.ObservableAllSingle;
import io.reactivex.rxjava3.internal.operators.observable.ObservableAmb;
import io.reactivex.rxjava3.internal.operators.observable.ObservableAnySingle;
import io.reactivex.rxjava3.internal.operators.observable.ObservableBlockingSubscribe;
import io.reactivex.rxjava3.internal.operators.observable.ObservableBuffer;
import io.reactivex.rxjava3.internal.operators.observable.ObservableBufferBoundary;
import io.reactivex.rxjava3.internal.operators.observable.ObservableBufferExactBoundary;
import io.reactivex.rxjava3.internal.operators.observable.ObservableBufferTimed;
import io.reactivex.rxjava3.internal.operators.observable.ObservableCache;
import io.reactivex.rxjava3.internal.operators.observable.ObservableCollectSingle;
import io.reactivex.rxjava3.internal.operators.observable.ObservableCombineLatest;
import io.reactivex.rxjava3.internal.operators.observable.ObservableConcatMap;
import io.reactivex.rxjava3.internal.operators.observable.ObservableConcatMapEager;
import io.reactivex.rxjava3.internal.operators.observable.ObservableConcatMapScheduler;
import io.reactivex.rxjava3.internal.operators.observable.ObservableConcatWithCompletable;
import io.reactivex.rxjava3.internal.operators.observable.ObservableConcatWithMaybe;
import io.reactivex.rxjava3.internal.operators.observable.ObservableConcatWithSingle;
import io.reactivex.rxjava3.internal.operators.observable.ObservableCountSingle;
import io.reactivex.rxjava3.internal.operators.observable.ObservableCreate;
import io.reactivex.rxjava3.internal.operators.observable.ObservableDebounce;
import io.reactivex.rxjava3.internal.operators.observable.ObservableDebounceTimed;
import io.reactivex.rxjava3.internal.operators.observable.ObservableDefer;
import io.reactivex.rxjava3.internal.operators.observable.ObservableDelay;
import io.reactivex.rxjava3.internal.operators.observable.ObservableDelaySubscriptionOther;
import io.reactivex.rxjava3.internal.operators.observable.ObservableDematerialize;
import io.reactivex.rxjava3.internal.operators.observable.ObservableDetach;
import io.reactivex.rxjava3.internal.operators.observable.ObservableDistinct;
import io.reactivex.rxjava3.internal.operators.observable.ObservableDistinctUntilChanged;
import io.reactivex.rxjava3.internal.operators.observable.ObservableDoAfterNext;
import io.reactivex.rxjava3.internal.operators.observable.ObservableDoFinally;
import io.reactivex.rxjava3.internal.operators.observable.ObservableDoOnEach;
import io.reactivex.rxjava3.internal.operators.observable.ObservableDoOnLifecycle;
import io.reactivex.rxjava3.internal.operators.observable.ObservableElementAtMaybe;
import io.reactivex.rxjava3.internal.operators.observable.ObservableElementAtSingle;
import io.reactivex.rxjava3.internal.operators.observable.ObservableEmpty;
import io.reactivex.rxjava3.internal.operators.observable.ObservableError;
import io.reactivex.rxjava3.internal.operators.observable.ObservableFilter;
import io.reactivex.rxjava3.internal.operators.observable.ObservableFlatMap;
import io.reactivex.rxjava3.internal.operators.observable.ObservableFlatMapCompletableCompletable;
import io.reactivex.rxjava3.internal.operators.observable.ObservableFlatMapMaybe;
import io.reactivex.rxjava3.internal.operators.observable.ObservableFlatMapSingle;
import io.reactivex.rxjava3.internal.operators.observable.ObservableFlattenIterable;
import io.reactivex.rxjava3.internal.operators.observable.ObservableFromAction;
import io.reactivex.rxjava3.internal.operators.observable.ObservableFromArray;
import io.reactivex.rxjava3.internal.operators.observable.ObservableFromCallable;
import io.reactivex.rxjava3.internal.operators.observable.ObservableFromCompletable;
import io.reactivex.rxjava3.internal.operators.observable.ObservableFromFuture;
import io.reactivex.rxjava3.internal.operators.observable.ObservableFromIterable;
import io.reactivex.rxjava3.internal.operators.observable.ObservableFromPublisher;
import io.reactivex.rxjava3.internal.operators.observable.ObservableFromRunnable;
import io.reactivex.rxjava3.internal.operators.observable.ObservableFromSupplier;
import io.reactivex.rxjava3.internal.operators.observable.ObservableFromUnsafeSource;
import io.reactivex.rxjava3.internal.operators.observable.ObservableGenerate;
import io.reactivex.rxjava3.internal.operators.observable.ObservableGroupBy;
import io.reactivex.rxjava3.internal.operators.observable.ObservableGroupJoin;
import io.reactivex.rxjava3.internal.operators.observable.ObservableHide;
import io.reactivex.rxjava3.internal.operators.observable.ObservableIgnoreElements;
import io.reactivex.rxjava3.internal.operators.observable.ObservableIgnoreElementsCompletable;
import io.reactivex.rxjava3.internal.operators.observable.ObservableInternalHelper;
import io.reactivex.rxjava3.internal.operators.observable.ObservableInterval;
import io.reactivex.rxjava3.internal.operators.observable.ObservableIntervalRange;
import io.reactivex.rxjava3.internal.operators.observable.ObservableJoin;
import io.reactivex.rxjava3.internal.operators.observable.ObservableJust;
import io.reactivex.rxjava3.internal.operators.observable.ObservableLastMaybe;
import io.reactivex.rxjava3.internal.operators.observable.ObservableLastSingle;
import io.reactivex.rxjava3.internal.operators.observable.ObservableLift;
import io.reactivex.rxjava3.internal.operators.observable.ObservableMap;
import io.reactivex.rxjava3.internal.operators.observable.ObservableMapNotification;
import io.reactivex.rxjava3.internal.operators.observable.ObservableMaterialize;
import io.reactivex.rxjava3.internal.operators.observable.ObservableMergeWithCompletable;
import io.reactivex.rxjava3.internal.operators.observable.ObservableMergeWithMaybe;
import io.reactivex.rxjava3.internal.operators.observable.ObservableMergeWithSingle;
import io.reactivex.rxjava3.internal.operators.observable.ObservableNever;
import io.reactivex.rxjava3.internal.operators.observable.ObservableObserveOn;
import io.reactivex.rxjava3.internal.operators.observable.ObservableOnErrorComplete;
import io.reactivex.rxjava3.internal.operators.observable.ObservableOnErrorNext;
import io.reactivex.rxjava3.internal.operators.observable.ObservableOnErrorReturn;
import io.reactivex.rxjava3.internal.operators.observable.ObservablePublish;
import io.reactivex.rxjava3.internal.operators.observable.ObservablePublishSelector;
import io.reactivex.rxjava3.internal.operators.observable.ObservableRange;
import io.reactivex.rxjava3.internal.operators.observable.ObservableRangeLong;
import io.reactivex.rxjava3.internal.operators.observable.ObservableReduceMaybe;
import io.reactivex.rxjava3.internal.operators.observable.ObservableReduceSeedSingle;
import io.reactivex.rxjava3.internal.operators.observable.ObservableReduceWithSingle;
import io.reactivex.rxjava3.internal.operators.observable.ObservableRepeat;
import io.reactivex.rxjava3.internal.operators.observable.ObservableRepeatUntil;
import io.reactivex.rxjava3.internal.operators.observable.ObservableRepeatWhen;
import io.reactivex.rxjava3.internal.operators.observable.ObservableReplay;
import io.reactivex.rxjava3.internal.operators.observable.ObservableRetryBiPredicate;
import io.reactivex.rxjava3.internal.operators.observable.ObservableRetryPredicate;
import io.reactivex.rxjava3.internal.operators.observable.ObservableRetryWhen;
import io.reactivex.rxjava3.internal.operators.observable.ObservableSampleTimed;
import io.reactivex.rxjava3.internal.operators.observable.ObservableSampleWithObservable;
import io.reactivex.rxjava3.internal.operators.observable.ObservableScalarXMap;
import io.reactivex.rxjava3.internal.operators.observable.ObservableScan;
import io.reactivex.rxjava3.internal.operators.observable.ObservableScanSeed;
import io.reactivex.rxjava3.internal.operators.observable.ObservableSequenceEqualSingle;
import io.reactivex.rxjava3.internal.operators.observable.ObservableSerialized;
import io.reactivex.rxjava3.internal.operators.observable.ObservableSingleMaybe;
import io.reactivex.rxjava3.internal.operators.observable.ObservableSingleSingle;
import io.reactivex.rxjava3.internal.operators.observable.ObservableSkip;
import io.reactivex.rxjava3.internal.operators.observable.ObservableSkipLast;
import io.reactivex.rxjava3.internal.operators.observable.ObservableSkipLastTimed;
import io.reactivex.rxjava3.internal.operators.observable.ObservableSkipUntil;
import io.reactivex.rxjava3.internal.operators.observable.ObservableSkipWhile;
import io.reactivex.rxjava3.internal.operators.observable.ObservableSubscribeOn;
import io.reactivex.rxjava3.internal.operators.observable.ObservableSwitchIfEmpty;
import io.reactivex.rxjava3.internal.operators.observable.ObservableSwitchMap;
import io.reactivex.rxjava3.internal.operators.observable.ObservableTake;
import io.reactivex.rxjava3.internal.operators.observable.ObservableTakeLast;
import io.reactivex.rxjava3.internal.operators.observable.ObservableTakeLastOne;
import io.reactivex.rxjava3.internal.operators.observable.ObservableTakeLastTimed;
import io.reactivex.rxjava3.internal.operators.observable.ObservableTakeUntil;
import io.reactivex.rxjava3.internal.operators.observable.ObservableTakeUntilPredicate;
import io.reactivex.rxjava3.internal.operators.observable.ObservableTakeWhile;
import io.reactivex.rxjava3.internal.operators.observable.ObservableThrottleFirstTimed;
import io.reactivex.rxjava3.internal.operators.observable.ObservableThrottleLatest;
import io.reactivex.rxjava3.internal.operators.observable.ObservableTimeInterval;
import io.reactivex.rxjava3.internal.operators.observable.ObservableTimeout;
import io.reactivex.rxjava3.internal.operators.observable.ObservableTimeoutTimed;
import io.reactivex.rxjava3.internal.operators.observable.ObservableTimer;
import io.reactivex.rxjava3.internal.operators.observable.ObservableToListSingle;
import io.reactivex.rxjava3.internal.operators.observable.ObservableUnsubscribeOn;
import io.reactivex.rxjava3.internal.operators.observable.ObservableUsing;
import io.reactivex.rxjava3.internal.operators.observable.ObservableWindow;
import io.reactivex.rxjava3.internal.operators.observable.ObservableWindowBoundary;
import io.reactivex.rxjava3.internal.operators.observable.ObservableWindowBoundarySelector;
import io.reactivex.rxjava3.internal.operators.observable.ObservableWindowTimed;
import io.reactivex.rxjava3.internal.operators.observable.ObservableWithLatestFrom;
import io.reactivex.rxjava3.internal.operators.observable.ObservableWithLatestFromMany;
import io.reactivex.rxjava3.internal.operators.observable.ObservableZip;
import io.reactivex.rxjava3.internal.operators.observable.ObservableZipIterable;
import io.reactivex.rxjava3.internal.operators.single.SingleToObservable;
import io.reactivex.rxjava3.internal.util.ArrayListSupplier;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.HashMapSupplier;
import io.reactivex.rxjava3.observables.ConnectableObservable;
import io.reactivex.rxjava3.observables.GroupedObservable;
import io.reactivex.rxjava3.observers.SafeObserver;
import io.reactivex.rxjava3.observers.TestObserver;
import io.reactivex.rxjava3.operators.ScalarSupplier;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.schedulers.Timed;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.reactivestreams.Publisher;

public abstract class Observable<@NonNull T>
implements ObservableSource<T> {
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> amb(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<? extends T>> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new ObservableAmb(null, sources));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Observable<T> ambArray(ObservableSource<? extends T> ... sources) {
        Objects.requireNonNull(sources, "sources is null");
        int len = sources.length;
        if (len == 0) {
            return Observable.empty();
        }
        if (len == 1) {
            return Observable.wrap(sources[0]);
        }
        return RxJavaPlugins.onAssembly(new ObservableAmb<T>(sources, null));
    }

    @CheckReturnValue
    public static int bufferSize() {
        return Flowable.bufferSize();
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, R> Observable<R> combineLatest(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<? extends T>> sources, @NonNull Function<? super Object[], ? extends R> combiner) {
        return Observable.combineLatest(sources, combiner, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, R> Observable<R> combineLatest(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<? extends T>> sources, @NonNull Function<? super Object[], ? extends R> combiner, int bufferSize) {
        Objects.requireNonNull(sources, "sources is null");
        Objects.requireNonNull(combiner, "combiner is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        int s = bufferSize << 1;
        return RxJavaPlugins.onAssembly(new ObservableCombineLatest(null, sources, combiner, s, false));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, R> Observable<R> combineLatestArray(@NonNull ObservableSource<? extends T>[] sources, @NonNull Function<? super Object[], ? extends R> combiner) {
        return Observable.combineLatestArray(sources, combiner, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, R> Observable<R> combineLatestArray(@NonNull ObservableSource<? extends T>[] sources, @NonNull Function<? super Object[], ? extends R> combiner, int bufferSize) {
        Objects.requireNonNull(sources, "sources is null");
        if (sources.length == 0) {
            return Observable.empty();
        }
        Objects.requireNonNull(combiner, "combiner is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        int s = bufferSize << 1;
        return RxJavaPlugins.onAssembly(new ObservableCombineLatest<T, R>(sources, null, combiner, s, false));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, R> Observable<R> combineLatest(@NonNull ObservableSource<? extends T1> source1, @NonNull ObservableSource<? extends T2> source2, @NonNull BiFunction<? super T1, ? super T2, ? extends R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return Observable.combineLatestArray(new ObservableSource[]{source1, source2}, Functions.toFunction(combiner), Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, R> Observable<R> combineLatest(@NonNull ObservableSource<? extends T1> source1, @NonNull ObservableSource<? extends T2> source2, @NonNull ObservableSource<? extends T3> source3, @NonNull Function3<? super T1, ? super T2, ? super T3, ? extends R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return Observable.combineLatestArray(new ObservableSource[]{source1, source2, source3}, Functions.toFunction(combiner), Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, R> Observable<R> combineLatest(@NonNull ObservableSource<? extends T1> source1, @NonNull ObservableSource<? extends T2> source2, @NonNull ObservableSource<? extends T3> source3, @NonNull ObservableSource<? extends T4> source4, @NonNull Function4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return Observable.combineLatestArray(new ObservableSource[]{source1, source2, source3, source4}, Functions.toFunction(combiner), Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, R> Observable<R> combineLatest(@NonNull ObservableSource<? extends T1> source1, @NonNull ObservableSource<? extends T2> source2, @NonNull ObservableSource<? extends T3> source3, @NonNull ObservableSource<? extends T4> source4, @NonNull ObservableSource<? extends T5> source5, @NonNull Function5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return Observable.combineLatestArray(new ObservableSource[]{source1, source2, source3, source4, source5}, Functions.toFunction(combiner), Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, R> Observable<R> combineLatest(@NonNull ObservableSource<? extends T1> source1, @NonNull ObservableSource<? extends T2> source2, @NonNull ObservableSource<? extends T3> source3, @NonNull ObservableSource<? extends T4> source4, @NonNull ObservableSource<? extends T5> source5, @NonNull ObservableSource<? extends T6> source6, @NonNull Function6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return Observable.combineLatestArray(new ObservableSource[]{source1, source2, source3, source4, source5, source6}, Functions.toFunction(combiner), Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, T7, R> Observable<R> combineLatest(@NonNull ObservableSource<? extends T1> source1, @NonNull ObservableSource<? extends T2> source2, @NonNull ObservableSource<? extends T3> source3, @NonNull ObservableSource<? extends T4> source4, @NonNull ObservableSource<? extends T5> source5, @NonNull ObservableSource<? extends T6> source6, @NonNull ObservableSource<? extends T7> source7, @NonNull Function7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(source7, "source7 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return Observable.combineLatestArray(new ObservableSource[]{source1, source2, source3, source4, source5, source6, source7}, Functions.toFunction(combiner), Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Observable<R> combineLatest(@NonNull ObservableSource<? extends T1> source1, @NonNull ObservableSource<? extends T2> source2, @NonNull ObservableSource<? extends T3> source3, @NonNull ObservableSource<? extends T4> source4, @NonNull ObservableSource<? extends T5> source5, @NonNull ObservableSource<? extends T6> source6, @NonNull ObservableSource<? extends T7> source7, @NonNull ObservableSource<? extends T8> source8, @NonNull Function8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(source7, "source7 is null");
        Objects.requireNonNull(source8, "source8 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return Observable.combineLatestArray(new ObservableSource[]{source1, source2, source3, source4, source5, source6, source7, source8}, Functions.toFunction(combiner), Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Observable<R> combineLatest(@NonNull ObservableSource<? extends T1> source1, @NonNull ObservableSource<? extends T2> source2, @NonNull ObservableSource<? extends T3> source3, @NonNull ObservableSource<? extends T4> source4, @NonNull ObservableSource<? extends T5> source5, @NonNull ObservableSource<? extends T6> source6, @NonNull ObservableSource<? extends T7> source7, @NonNull ObservableSource<? extends T8> source8, @NonNull ObservableSource<? extends T9> source9, @NonNull Function9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(source7, "source7 is null");
        Objects.requireNonNull(source8, "source8 is null");
        Objects.requireNonNull(source9, "source9 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return Observable.combineLatestArray(new ObservableSource[]{source1, source2, source3, source4, source5, source6, source7, source8, source9}, Functions.toFunction(combiner), Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, R> Observable<R> combineLatestArrayDelayError(@NonNull ObservableSource<? extends T>[] sources, @NonNull Function<? super Object[], ? extends R> combiner) {
        return Observable.combineLatestArrayDelayError(sources, combiner, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, R> Observable<R> combineLatestArrayDelayError(@NonNull ObservableSource<? extends T>[] sources, @NonNull Function<? super Object[], ? extends R> combiner, int bufferSize) {
        Objects.requireNonNull(sources, "sources is null");
        Objects.requireNonNull(combiner, "combiner is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        if (sources.length == 0) {
            return Observable.empty();
        }
        int s = bufferSize << 1;
        return RxJavaPlugins.onAssembly(new ObservableCombineLatest<T, R>(sources, null, combiner, s, true));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, R> Observable<R> combineLatestDelayError(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<? extends T>> sources, @NonNull Function<? super Object[], ? extends R> combiner) {
        return Observable.combineLatestDelayError(sources, combiner, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, R> Observable<R> combineLatestDelayError(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<? extends T>> sources, @NonNull Function<? super Object[], ? extends R> combiner, int bufferSize) {
        Objects.requireNonNull(sources, "sources is null");
        Objects.requireNonNull(combiner, "combiner is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        int s = bufferSize << 1;
        return RxJavaPlugins.onAssembly(new ObservableCombineLatest(null, sources, combiner, s, true));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> concat(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<? extends T>> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return Observable.fromIterable(sources).concatMapDelayError(Functions.identity(), false, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> concat(@NonNull ObservableSource<? extends ObservableSource<? extends T>> sources) {
        return Observable.concat(sources, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> concat(@NonNull ObservableSource<? extends ObservableSource<? extends T>> sources, int bufferSize) {
        Objects.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableConcatMap(sources, Functions.identity(), bufferSize, ErrorMode.IMMEDIATE));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> concat(@NonNull ObservableSource<? extends T> source1, ObservableSource<? extends T> source2) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        return Observable.concatArray(source1, source2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> concat(@NonNull ObservableSource<? extends T> source1, @NonNull ObservableSource<? extends T> source2, @NonNull ObservableSource<? extends T> source3) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        return Observable.concatArray(source1, source2, source3);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> concat(@NonNull ObservableSource<? extends T> source1, @NonNull ObservableSource<? extends T> source2, @NonNull ObservableSource<? extends T> source3, @NonNull ObservableSource<? extends T> source4) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        return Observable.concatArray(source1, source2, source3, source4);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Observable<T> concatArray(ObservableSource<? extends T> ... sources) {
        Objects.requireNonNull(sources, "sources is null");
        if (sources.length == 0) {
            return Observable.empty();
        }
        if (sources.length == 1) {
            return Observable.wrap(sources[0]);
        }
        return RxJavaPlugins.onAssembly(new ObservableConcatMap(Observable.fromArray(sources), Functions.identity(), Observable.bufferSize(), ErrorMode.BOUNDARY));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Observable<T> concatArrayDelayError(ObservableSource<? extends T> ... sources) {
        Objects.requireNonNull(sources, "sources is null");
        if (sources.length == 0) {
            return Observable.empty();
        }
        if (sources.length == 1) {
            Observable<? extends T> source = Observable.wrap(sources[0]);
            return source;
        }
        return Observable.concatDelayError(Observable.fromArray(sources));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Observable<T> concatArrayEager(ObservableSource<? extends T> ... sources) {
        return Observable.concatArrayEager(Observable.bufferSize(), Observable.bufferSize(), sources);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Observable<T> concatArrayEager(int maxConcurrency, int bufferSize, ObservableSource<? extends T> ... sources) {
        return Observable.fromArray(sources).concatMapEagerDelayError(Functions.identity(), false, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Observable<T> concatArrayEagerDelayError(ObservableSource<? extends T> ... sources) {
        return Observable.concatArrayEagerDelayError(Observable.bufferSize(), Observable.bufferSize(), sources);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Observable<T> concatArrayEagerDelayError(int maxConcurrency, int bufferSize, ObservableSource<? extends T> ... sources) {
        return Observable.fromArray(sources).concatMapEagerDelayError(Functions.identity(), true, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> concatDelayError(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<? extends T>> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return Observable.concatDelayError(Observable.fromIterable(sources));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> concatDelayError(@NonNull ObservableSource<? extends ObservableSource<? extends T>> sources) {
        return Observable.concatDelayError(sources, Observable.bufferSize(), true);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> concatDelayError(@NonNull ObservableSource<? extends ObservableSource<? extends T>> sources, int bufferSize, boolean tillTheEnd) {
        Objects.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize is null");
        return RxJavaPlugins.onAssembly(new ObservableConcatMap(sources, Functions.identity(), bufferSize, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> concatEager(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<? extends T>> sources) {
        return Observable.concatEager(sources, Observable.bufferSize(), Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> concatEager(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<? extends T>> sources, int maxConcurrency, int bufferSize) {
        return Observable.fromIterable(sources).concatMapEagerDelayError(Functions.identity(), false, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> concatEager(@NonNull ObservableSource<? extends ObservableSource<? extends T>> sources) {
        return Observable.concatEager(sources, Observable.bufferSize(), Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> concatEager(@NonNull ObservableSource<? extends ObservableSource<? extends T>> sources, int maxConcurrency, int bufferSize) {
        return Observable.wrap(sources).concatMapEager(Functions.identity(), maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> concatEagerDelayError(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<? extends T>> sources) {
        return Observable.concatEagerDelayError(sources, Observable.bufferSize(), Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> concatEagerDelayError(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<? extends T>> sources, int maxConcurrency, int bufferSize) {
        return Observable.fromIterable(sources).concatMapEagerDelayError(Functions.identity(), true, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> concatEagerDelayError(@NonNull ObservableSource<? extends ObservableSource<? extends T>> sources) {
        return Observable.concatEagerDelayError(sources, Observable.bufferSize(), Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> concatEagerDelayError(@NonNull ObservableSource<? extends ObservableSource<? extends T>> sources, int maxConcurrency, int bufferSize) {
        return Observable.wrap(sources).concatMapEagerDelayError(Functions.identity(), true, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> create(@NonNull ObservableOnSubscribe<T> source) {
        Objects.requireNonNull(source, "source is null");
        return RxJavaPlugins.onAssembly(new ObservableCreate<T>(source));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> defer(@NonNull @NonNull Supplier<? extends @NonNull ObservableSource<? extends T>> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return RxJavaPlugins.onAssembly(new ObservableDefer(supplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> empty() {
        return RxJavaPlugins.onAssembly(ObservableEmpty.INSTANCE);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> error(@NonNull @NonNull Supplier<? extends @NonNull Throwable> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return RxJavaPlugins.onAssembly(new ObservableError(supplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> error(@NonNull Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable is null");
        return Observable.error(Functions.justSupplier(throwable));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> fromAction(@NonNull Action action) {
        Objects.requireNonNull(action, "action is null");
        return RxJavaPlugins.onAssembly(new ObservableFromAction(action));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Observable<T> fromArray(T ... items) {
        Objects.requireNonNull(items, "items is null");
        if (items.length == 0) {
            return Observable.empty();
        }
        if (items.length == 1) {
            return Observable.just(items[0]);
        }
        return RxJavaPlugins.onAssembly(new ObservableFromArray<T>(items));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> fromCallable(@NonNull Callable<? extends T> callable) {
        Objects.requireNonNull(callable, "callable is null");
        return RxJavaPlugins.onAssembly(new ObservableFromCallable<T>(callable));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> fromCompletable(@NonNull CompletableSource completableSource) {
        Objects.requireNonNull(completableSource, "completableSource is null");
        return RxJavaPlugins.onAssembly(new ObservableFromCompletable(completableSource));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> fromFuture(@NonNull Future<? extends T> future) {
        Objects.requireNonNull(future, "future is null");
        return RxJavaPlugins.onAssembly(new ObservableFromFuture<T>(future, 0L, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> fromFuture(@NonNull Future<? extends T> future, long timeout, @NonNull TimeUnit unit) {
        Objects.requireNonNull(future, "future is null");
        Objects.requireNonNull(unit, "unit is null");
        return RxJavaPlugins.onAssembly(new ObservableFromFuture<T>(future, timeout, unit));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> fromIterable(@NonNull Iterable<? extends T> source) {
        Objects.requireNonNull(source, "source is null");
        return RxJavaPlugins.onAssembly(new ObservableFromIterable<T>(source));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> fromMaybe(@NonNull MaybeSource<T> maybe) {
        Objects.requireNonNull(maybe, "maybe is null");
        return RxJavaPlugins.onAssembly(new MaybeToObservable<T>(maybe));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> fromPublisher(@NonNull Publisher<? extends T> publisher) {
        Objects.requireNonNull(publisher, "publisher is null");
        return RxJavaPlugins.onAssembly(new ObservableFromPublisher<T>(publisher));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> fromRunnable(@NonNull Runnable run) {
        Objects.requireNonNull(run, "run is null");
        return RxJavaPlugins.onAssembly(new ObservableFromRunnable(run));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> fromSingle(@NonNull SingleSource<T> source) {
        Objects.requireNonNull(source, "source is null");
        return RxJavaPlugins.onAssembly(new SingleToObservable<T>(source));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> fromSupplier(@NonNull Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return RxJavaPlugins.onAssembly(new ObservableFromSupplier<T>(supplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> generate(@NonNull Consumer<Emitter<T>> generator) {
        Objects.requireNonNull(generator, "generator is null");
        return Observable.generate(Functions.nullSupplier(), ObservableInternalHelper.simpleGenerator(generator), Functions.emptyConsumer());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, S> Observable<T> generate(@NonNull Supplier<S> initialState, @NonNull BiConsumer<S, Emitter<T>> generator) {
        Objects.requireNonNull(generator, "generator is null");
        return Observable.generate(initialState, ObservableInternalHelper.simpleBiGenerator(generator), Functions.emptyConsumer());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, S> Observable<T> generate(@NonNull Supplier<S> initialState, @NonNull BiConsumer<S, Emitter<T>> generator, @NonNull Consumer<? super S> disposeState) {
        Objects.requireNonNull(generator, "generator is null");
        return Observable.generate(initialState, ObservableInternalHelper.simpleBiGenerator(generator), disposeState);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, S> Observable<T> generate(@NonNull Supplier<S> initialState, @NonNull BiFunction<S, Emitter<T>, S> generator) {
        return Observable.generate(initialState, generator, Functions.emptyConsumer());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, S> Observable<T> generate(@NonNull Supplier<S> initialState, @NonNull BiFunction<S, Emitter<T>, S> generator, @NonNull Consumer<? super S> disposeState) {
        Objects.requireNonNull(initialState, "initialState is null");
        Objects.requireNonNull(generator, "generator is null");
        Objects.requireNonNull(disposeState, "disposeState is null");
        return RxJavaPlugins.onAssembly(new ObservableGenerate<T, S>(initialState, generator, disposeState));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public static Observable<Long> interval(long initialDelay, long period, @NonNull TimeUnit unit) {
        return Observable.interval(initialDelay, period, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public static Observable<Long> interval(long initialDelay, long period, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableInterval(Math.max(0L, initialDelay), Math.max(0L, period), unit, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public static Observable<Long> interval(long period, @NonNull TimeUnit unit) {
        return Observable.interval(period, period, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public static Observable<Long> interval(long period, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return Observable.interval(period, period, unit, scheduler);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public static Observable<Long> intervalRange(long start2, long count2, long initialDelay, long period, @NonNull TimeUnit unit) {
        return Observable.intervalRange(start2, count2, initialDelay, period, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public static Observable<Long> intervalRange(long start2, long count2, long initialDelay, long period, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        if (count2 < 0L) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count2);
        }
        if (count2 == 0L) {
            return Observable.empty().delay(initialDelay, unit, scheduler);
        }
        long end = start2 + (count2 - 1L);
        if (start2 > 0L && end < 0L) {
            throw new IllegalArgumentException("Overflow! start + count is bigger than Long.MAX_VALUE");
        }
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableIntervalRange(start2, end, Math.max(0L, initialDelay), Math.max(0L, period), unit, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> just(@NonNull T item) {
        Objects.requireNonNull(item, "item is null");
        return RxJavaPlugins.onAssembly(new ObservableJust<T>(item));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> just(@NonNull T item1, @NonNull T item2) {
        Objects.requireNonNull(item1, "item1 is null");
        Objects.requireNonNull(item2, "item2 is null");
        return Observable.fromArray(item1, item2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> just(@NonNull T item1, @NonNull T item2, @NonNull T item3) {
        Objects.requireNonNull(item1, "item1 is null");
        Objects.requireNonNull(item2, "item2 is null");
        Objects.requireNonNull(item3, "item3 is null");
        return Observable.fromArray(item1, item2, item3);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> just(@NonNull T item1, @NonNull T item2, @NonNull T item3, @NonNull T item4) {
        Objects.requireNonNull(item1, "item1 is null");
        Objects.requireNonNull(item2, "item2 is null");
        Objects.requireNonNull(item3, "item3 is null");
        Objects.requireNonNull(item4, "item4 is null");
        return Observable.fromArray(item1, item2, item3, item4);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> just(@NonNull T item1, @NonNull T item2, @NonNull T item3, @NonNull T item4, @NonNull T item5) {
        Objects.requireNonNull(item1, "item1 is null");
        Objects.requireNonNull(item2, "item2 is null");
        Objects.requireNonNull(item3, "item3 is null");
        Objects.requireNonNull(item4, "item4 is null");
        Objects.requireNonNull(item5, "item5 is null");
        return Observable.fromArray(item1, item2, item3, item4, item5);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> just(@NonNull T item1, @NonNull T item2, @NonNull T item3, @NonNull T item4, @NonNull T item5, @NonNull T item6) {
        Objects.requireNonNull(item1, "item1 is null");
        Objects.requireNonNull(item2, "item2 is null");
        Objects.requireNonNull(item3, "item3 is null");
        Objects.requireNonNull(item4, "item4 is null");
        Objects.requireNonNull(item5, "item5 is null");
        Objects.requireNonNull(item6, "item6 is null");
        return Observable.fromArray(item1, item2, item3, item4, item5, item6);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> just(@NonNull T item1, @NonNull T item2, @NonNull T item3, @NonNull T item4, @NonNull T item5, @NonNull T item6, @NonNull T item7) {
        Objects.requireNonNull(item1, "item1 is null");
        Objects.requireNonNull(item2, "item2 is null");
        Objects.requireNonNull(item3, "item3 is null");
        Objects.requireNonNull(item4, "item4 is null");
        Objects.requireNonNull(item5, "item5 is null");
        Objects.requireNonNull(item6, "item6 is null");
        Objects.requireNonNull(item7, "item7 is null");
        return Observable.fromArray(item1, item2, item3, item4, item5, item6, item7);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> just(@NonNull T item1, @NonNull T item2, @NonNull T item3, @NonNull T item4, @NonNull T item5, @NonNull T item6, @NonNull T item7, @NonNull T item8) {
        Objects.requireNonNull(item1, "item1 is null");
        Objects.requireNonNull(item2, "item2 is null");
        Objects.requireNonNull(item3, "item3 is null");
        Objects.requireNonNull(item4, "item4 is null");
        Objects.requireNonNull(item5, "item5 is null");
        Objects.requireNonNull(item6, "item6 is null");
        Objects.requireNonNull(item7, "item7 is null");
        Objects.requireNonNull(item8, "item8 is null");
        return Observable.fromArray(item1, item2, item3, item4, item5, item6, item7, item8);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> just(@NonNull T item1, @NonNull T item2, @NonNull T item3, @NonNull T item4, @NonNull T item5, @NonNull T item6, @NonNull T item7, @NonNull T item8, @NonNull T item9) {
        Objects.requireNonNull(item1, "item1 is null");
        Objects.requireNonNull(item2, "item2 is null");
        Objects.requireNonNull(item3, "item3 is null");
        Objects.requireNonNull(item4, "item4 is null");
        Objects.requireNonNull(item5, "item5 is null");
        Objects.requireNonNull(item6, "item6 is null");
        Objects.requireNonNull(item7, "item7 is null");
        Objects.requireNonNull(item8, "item8 is null");
        Objects.requireNonNull(item9, "item9 is null");
        return Observable.fromArray(item1, item2, item3, item4, item5, item6, item7, item8, item9);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> just(@NonNull T item1, @NonNull T item2, @NonNull T item3, @NonNull T item4, @NonNull T item5, @NonNull T item6, @NonNull T item7, @NonNull T item8, @NonNull T item9, @NonNull T item10) {
        Objects.requireNonNull(item1, "item1 is null");
        Objects.requireNonNull(item2, "item2 is null");
        Objects.requireNonNull(item3, "item3 is null");
        Objects.requireNonNull(item4, "item4 is null");
        Objects.requireNonNull(item5, "item5 is null");
        Objects.requireNonNull(item6, "item6 is null");
        Objects.requireNonNull(item7, "item7 is null");
        Objects.requireNonNull(item8, "item8 is null");
        Objects.requireNonNull(item9, "item9 is null");
        Objects.requireNonNull(item10, "item10 is null");
        return Observable.fromArray(item1, item2, item3, item4, item5, item6, item7, item8, item9, item10);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> merge(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<? extends T>> sources, int maxConcurrency, int bufferSize) {
        return Observable.fromIterable(sources).flatMap(Functions.identity(), false, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Observable<T> mergeArray(int maxConcurrency, int bufferSize, ObservableSource<? extends T> ... sources) {
        return Observable.fromArray(sources).flatMap(Functions.identity(), false, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> merge(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<? extends T>> sources) {
        return Observable.fromIterable(sources).flatMap(Functions.identity());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> merge(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<? extends T>> sources, int maxConcurrency) {
        return Observable.fromIterable(sources).flatMap(Functions.identity(), maxConcurrency);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> merge(@NonNull ObservableSource<? extends ObservableSource<? extends T>> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new ObservableFlatMap(sources, Functions.identity(), false, Integer.MAX_VALUE, Observable.bufferSize()));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> merge(@NonNull ObservableSource<? extends ObservableSource<? extends T>> sources, int maxConcurrency) {
        Objects.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        return RxJavaPlugins.onAssembly(new ObservableFlatMap(sources, Functions.identity(), false, maxConcurrency, Observable.bufferSize()));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> merge(@NonNull ObservableSource<? extends T> source1, @NonNull ObservableSource<? extends T> source2) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        return Observable.fromArray(source1, source2).flatMap(Functions.identity(), false, 2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> merge(@NonNull ObservableSource<? extends T> source1, @NonNull ObservableSource<? extends T> source2, @NonNull ObservableSource<? extends T> source3) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        return Observable.fromArray(source1, source2, source3).flatMap(Functions.identity(), false, 3);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> merge(@NonNull ObservableSource<? extends T> source1, @NonNull ObservableSource<? extends T> source2, @NonNull ObservableSource<? extends T> source3, @NonNull ObservableSource<? extends T> source4) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        return Observable.fromArray(source1, source2, source3, source4).flatMap(Functions.identity(), false, 4);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Observable<T> mergeArray(ObservableSource<? extends T> ... sources) {
        return Observable.fromArray(sources).flatMap(Functions.identity(), sources.length);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> mergeDelayError(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<? extends T>> sources) {
        return Observable.fromIterable(sources).flatMap(Functions.identity(), true);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> mergeDelayError(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<? extends T>> sources, int maxConcurrency, int bufferSize) {
        return Observable.fromIterable(sources).flatMap(Functions.identity(), true, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Observable<T> mergeArrayDelayError(int maxConcurrency, int bufferSize, ObservableSource<? extends T> ... sources) {
        return Observable.fromArray(sources).flatMap(Functions.identity(), true, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> mergeDelayError(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<? extends T>> sources, int maxConcurrency) {
        return Observable.fromIterable(sources).flatMap(Functions.identity(), true, maxConcurrency);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> mergeDelayError(@NonNull ObservableSource<? extends ObservableSource<? extends T>> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new ObservableFlatMap(sources, Functions.identity(), true, Integer.MAX_VALUE, Observable.bufferSize()));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> mergeDelayError(@NonNull ObservableSource<? extends ObservableSource<? extends T>> sources, int maxConcurrency) {
        Objects.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        return RxJavaPlugins.onAssembly(new ObservableFlatMap(sources, Functions.identity(), true, maxConcurrency, Observable.bufferSize()));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> mergeDelayError(@NonNull ObservableSource<? extends T> source1, @NonNull ObservableSource<? extends T> source2) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        return Observable.fromArray(source1, source2).flatMap(Functions.identity(), true, 2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> mergeDelayError(@NonNull ObservableSource<? extends T> source1, @NonNull ObservableSource<? extends T> source2, @NonNull ObservableSource<? extends T> source3) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        return Observable.fromArray(source1, source2, source3).flatMap(Functions.identity(), true, 3);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> mergeDelayError(@NonNull ObservableSource<? extends T> source1, @NonNull ObservableSource<? extends T> source2, @NonNull ObservableSource<? extends T> source3, @NonNull ObservableSource<? extends T> source4) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        return Observable.fromArray(source1, source2, source3, source4).flatMap(Functions.identity(), true, 4);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Observable<T> mergeArrayDelayError(ObservableSource<? extends T> ... sources) {
        return Observable.fromArray(sources).flatMap(Functions.identity(), true, sources.length);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> never() {
        return RxJavaPlugins.onAssembly(ObservableNever.INSTANCE);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Observable<Integer> range(int start2, int count2) {
        if (count2 < 0) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count2);
        }
        if (count2 == 0) {
            return Observable.empty();
        }
        if (count2 == 1) {
            return Observable.just(start2);
        }
        if ((long)start2 + (long)(count2 - 1) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Integer overflow");
        }
        return RxJavaPlugins.onAssembly(new ObservableRange(start2, count2));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static Observable<Long> rangeLong(long start2, long count2) {
        if (count2 < 0L) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count2);
        }
        if (count2 == 0L) {
            return Observable.empty();
        }
        if (count2 == 1L) {
            return Observable.just(start2);
        }
        long end = start2 + (count2 - 1L);
        if (start2 > 0L && end < 0L) {
            throw new IllegalArgumentException("Overflow! start + count is bigger than Long.MAX_VALUE");
        }
        return RxJavaPlugins.onAssembly(new ObservableRangeLong(start2, count2));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<Boolean> sequenceEqual(@NonNull ObservableSource<? extends T> source1, @NonNull ObservableSource<? extends T> source2) {
        return Observable.sequenceEqual(source1, source2, ObjectHelper.equalsPredicate(), Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<Boolean> sequenceEqual(@NonNull ObservableSource<? extends T> source1, @NonNull ObservableSource<? extends T> source2, @NonNull BiPredicate<? super T, ? super T> isEqual) {
        return Observable.sequenceEqual(source1, source2, isEqual, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<Boolean> sequenceEqual(@NonNull ObservableSource<? extends T> source1, @NonNull ObservableSource<? extends T> source2, @NonNull BiPredicate<? super T, ? super T> isEqual, int bufferSize) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(isEqual, "isEqual is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableSequenceEqualSingle<T>(source1, source2, isEqual, bufferSize));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<Boolean> sequenceEqual(@NonNull ObservableSource<? extends T> source1, @NonNull ObservableSource<? extends T> source2, int bufferSize) {
        return Observable.sequenceEqual(source1, source2, ObjectHelper.equalsPredicate(), bufferSize);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> switchOnNext(@NonNull ObservableSource<? extends ObservableSource<? extends T>> sources, int bufferSize) {
        Objects.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableSwitchMap(sources, Functions.identity(), bufferSize, false));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> switchOnNext(@NonNull ObservableSource<? extends ObservableSource<? extends T>> sources) {
        return Observable.switchOnNext(sources, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> switchOnNextDelayError(@NonNull ObservableSource<? extends ObservableSource<? extends T>> sources) {
        return Observable.switchOnNextDelayError(sources, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> switchOnNextDelayError(@NonNull ObservableSource<? extends ObservableSource<? extends T>> sources, int bufferSize) {
        Objects.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableSwitchMap(sources, Functions.identity(), bufferSize, true));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public static Observable<Long> timer(long delay, @NonNull TimeUnit unit) {
        return Observable.timer(delay, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public static Observable<Long> timer(long delay, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableTimer(Math.max(delay, 0L), unit, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> unsafeCreate(@NonNull ObservableSource<T> onSubscribe) {
        Objects.requireNonNull(onSubscribe, "onSubscribe is null");
        if (onSubscribe instanceof Observable) {
            throw new IllegalArgumentException("unsafeCreate(Observable) should be upgraded");
        }
        return RxJavaPlugins.onAssembly(new ObservableFromUnsafeSource<T>(onSubscribe));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, D> Observable<T> using(@NonNull Supplier<? extends D> resourceSupplier, @NonNull Function<? super D, ? extends ObservableSource<? extends T>> sourceSupplier, @NonNull Consumer<? super D> resourceCleanup) {
        return Observable.using(resourceSupplier, sourceSupplier, resourceCleanup, true);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, D> Observable<T> using(@NonNull Supplier<? extends D> resourceSupplier, @NonNull Function<? super D, ? extends ObservableSource<? extends T>> sourceSupplier, @NonNull Consumer<? super D> resourceCleanup, boolean eager) {
        Objects.requireNonNull(resourceSupplier, "resourceSupplier is null");
        Objects.requireNonNull(sourceSupplier, "sourceSupplier is null");
        Objects.requireNonNull(resourceCleanup, "resourceCleanup is null");
        return RxJavaPlugins.onAssembly(new ObservableUsing(resourceSupplier, sourceSupplier, resourceCleanup, eager));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> wrap(@NonNull ObservableSource<T> source) {
        Objects.requireNonNull(source, "source is null");
        if (source instanceof Observable) {
            return RxJavaPlugins.onAssembly((Observable)source);
        }
        return RxJavaPlugins.onAssembly(new ObservableFromUnsafeSource<T>(source));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, R> Observable<R> zip(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<? extends T>> sources, @NonNull Function<? super Object[], ? extends R> zipper) {
        Objects.requireNonNull(zipper, "zipper is null");
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new ObservableZip(null, sources, zipper, Observable.bufferSize(), false));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, R> Observable<R> zip(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<? extends T>> sources, @NonNull Function<? super Object[], ? extends R> zipper, boolean delayError, int bufferSize) {
        Objects.requireNonNull(zipper, "zipper is null");
        Objects.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableZip(null, sources, zipper, bufferSize, delayError));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, R> Observable<R> zip(@NonNull ObservableSource<? extends T1> source1, @NonNull ObservableSource<? extends T2> source2, @NonNull BiFunction<? super T1, ? super T2, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Observable.zipArray(Functions.toFunction(zipper), false, Observable.bufferSize(), source1, source2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, R> Observable<R> zip(@NonNull ObservableSource<? extends T1> source1, @NonNull ObservableSource<? extends T2> source2, @NonNull BiFunction<? super T1, ? super T2, ? extends R> zipper, boolean delayError) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Observable.zipArray(Functions.toFunction(zipper), delayError, Observable.bufferSize(), source1, source2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, R> Observable<R> zip(@NonNull ObservableSource<? extends T1> source1, @NonNull ObservableSource<? extends T2> source2, @NonNull BiFunction<? super T1, ? super T2, ? extends R> zipper, boolean delayError, int bufferSize) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Observable.zipArray(Functions.toFunction(zipper), delayError, bufferSize, source1, source2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, R> Observable<R> zip(@NonNull ObservableSource<? extends T1> source1, @NonNull ObservableSource<? extends T2> source2, @NonNull ObservableSource<? extends T3> source3, @NonNull Function3<? super T1, ? super T2, ? super T3, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Observable.zipArray(Functions.toFunction(zipper), false, Observable.bufferSize(), source1, source2, source3);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, R> Observable<R> zip(@NonNull ObservableSource<? extends T1> source1, @NonNull ObservableSource<? extends T2> source2, @NonNull ObservableSource<? extends T3> source3, @NonNull ObservableSource<? extends T4> source4, @NonNull Function4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Observable.zipArray(Functions.toFunction(zipper), false, Observable.bufferSize(), source1, source2, source3, source4);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, R> Observable<R> zip(@NonNull ObservableSource<? extends T1> source1, @NonNull ObservableSource<? extends T2> source2, @NonNull ObservableSource<? extends T3> source3, @NonNull ObservableSource<? extends T4> source4, @NonNull ObservableSource<? extends T5> source5, @NonNull Function5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Observable.zipArray(Functions.toFunction(zipper), false, Observable.bufferSize(), source1, source2, source3, source4, source5);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, R> Observable<R> zip(@NonNull ObservableSource<? extends T1> source1, @NonNull ObservableSource<? extends T2> source2, @NonNull ObservableSource<? extends T3> source3, @NonNull ObservableSource<? extends T4> source4, @NonNull ObservableSource<? extends T5> source5, @NonNull ObservableSource<? extends T6> source6, @NonNull Function6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Observable.zipArray(Functions.toFunction(zipper), false, Observable.bufferSize(), source1, source2, source3, source4, source5, source6);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, T7, R> Observable<R> zip(@NonNull ObservableSource<? extends T1> source1, @NonNull ObservableSource<? extends T2> source2, @NonNull ObservableSource<? extends T3> source3, @NonNull ObservableSource<? extends T4> source4, @NonNull ObservableSource<? extends T5> source5, @NonNull ObservableSource<? extends T6> source6, @NonNull ObservableSource<? extends T7> source7, @NonNull Function7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(source7, "source7 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Observable.zipArray(Functions.toFunction(zipper), false, Observable.bufferSize(), source1, source2, source3, source4, source5, source6, source7);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Observable<R> zip(@NonNull ObservableSource<? extends T1> source1, @NonNull ObservableSource<? extends T2> source2, @NonNull ObservableSource<? extends T3> source3, @NonNull ObservableSource<? extends T4> source4, @NonNull ObservableSource<? extends T5> source5, @NonNull ObservableSource<? extends T6> source6, @NonNull ObservableSource<? extends T7> source7, @NonNull ObservableSource<? extends T8> source8, @NonNull Function8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(source7, "source7 is null");
        Objects.requireNonNull(source8, "source8 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Observable.zipArray(Functions.toFunction(zipper), false, Observable.bufferSize(), source1, source2, source3, source4, source5, source6, source7, source8);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Observable<R> zip(@NonNull ObservableSource<? extends T1> source1, @NonNull ObservableSource<? extends T2> source2, @NonNull ObservableSource<? extends T3> source3, @NonNull ObservableSource<? extends T4> source4, @NonNull ObservableSource<? extends T5> source5, @NonNull ObservableSource<? extends T6> source6, @NonNull ObservableSource<? extends T7> source7, @NonNull ObservableSource<? extends T8> source8, @NonNull ObservableSource<? extends T9> source9, @NonNull Function9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(source7, "source7 is null");
        Objects.requireNonNull(source8, "source8 is null");
        Objects.requireNonNull(source9, "source9 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Observable.zipArray(Functions.toFunction(zipper), false, Observable.bufferSize(), source1, source2, source3, source4, source5, source6, source7, source8, source9);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T, R> Observable<R> zipArray(@NonNull Function<? super Object[], ? extends R> zipper, boolean delayError, int bufferSize, ObservableSource<? extends T> ... sources) {
        Objects.requireNonNull(sources, "sources is null");
        if (sources.length == 0) {
            return Observable.empty();
        }
        Objects.requireNonNull(zipper, "zipper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableZip<T, R>(sources, null, zipper, bufferSize, delayError));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<Boolean> all(@NonNull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new ObservableAllSingle<T>(this, predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> ambWith(@NonNull ObservableSource<? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return Observable.ambArray(this, other);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<Boolean> any(@NonNull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new ObservableAnySingle<T>(this, predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final T blockingFirst() {
        BlockingFirstObserver observer = new BlockingFirstObserver();
        this.subscribe(observer);
        Object v = observer.blockingGet();
        if (v != null) {
            return v;
        }
        throw new NoSuchElementException();
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final T blockingFirst(@NonNull T defaultItem) {
        Objects.requireNonNull(defaultItem, "defaultItem is null");
        BlockingFirstObserver observer = new BlockingFirstObserver();
        this.subscribe(observer);
        Object v = observer.blockingGet();
        return v != null ? v : defaultItem;
    }

    @SchedulerSupport(value="none")
    public final void blockingForEach(@NonNull Consumer<? super T> onNext) {
        this.blockingForEach(onNext, Observable.bufferSize());
    }

    @SchedulerSupport(value="none")
    public final void blockingForEach(@NonNull Consumer<? super T> onNext, int capacityHint) {
        Objects.requireNonNull(onNext, "onNext is null");
        Iterator<T> it = this.blockingIterable(capacityHint).iterator();
        while (it.hasNext()) {
            try {
                onNext.accept(it.next());
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                ((Disposable)((Object)it)).dispose();
                throw ExceptionHelper.wrapOrThrow(e);
            }
        }
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Iterable<T> blockingIterable() {
        return this.blockingIterable(Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Iterable<T> blockingIterable(int capacityHint) {
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        return new BlockingObservableIterable(this, capacityHint);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final T blockingLast() {
        BlockingLastObserver observer = new BlockingLastObserver();
        this.subscribe(observer);
        Object v = observer.blockingGet();
        if (v != null) {
            return v;
        }
        throw new NoSuchElementException();
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final T blockingLast(@NonNull T defaultItem) {
        Objects.requireNonNull(defaultItem, "defaultItem is null");
        BlockingLastObserver observer = new BlockingLastObserver();
        this.subscribe(observer);
        Object v = observer.blockingGet();
        return v != null ? v : defaultItem;
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Iterable<T> blockingLatest() {
        return new BlockingObservableLatest(this);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Iterable<T> blockingMostRecent(@NonNull T initialItem) {
        Objects.requireNonNull(initialItem, "initialItem is null");
        return new BlockingObservableMostRecent<T>(this, initialItem);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Iterable<T> blockingNext() {
        return new BlockingObservableNext(this);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final T blockingSingle() {
        T v = this.singleElement().blockingGet();
        if (v == null) {
            throw new NoSuchElementException();
        }
        return v;
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final T blockingSingle(@NonNull T defaultItem) {
        return this.single(defaultItem).blockingGet();
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Future<T> toFuture() {
        return this.subscribeWith(new FutureObserver());
    }

    @SchedulerSupport(value="none")
    public final void blockingSubscribe() {
        ObservableBlockingSubscribe.subscribe(this);
    }

    @SchedulerSupport(value="none")
    public final void blockingSubscribe(@NonNull Consumer<? super T> onNext) {
        ObservableBlockingSubscribe.subscribe(this, onNext, Functions.ON_ERROR_MISSING, Functions.EMPTY_ACTION);
    }

    @SchedulerSupport(value="none")
    public final void blockingSubscribe(@NonNull Consumer<? super T> onNext, @NonNull Consumer<? super Throwable> onError2) {
        ObservableBlockingSubscribe.subscribe(this, onNext, onError2, Functions.EMPTY_ACTION);
    }

    @SchedulerSupport(value="none")
    public final void blockingSubscribe(@NonNull Consumer<? super T> onNext, @NonNull Consumer<? super Throwable> onError2, @NonNull Action onComplete) {
        ObservableBlockingSubscribe.subscribe(this, onNext, onError2, onComplete);
    }

    @SchedulerSupport(value="none")
    public final void blockingSubscribe(@NonNull Observer<? super T> observer) {
        Objects.requireNonNull(observer, "observer is null");
        ObservableBlockingSubscribe.subscribe(this, observer);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final @NonNull Observable<@NonNull List<T>> buffer(int count2) {
        return this.buffer(count2, count2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final @NonNull Observable<@NonNull List<T>> buffer(int count2, int skip) {
        return this.buffer(count2, skip, ArrayListSupplier.asSupplier());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U extends Collection<? super T>> Observable<U> buffer(int count2, int skip, @NonNull Supplier<U> bufferSupplier) {
        ObjectHelper.verifyPositive(count2, "count");
        ObjectHelper.verifyPositive(skip, "skip");
        Objects.requireNonNull(bufferSupplier, "bufferSupplier is null");
        return RxJavaPlugins.onAssembly(new ObservableBuffer(this, count2, skip, bufferSupplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U extends Collection<? super T>> Observable<U> buffer(int count2, @NonNull Supplier<U> bufferSupplier) {
        return this.buffer(count2, count2, bufferSupplier);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final @NonNull Observable<@NonNull List<T>> buffer(long timespan, long timeskip, @NonNull TimeUnit unit) {
        return this.buffer(timespan, timeskip, unit, Schedulers.computation(), ArrayListSupplier.asSupplier());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final @NonNull Observable<@NonNull List<T>> buffer(long timespan, long timeskip, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.buffer(timespan, timeskip, unit, scheduler, ArrayListSupplier.asSupplier());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final <U extends Collection<? super T>> Observable<U> buffer(long timespan, long timeskip, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, @NonNull Supplier<U> bufferSupplier) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        Objects.requireNonNull(bufferSupplier, "bufferSupplier is null");
        return RxJavaPlugins.onAssembly(new ObservableBufferTimed(this, timespan, timeskip, unit, scheduler, bufferSupplier, Integer.MAX_VALUE, false));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final @NonNull Observable<@NonNull List<T>> buffer(long timespan, @NonNull TimeUnit unit) {
        return this.buffer(timespan, unit, Schedulers.computation(), Integer.MAX_VALUE);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final @NonNull Observable<@NonNull List<T>> buffer(long timespan, @NonNull TimeUnit unit, int count2) {
        return this.buffer(timespan, unit, Schedulers.computation(), count2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final @NonNull Observable<@NonNull List<T>> buffer(long timespan, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, int count2) {
        return this.buffer(timespan, unit, scheduler, count2, ArrayListSupplier.asSupplier(), false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final <U extends Collection<? super T>> Observable<U> buffer(long timespan, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, int count2, @NonNull Supplier<U> bufferSupplier, boolean restartTimerOnMaxSize) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        Objects.requireNonNull(bufferSupplier, "bufferSupplier is null");
        ObjectHelper.verifyPositive(count2, "count");
        return RxJavaPlugins.onAssembly(new ObservableBufferTimed(this, timespan, timespan, unit, scheduler, bufferSupplier, count2, restartTimerOnMaxSize));
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final @NonNull Observable<@NonNull List<T>> buffer(long timespan, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.buffer(timespan, unit, scheduler, Integer.MAX_VALUE, ArrayListSupplier.asSupplier(), false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <TOpening, TClosing> @NonNull Observable<@NonNull List<T>> buffer(@NonNull ObservableSource<? extends TOpening> openingIndicator, @NonNull Function<? super TOpening, ? extends ObservableSource<? extends TClosing>> closingIndicator) {
        return this.buffer(openingIndicator, closingIndicator, ArrayListSupplier.asSupplier());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <TOpening, TClosing, U extends Collection<? super T>> Observable<U> buffer(@NonNull ObservableSource<? extends TOpening> openingIndicator, @NonNull Function<? super TOpening, ? extends ObservableSource<? extends TClosing>> closingIndicator, @NonNull Supplier<U> bufferSupplier) {
        Objects.requireNonNull(openingIndicator, "openingIndicator is null");
        Objects.requireNonNull(closingIndicator, "closingIndicator is null");
        Objects.requireNonNull(bufferSupplier, "bufferSupplier is null");
        return RxJavaPlugins.onAssembly(new ObservableBufferBoundary(this, openingIndicator, closingIndicator, bufferSupplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <B> @NonNull Observable<@NonNull List<T>> buffer(@NonNull ObservableSource<B> boundaryIndicator) {
        return this.buffer(boundaryIndicator, ArrayListSupplier.asSupplier());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <B> @NonNull Observable<@NonNull List<T>> buffer(@NonNull ObservableSource<B> boundaryIndicator, int initialCapacity) {
        ObjectHelper.verifyPositive(initialCapacity, "initialCapacity");
        return this.buffer(boundaryIndicator, Functions.createArrayList(initialCapacity));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <B, U extends Collection<? super T>> Observable<U> buffer(@NonNull ObservableSource<B> boundaryIndicator, @NonNull Supplier<U> bufferSupplier) {
        Objects.requireNonNull(boundaryIndicator, "boundaryIndicator is null");
        Objects.requireNonNull(bufferSupplier, "bufferSupplier is null");
        return RxJavaPlugins.onAssembly(new ObservableBufferExactBoundary(this, boundaryIndicator, bufferSupplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> cache() {
        return this.cacheWithInitialCapacity(16);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> cacheWithInitialCapacity(int initialCapacity) {
        ObjectHelper.verifyPositive(initialCapacity, "initialCapacity");
        return RxJavaPlugins.onAssembly(new ObservableCache(this, initialCapacity));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Observable<U> cast(@NonNull Class<U> clazz) {
        Objects.requireNonNull(clazz, "clazz is null");
        return this.map(Functions.castFunction(clazz));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Single<U> collect(@NonNull Supplier<? extends U> initialItemSupplier, @NonNull BiConsumer<? super U, ? super T> collector2) {
        Objects.requireNonNull(initialItemSupplier, "initialItemSupplier is null");
        Objects.requireNonNull(collector2, "collector is null");
        return RxJavaPlugins.onAssembly(new ObservableCollectSingle<T, U>(this, initialItemSupplier, collector2));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Single<U> collectInto(@NonNull U initialItem, @NonNull BiConsumer<? super U, ? super T> collector2) {
        Objects.requireNonNull(initialItem, "initialItem is null");
        return this.collect(Functions.justSupplier(initialItem), collector2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> compose(@NonNull ObservableTransformer<? super T, ? extends R> composer) {
        return Observable.wrap(Objects.requireNonNull(composer, "composer is null").apply(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> concatMap(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        return this.concatMap(mapper, 2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> concatMap(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper, int bufferSize) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        if (this instanceof ScalarSupplier) {
            Object v = ((ScalarSupplier)((Object)this)).get();
            if (v == null) {
                return Observable.empty();
            }
            return ObservableScalarXMap.scalarXMap(v, mapper);
        }
        return RxJavaPlugins.onAssembly(new ObservableConcatMap(this, mapper, bufferSize, ErrorMode.IMMEDIATE));
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final <R> Observable<R> concatMap(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper, int bufferSize, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableConcatMapScheduler(this, mapper, bufferSize, ErrorMode.IMMEDIATE, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> concatMapDelayError(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        return this.concatMapDelayError(mapper, true, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> concatMapDelayError(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper, boolean tillTheEnd, int bufferSize) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        if (this instanceof ScalarSupplier) {
            Object v = ((ScalarSupplier)((Object)this)).get();
            if (v == null) {
                return Observable.empty();
            }
            return ObservableScalarXMap.scalarXMap(v, mapper);
        }
        return RxJavaPlugins.onAssembly(new ObservableConcatMap(this, mapper, bufferSize, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY));
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final <R> Observable<R> concatMapDelayError(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper, boolean tillTheEnd, int bufferSize, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableConcatMapScheduler(this, mapper, bufferSize, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> concatMapEager(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        return this.concatMapEager(mapper, Integer.MAX_VALUE, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> concatMapEager(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper, int maxConcurrency, int bufferSize) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableConcatMapEager(this, mapper, ErrorMode.IMMEDIATE, maxConcurrency, bufferSize));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> concatMapEagerDelayError(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper, boolean tillTheEnd) {
        return this.concatMapEagerDelayError(mapper, tillTheEnd, Integer.MAX_VALUE, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> concatMapEagerDelayError(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper, boolean tillTheEnd, int maxConcurrency, int bufferSize) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableConcatMapEager(this, mapper, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY, maxConcurrency, bufferSize));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable concatMapCompletable(@NonNull Function<? super T, ? extends CompletableSource> mapper) {
        return this.concatMapCompletable(mapper, 2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable concatMapCompletable(@NonNull Function<? super T, ? extends CompletableSource> mapper, int capacityHint) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        return RxJavaPlugins.onAssembly(new ObservableConcatMapCompletable<T>(this, mapper, ErrorMode.IMMEDIATE, capacityHint));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable concatMapCompletableDelayError(@NonNull Function<? super T, ? extends CompletableSource> mapper) {
        return this.concatMapCompletableDelayError(mapper, true, 2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable concatMapCompletableDelayError(@NonNull Function<? super T, ? extends CompletableSource> mapper, boolean tillTheEnd) {
        return this.concatMapCompletableDelayError(mapper, tillTheEnd, 2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable concatMapCompletableDelayError(@NonNull Function<? super T, ? extends CompletableSource> mapper, boolean tillTheEnd, int bufferSize) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableConcatMapCompletable<T>(this, mapper, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY, bufferSize));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Observable<U> concatMapIterable(@NonNull @NonNull Function<? super T, @NonNull ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new ObservableFlattenIterable(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> concatMapMaybe(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper) {
        return this.concatMapMaybe(mapper, 2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> concatMapMaybe(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper, int bufferSize) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableConcatMapMaybe(this, mapper, ErrorMode.IMMEDIATE, bufferSize));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> concatMapMaybeDelayError(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper) {
        return this.concatMapMaybeDelayError(mapper, true, 2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> concatMapMaybeDelayError(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper, boolean tillTheEnd) {
        return this.concatMapMaybeDelayError(mapper, tillTheEnd, 2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> concatMapMaybeDelayError(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper, boolean tillTheEnd, int bufferSize) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableConcatMapMaybe(this, mapper, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY, bufferSize));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> concatMapSingle(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        return this.concatMapSingle(mapper, 2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> concatMapSingle(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper, int bufferSize) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableConcatMapSingle(this, mapper, ErrorMode.IMMEDIATE, bufferSize));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> concatMapSingleDelayError(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        return this.concatMapSingleDelayError(mapper, true, 2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> concatMapSingleDelayError(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper, boolean tillTheEnd) {
        return this.concatMapSingleDelayError(mapper, tillTheEnd, 2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> concatMapSingleDelayError(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper, boolean tillTheEnd, int bufferSize) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableConcatMapSingle(this, mapper, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY, bufferSize));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> concatWith(@NonNull ObservableSource<? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return Observable.concat(this, other);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> concatWith(@NonNull SingleSource<? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new ObservableConcatWithSingle<T>(this, other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> concatWith(@NonNull MaybeSource<? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new ObservableConcatWithMaybe<T>(this, other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> concatWith(@NonNull CompletableSource other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new ObservableConcatWithCompletable(this, other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<Boolean> contains(@NonNull Object item) {
        Objects.requireNonNull(item, "item is null");
        return this.any(Functions.equalsWith(item));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<Long> count() {
        return RxJavaPlugins.onAssembly(new ObservableCountSingle(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Observable<T> debounce(@NonNull Function<? super T, ? extends ObservableSource<U>> debounceIndicator) {
        Objects.requireNonNull(debounceIndicator, "debounceIndicator is null");
        return RxJavaPlugins.onAssembly(new ObservableDebounce(this, debounceIndicator));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<T> debounce(long timeout, @NonNull TimeUnit unit) {
        return this.debounce(timeout, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> debounce(long timeout, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableDebounceTimed(this, timeout, unit, scheduler, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    @Experimental
    public final Observable<T> debounce(long timeout, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, @NonNull Consumer<? super T> onDropped) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        Objects.requireNonNull(onDropped, "onDropped is null");
        return RxJavaPlugins.onAssembly(new ObservableDebounceTimed<T>(this, timeout, unit, scheduler, onDropped));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> defaultIfEmpty(@NonNull T defaultItem) {
        Objects.requireNonNull(defaultItem, "defaultItem is null");
        return this.switchIfEmpty(Observable.just(defaultItem));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Observable<T> delay(@NonNull Function<? super T, ? extends ObservableSource<U>> itemDelayIndicator) {
        Objects.requireNonNull(itemDelayIndicator, "itemDelayIndicator is null");
        return this.flatMap(ObservableInternalHelper.itemDelay(itemDelayIndicator));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<T> delay(long time, @NonNull TimeUnit unit) {
        return this.delay(time, unit, Schedulers.computation(), false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<T> delay(long time, @NonNull TimeUnit unit, boolean delayError) {
        return this.delay(time, unit, Schedulers.computation(), delayError);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> delay(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.delay(time, unit, scheduler, false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> delay(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean delayError) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableDelay(this, time, unit, scheduler, delayError));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, V> Observable<T> delay(@NonNull ObservableSource<U> subscriptionIndicator, @NonNull Function<? super T, ? extends ObservableSource<V>> itemDelayIndicator) {
        return this.delaySubscription(subscriptionIndicator).delay(itemDelayIndicator);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Observable<T> delaySubscription(@NonNull ObservableSource<U> subscriptionIndicator) {
        Objects.requireNonNull(subscriptionIndicator, "subscriptionIndicator is null");
        return RxJavaPlugins.onAssembly(new ObservableDelaySubscriptionOther(this, subscriptionIndicator));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<T> delaySubscription(long time, @NonNull TimeUnit unit) {
        return this.delaySubscription(time, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> delaySubscription(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.delaySubscription(Observable.timer(time, unit, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> dematerialize(@NonNull Function<? super T, Notification<R>> selector) {
        Objects.requireNonNull(selector, "selector is null");
        return RxJavaPlugins.onAssembly(new ObservableDematerialize<T, R>(this, selector));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> distinct() {
        return this.distinct(Functions.identity(), Functions.createHashSet());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <K> Observable<T> distinct(@NonNull Function<? super T, K> keySelector) {
        return this.distinct(keySelector, Functions.createHashSet());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <K> Observable<T> distinct(@NonNull Function<? super T, K> keySelector, @NonNull Supplier<? extends Collection<? super K>> collectionSupplier) {
        Objects.requireNonNull(keySelector, "keySelector is null");
        Objects.requireNonNull(collectionSupplier, "collectionSupplier is null");
        return RxJavaPlugins.onAssembly(new ObservableDistinct<T, K>(this, keySelector, collectionSupplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> distinctUntilChanged() {
        return this.distinctUntilChanged(Functions.identity());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <K> Observable<T> distinctUntilChanged(@NonNull Function<? super T, K> keySelector) {
        Objects.requireNonNull(keySelector, "keySelector is null");
        return RxJavaPlugins.onAssembly(new ObservableDistinctUntilChanged<T, K>(this, keySelector, ObjectHelper.equalsPredicate()));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> distinctUntilChanged(@NonNull BiPredicate<? super T, ? super T> comparer) {
        Objects.requireNonNull(comparer, "comparer is null");
        return RxJavaPlugins.onAssembly(new ObservableDistinctUntilChanged(this, Functions.identity(), comparer));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> doAfterNext(@NonNull Consumer<? super T> onAfterNext) {
        Objects.requireNonNull(onAfterNext, "onAfterNext is null");
        return RxJavaPlugins.onAssembly(new ObservableDoAfterNext<T>(this, onAfterNext));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> doAfterTerminate(@NonNull Action onAfterTerminate) {
        Objects.requireNonNull(onAfterTerminate, "onAfterTerminate is null");
        return this.doOnEach(Functions.emptyConsumer(), Functions.emptyConsumer(), Functions.EMPTY_ACTION, onAfterTerminate);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> doFinally(@NonNull Action onFinally) {
        Objects.requireNonNull(onFinally, "onFinally is null");
        return RxJavaPlugins.onAssembly(new ObservableDoFinally(this, onFinally));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> doOnDispose(@NonNull Action onDispose) {
        return this.doOnLifecycle(Functions.emptyConsumer(), onDispose);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> doOnComplete(@NonNull Action onComplete) {
        return this.doOnEach(Functions.emptyConsumer(), Functions.emptyConsumer(), onComplete, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    private Observable<T> doOnEach(@NonNull Consumer<? super T> onNext, @NonNull Consumer<? super Throwable> onError2, @NonNull Action onComplete, @NonNull Action onAfterTerminate) {
        Objects.requireNonNull(onNext, "onNext is null");
        Objects.requireNonNull(onError2, "onError is null");
        Objects.requireNonNull(onComplete, "onComplete is null");
        Objects.requireNonNull(onAfterTerminate, "onAfterTerminate is null");
        return RxJavaPlugins.onAssembly(new ObservableDoOnEach<T>(this, onNext, onError2, onComplete, onAfterTerminate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> doOnEach(@NonNull Consumer<? super Notification<T>> onNotification) {
        Objects.requireNonNull(onNotification, "onNotification is null");
        return this.doOnEach(Functions.notificationOnNext(onNotification), Functions.notificationOnError(onNotification), Functions.notificationOnComplete(onNotification), Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> doOnEach(@NonNull Observer<? super T> observer) {
        Objects.requireNonNull(observer, "observer is null");
        return this.doOnEach(ObservableInternalHelper.observerOnNext(observer), ObservableInternalHelper.observerOnError(observer), ObservableInternalHelper.observerOnComplete(observer), Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> doOnError(@NonNull Consumer<? super Throwable> onError2) {
        return this.doOnEach(Functions.emptyConsumer(), onError2, Functions.EMPTY_ACTION, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> doOnLifecycle(@NonNull Consumer<? super Disposable> onSubscribe, @NonNull Action onDispose) {
        Objects.requireNonNull(onSubscribe, "onSubscribe is null");
        Objects.requireNonNull(onDispose, "onDispose is null");
        return RxJavaPlugins.onAssembly(new ObservableDoOnLifecycle(this, onSubscribe, onDispose));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> doOnNext(@NonNull Consumer<? super T> onNext) {
        return this.doOnEach(onNext, Functions.emptyConsumer(), Functions.EMPTY_ACTION, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> doOnSubscribe(@NonNull Consumer<? super Disposable> onSubscribe) {
        return this.doOnLifecycle(onSubscribe, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> doOnTerminate(@NonNull Action onTerminate) {
        Objects.requireNonNull(onTerminate, "onTerminate is null");
        return this.doOnEach(Functions.emptyConsumer(), Functions.actionConsumer(onTerminate), onTerminate, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Maybe<T> elementAt(long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("index >= 0 required but it was " + index);
        }
        return RxJavaPlugins.onAssembly(new ObservableElementAtMaybe(this, index));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> elementAt(long index, @NonNull T defaultItem) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("index >= 0 required but it was " + index);
        }
        Objects.requireNonNull(defaultItem, "defaultItem is null");
        return RxJavaPlugins.onAssembly(new ObservableElementAtSingle<T>(this, index, defaultItem));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> elementAtOrError(long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("index >= 0 required but it was " + index);
        }
        return RxJavaPlugins.onAssembly(new ObservableElementAtSingle<Object>(this, index, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> filter(@NonNull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new ObservableFilter<T>(this, predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Maybe<T> firstElement() {
        return this.elementAt(0L);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> first(@NonNull T defaultItem) {
        return this.elementAt(0L, defaultItem);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> firstOrError() {
        return this.elementAtOrError(0L);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> flatMap(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        return this.flatMap(mapper, false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> flatMap(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper, boolean delayErrors) {
        return this.flatMap(mapper, delayErrors, Integer.MAX_VALUE);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> flatMap(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper, boolean delayErrors, int maxConcurrency) {
        return this.flatMap(mapper, delayErrors, maxConcurrency, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> flatMap(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        if (this instanceof ScalarSupplier) {
            Object v = ((ScalarSupplier)((Object)this)).get();
            if (v == null) {
                return Observable.empty();
            }
            return ObservableScalarXMap.scalarXMap(v, mapper);
        }
        return RxJavaPlugins.onAssembly(new ObservableFlatMap(this, mapper, delayErrors, maxConcurrency, bufferSize));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> flatMap(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> onNextMapper, @NonNull Function<? super Throwable, ? extends ObservableSource<? extends R>> onErrorMapper, @NonNull Supplier<? extends ObservableSource<? extends R>> onCompleteSupplier) {
        Objects.requireNonNull(onNextMapper, "onNextMapper is null");
        Objects.requireNonNull(onErrorMapper, "onErrorMapper is null");
        Objects.requireNonNull(onCompleteSupplier, "onCompleteSupplier is null");
        return Observable.merge(new ObservableMapNotification(this, onNextMapper, onErrorMapper, onCompleteSupplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> flatMap(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> onNextMapper, @NonNull Function<Throwable, ? extends ObservableSource<? extends R>> onErrorMapper, @NonNull Supplier<? extends ObservableSource<? extends R>> onCompleteSupplier, int maxConcurrency) {
        Objects.requireNonNull(onNextMapper, "onNextMapper is null");
        Objects.requireNonNull(onErrorMapper, "onErrorMapper is null");
        Objects.requireNonNull(onCompleteSupplier, "onCompleteSupplier is null");
        return Observable.merge(new ObservableMapNotification(this, onNextMapper, onErrorMapper, onCompleteSupplier), maxConcurrency);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> flatMap(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper, int maxConcurrency) {
        return this.flatMap(mapper, false, maxConcurrency, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Observable<R> flatMap(@NonNull Function<? super T, ? extends ObservableSource<? extends U>> mapper, @NonNull BiFunction<? super T, ? super U, ? extends R> combiner) {
        return this.flatMap(mapper, combiner, false, Observable.bufferSize(), Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Observable<R> flatMap(@NonNull Function<? super T, ? extends ObservableSource<? extends U>> mapper, @NonNull BiFunction<? super T, ? super U, ? extends R> combiner, boolean delayErrors) {
        return this.flatMap(mapper, combiner, delayErrors, Observable.bufferSize(), Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Observable<R> flatMap(@NonNull Function<? super T, ? extends ObservableSource<? extends U>> mapper, @NonNull BiFunction<? super T, ? super U, ? extends R> combiner, boolean delayErrors, int maxConcurrency) {
        return this.flatMap(mapper, combiner, delayErrors, maxConcurrency, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Observable<R> flatMap(@NonNull Function<? super T, ? extends ObservableSource<? extends U>> mapper, @NonNull BiFunction<? super T, ? super U, ? extends R> combiner, boolean delayErrors, int maxConcurrency, int bufferSize) {
        Objects.requireNonNull(mapper, "mapper is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return this.flatMap(ObservableInternalHelper.flatMapWithCombiner(mapper, combiner), delayErrors, maxConcurrency, bufferSize);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Observable<R> flatMap(@NonNull Function<? super T, ? extends ObservableSource<? extends U>> mapper, @NonNull BiFunction<? super T, ? super U, ? extends R> combiner, int maxConcurrency) {
        return this.flatMap(mapper, combiner, false, maxConcurrency, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable flatMapCompletable(@NonNull Function<? super T, ? extends CompletableSource> mapper) {
        return this.flatMapCompletable(mapper, false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable flatMapCompletable(@NonNull Function<? super T, ? extends CompletableSource> mapper, boolean delayErrors) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new ObservableFlatMapCompletableCompletable<T>(this, mapper, delayErrors));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Observable<U> flatMapIterable(@NonNull @NonNull Function<? super T, @NonNull ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new ObservableFlattenIterable(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, V> Observable<V> flatMapIterable(@NonNull @NonNull Function<? super T, @NonNull ? extends Iterable<? extends U>> mapper, @NonNull BiFunction<? super T, ? super U, ? extends V> combiner) {
        Objects.requireNonNull(mapper, "mapper is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return this.flatMap(ObservableInternalHelper.flatMapIntoIterable(mapper), combiner, false, Observable.bufferSize(), Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> flatMapMaybe(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper) {
        return this.flatMapMaybe(mapper, false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> flatMapMaybe(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper, boolean delayErrors) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new ObservableFlatMapMaybe(this, mapper, delayErrors));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> flatMapSingle(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        return this.flatMapSingle(mapper, false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> flatMapSingle(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper, boolean delayErrors) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new ObservableFlatMapSingle(this, mapper, delayErrors));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable forEach(@NonNull Consumer<? super T> onNext) {
        return this.subscribe(onNext);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable forEachWhile(@NonNull Predicate<? super T> onNext) {
        return this.forEachWhile(onNext, Functions.ON_ERROR_MISSING, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable forEachWhile(@NonNull Predicate<? super T> onNext, @NonNull Consumer<? super Throwable> onError2) {
        return this.forEachWhile(onNext, onError2, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable forEachWhile(@NonNull Predicate<? super T> onNext, @NonNull Consumer<? super Throwable> onError2, @NonNull Action onComplete) {
        Objects.requireNonNull(onNext, "onNext is null");
        Objects.requireNonNull(onError2, "onError is null");
        Objects.requireNonNull(onComplete, "onComplete is null");
        ForEachWhileObserver<? super T> o = new ForEachWhileObserver<T>(onNext, onError2, onComplete);
        this.subscribe(o);
        return o;
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <K> Observable<GroupedObservable<K, T>> groupBy(@NonNull Function<? super T, ? extends K> keySelector) {
        return this.groupBy(keySelector, Functions.identity(), false, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <K> Observable<GroupedObservable<K, T>> groupBy(@NonNull Function<? super T, ? extends K> keySelector, boolean delayError) {
        return this.groupBy(keySelector, Functions.identity(), delayError, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <K, V> Observable<GroupedObservable<K, V>> groupBy(@NonNull Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector) {
        return this.groupBy(keySelector, valueSelector, false, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <K, V> Observable<GroupedObservable<K, V>> groupBy(@NonNull Function<? super T, ? extends K> keySelector, @NonNull Function<? super T, ? extends V> valueSelector, boolean delayError) {
        return this.groupBy(keySelector, valueSelector, delayError, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <K, V> Observable<GroupedObservable<K, V>> groupBy(@NonNull Function<? super T, ? extends K> keySelector, @NonNull Function<? super T, ? extends V> valueSelector, boolean delayError, int bufferSize) {
        Objects.requireNonNull(keySelector, "keySelector is null");
        Objects.requireNonNull(valueSelector, "valueSelector is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableGroupBy<T, K, V>(this, keySelector, valueSelector, bufferSize, delayError));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <TRight, TLeftEnd, TRightEnd, R> Observable<R> groupJoin(@NonNull ObservableSource<? extends TRight> other, @NonNull Function<? super T, ? extends ObservableSource<TLeftEnd>> leftEnd, @NonNull Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd, @NonNull BiFunction<? super T, ? super Observable<TRight>, ? extends R> resultSelector) {
        Objects.requireNonNull(other, "other is null");
        Objects.requireNonNull(leftEnd, "leftEnd is null");
        Objects.requireNonNull(rightEnd, "rightEnd is null");
        Objects.requireNonNull(resultSelector, "resultSelector is null");
        return RxJavaPlugins.onAssembly(new ObservableGroupJoin(this, other, leftEnd, rightEnd, resultSelector));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> hide() {
        return RxJavaPlugins.onAssembly(new ObservableHide(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable ignoreElements() {
        return RxJavaPlugins.onAssembly(new ObservableIgnoreElementsCompletable(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<Boolean> isEmpty() {
        return this.all(Functions.alwaysFalse());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <TRight, TLeftEnd, TRightEnd, R> Observable<R> join(@NonNull ObservableSource<? extends TRight> other, @NonNull Function<? super T, ? extends ObservableSource<TLeftEnd>> leftEnd, @NonNull Function<? super TRight, ? extends ObservableSource<TRightEnd>> rightEnd, @NonNull BiFunction<? super T, ? super TRight, ? extends R> resultSelector) {
        Objects.requireNonNull(other, "other is null");
        Objects.requireNonNull(leftEnd, "leftEnd is null");
        Objects.requireNonNull(rightEnd, "rightEnd is null");
        Objects.requireNonNull(resultSelector, "resultSelector is null");
        return RxJavaPlugins.onAssembly(new ObservableJoin(this, other, leftEnd, rightEnd, resultSelector));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Maybe<T> lastElement() {
        return RxJavaPlugins.onAssembly(new ObservableLastMaybe(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> last(@NonNull T defaultItem) {
        Objects.requireNonNull(defaultItem, "defaultItem is null");
        return RxJavaPlugins.onAssembly(new ObservableLastSingle<T>(this, defaultItem));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> lastOrError() {
        return RxJavaPlugins.onAssembly(new ObservableLastSingle<Object>(this, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> lift(@NonNull ObservableOperator<? extends R, ? super T> lifter) {
        Objects.requireNonNull(lifter, "lifter is null");
        return RxJavaPlugins.onAssembly(new ObservableLift<R, T>(this, lifter));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> map(@NonNull Function<? super T, ? extends R> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new ObservableMap<T, R>(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<Notification<T>> materialize() {
        return RxJavaPlugins.onAssembly(new ObservableMaterialize(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> mergeWith(@NonNull ObservableSource<? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return Observable.merge(this, other);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> mergeWith(@NonNull SingleSource<? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new ObservableMergeWithSingle<T>(this, other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> mergeWith(@NonNull MaybeSource<? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new ObservableMergeWithMaybe<T>(this, other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> mergeWith(@NonNull CompletableSource other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new ObservableMergeWithCompletable(this, other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> observeOn(@NonNull Scheduler scheduler) {
        return this.observeOn(scheduler, false, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> observeOn(@NonNull Scheduler scheduler, boolean delayError) {
        return this.observeOn(scheduler, delayError, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> observeOn(@NonNull Scheduler scheduler, boolean delayError, int bufferSize) {
        Objects.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableObserveOn(this, scheduler, delayError, bufferSize));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Observable<U> ofType(@NonNull Class<U> clazz) {
        Objects.requireNonNull(clazz, "clazz is null");
        return this.filter(Functions.isInstanceOf(clazz)).cast(clazz);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> onErrorComplete() {
        return this.onErrorComplete(Functions.alwaysTrue());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> onErrorComplete(@NonNull Predicate<? super Throwable> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new ObservableOnErrorComplete(this, predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> onErrorResumeNext(@NonNull Function<? super Throwable, ? extends ObservableSource<? extends T>> fallbackSupplier) {
        Objects.requireNonNull(fallbackSupplier, "fallbackSupplier is null");
        return RxJavaPlugins.onAssembly(new ObservableOnErrorNext(this, fallbackSupplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> onErrorResumeWith(@NonNull ObservableSource<? extends T> fallback) {
        Objects.requireNonNull(fallback, "fallback is null");
        return this.onErrorResumeNext(Functions.justFunction(fallback));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> onErrorReturn(@NonNull Function<? super Throwable, ? extends T> itemSupplier) {
        Objects.requireNonNull(itemSupplier, "itemSupplier is null");
        return RxJavaPlugins.onAssembly(new ObservableOnErrorReturn<T>(this, itemSupplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> onErrorReturnItem(@NonNull T item) {
        Objects.requireNonNull(item, "item is null");
        return this.onErrorReturn(Functions.justFunction(item));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> onTerminateDetach() {
        return RxJavaPlugins.onAssembly(new ObservableDetach(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final ConnectableObservable<T> publish() {
        return RxJavaPlugins.onAssembly(new ObservablePublish(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> publish(@NonNull Function<? super Observable<T>, ? extends ObservableSource<R>> selector) {
        Objects.requireNonNull(selector, "selector is null");
        return RxJavaPlugins.onAssembly(new ObservablePublishSelector(this, selector));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Maybe<T> reduce(@NonNull BiFunction<T, T, T> reducer) {
        Objects.requireNonNull(reducer, "reducer is null");
        return RxJavaPlugins.onAssembly(new ObservableReduceMaybe<T>(this, reducer));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Single<R> reduce(R seed, @NonNull BiFunction<R, ? super T, R> reducer) {
        Objects.requireNonNull(seed, "seed is null");
        Objects.requireNonNull(reducer, "reducer is null");
        return RxJavaPlugins.onAssembly(new ObservableReduceSeedSingle<T, R>(this, seed, reducer));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Single<R> reduceWith(@NonNull Supplier<R> seedSupplier, @NonNull BiFunction<R, ? super T, R> reducer) {
        Objects.requireNonNull(seedSupplier, "seedSupplier is null");
        Objects.requireNonNull(reducer, "reducer is null");
        return RxJavaPlugins.onAssembly(new ObservableReduceWithSingle<T, R>(this, seedSupplier, reducer));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> repeat() {
        return this.repeat(Long.MAX_VALUE);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> repeat(long times) {
        if (times < 0L) {
            throw new IllegalArgumentException("times >= 0 required but it was " + times);
        }
        if (times == 0L) {
            return Observable.empty();
        }
        return RxJavaPlugins.onAssembly(new ObservableRepeat(this, times));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> repeatUntil(@NonNull BooleanSupplier stop2) {
        Objects.requireNonNull(stop2, "stop is null");
        return RxJavaPlugins.onAssembly(new ObservableRepeatUntil(this, stop2));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> repeatWhen(@NonNull Function<? super Observable<Object>, ? extends ObservableSource<?>> handler) {
        Objects.requireNonNull(handler, "handler is null");
        return RxJavaPlugins.onAssembly(new ObservableRepeatWhen(this, handler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final ConnectableObservable<T> replay() {
        return ObservableReplay.createFrom(this);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> replay(@NonNull Function<? super Observable<T>, ? extends ObservableSource<R>> selector) {
        Objects.requireNonNull(selector, "selector is null");
        return ObservableReplay.multicastSelector(ObservableInternalHelper.replaySupplier(this), selector);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> replay(@NonNull Function<? super Observable<T>, ? extends ObservableSource<R>> selector, int bufferSize) {
        Objects.requireNonNull(selector, "selector is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return ObservableReplay.multicastSelector(ObservableInternalHelper.replaySupplier(this, bufferSize, false), selector);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> replay(@NonNull Function<? super Observable<T>, ? extends ObservableSource<R>> selector, int bufferSize, boolean eagerTruncate) {
        Objects.requireNonNull(selector, "selector is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return ObservableReplay.multicastSelector(ObservableInternalHelper.replaySupplier(this, bufferSize, eagerTruncate), selector);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final <R> Observable<R> replay(@NonNull Function<? super Observable<T>, ? extends ObservableSource<R>> selector, int bufferSize, long time, @NonNull TimeUnit unit) {
        return this.replay(selector, bufferSize, time, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final <R> Observable<R> replay(@NonNull Function<? super Observable<T>, ? extends ObservableSource<R>> selector, int bufferSize, long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(selector, "selector is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return ObservableReplay.multicastSelector(ObservableInternalHelper.replaySupplier(this, bufferSize, time, unit, scheduler, false), selector);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final <R> Observable<R> replay(@NonNull Function<? super Observable<T>, ? extends ObservableSource<R>> selector, int bufferSize, long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean eagerTruncate) {
        Objects.requireNonNull(selector, "selector is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return ObservableReplay.multicastSelector(ObservableInternalHelper.replaySupplier(this, bufferSize, time, unit, scheduler, eagerTruncate), selector);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final <R> Observable<R> replay(@NonNull Function<? super Observable<T>, ? extends ObservableSource<R>> selector, long time, @NonNull TimeUnit unit) {
        return this.replay(selector, time, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final <R> Observable<R> replay(@NonNull Function<? super Observable<T>, ? extends ObservableSource<R>> selector, long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(selector, "selector is null");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return ObservableReplay.multicastSelector(ObservableInternalHelper.replaySupplier(this, time, unit, scheduler, false), selector);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final <R> Observable<R> replay(@NonNull Function<? super Observable<T>, ? extends ObservableSource<R>> selector, long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean eagerTruncate) {
        Objects.requireNonNull(selector, "selector is null");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return ObservableReplay.multicastSelector(ObservableInternalHelper.replaySupplier(this, time, unit, scheduler, eagerTruncate), selector);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final ConnectableObservable<T> replay(int bufferSize) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return ObservableReplay.create(this, bufferSize, false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final ConnectableObservable<T> replay(int bufferSize, boolean eagerTruncate) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return ObservableReplay.create(this, bufferSize, eagerTruncate);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final ConnectableObservable<T> replay(int bufferSize, long time, @NonNull TimeUnit unit) {
        return this.replay(bufferSize, time, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final ConnectableObservable<T> replay(int bufferSize, long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return ObservableReplay.create(this, time, unit, scheduler, bufferSize, false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final ConnectableObservable<T> replay(int bufferSize, long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean eagerTruncate) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return ObservableReplay.create(this, time, unit, scheduler, bufferSize, eagerTruncate);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final ConnectableObservable<T> replay(long time, @NonNull TimeUnit unit) {
        return this.replay(time, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final ConnectableObservable<T> replay(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return ObservableReplay.create(this, time, unit, scheduler, false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final ConnectableObservable<T> replay(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean eagerTruncate) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return ObservableReplay.create(this, time, unit, scheduler, eagerTruncate);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> retry() {
        return this.retry(Long.MAX_VALUE, Functions.alwaysTrue());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> retry(@NonNull BiPredicate<? super Integer, ? super Throwable> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new ObservableRetryBiPredicate(this, predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> retry(long times) {
        return this.retry(times, Functions.alwaysTrue());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> retry(long times, @NonNull Predicate<? super Throwable> predicate) {
        if (times < 0L) {
            throw new IllegalArgumentException("times >= 0 required but it was " + times);
        }
        Objects.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new ObservableRetryPredicate(this, times, predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> retry(@NonNull Predicate<? super Throwable> predicate) {
        return this.retry(Long.MAX_VALUE, predicate);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> retryUntil(@NonNull BooleanSupplier stop2) {
        Objects.requireNonNull(stop2, "stop is null");
        return this.retry(Long.MAX_VALUE, Functions.predicateReverseFor(stop2));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> retryWhen(@NonNull Function<? super Observable<Throwable>, ? extends ObservableSource<?>> handler) {
        Objects.requireNonNull(handler, "handler is null");
        return RxJavaPlugins.onAssembly(new ObservableRetryWhen(this, handler));
    }

    @SchedulerSupport(value="none")
    public final void safeSubscribe(@NonNull Observer<? super T> observer) {
        Objects.requireNonNull(observer, "observer is null");
        if (observer instanceof SafeObserver) {
            this.subscribe(observer);
        } else {
            this.subscribe(new SafeObserver<T>(observer));
        }
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<T> sample(long period, @NonNull TimeUnit unit) {
        return this.sample(period, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<T> sample(long period, @NonNull TimeUnit unit, boolean emitLast) {
        return this.sample(period, unit, Schedulers.computation(), emitLast);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> sample(long period, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableSampleTimed(this, period, unit, scheduler, false, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> sample(long period, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean emitLast) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableSampleTimed(this, period, unit, scheduler, emitLast, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    @Experimental
    public final Observable<T> sample(long period, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean emitLast, @NonNull Consumer<? super T> onDropped) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        Objects.requireNonNull(onDropped, "onDropped is null");
        return RxJavaPlugins.onAssembly(new ObservableSampleTimed<T>(this, period, unit, scheduler, emitLast, onDropped));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Observable<T> sample(@NonNull ObservableSource<U> sampler) {
        Objects.requireNonNull(sampler, "sampler is null");
        return RxJavaPlugins.onAssembly(new ObservableSampleWithObservable(this, sampler, false));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Observable<T> sample(@NonNull ObservableSource<U> sampler, boolean emitLast) {
        Objects.requireNonNull(sampler, "sampler is null");
        return RxJavaPlugins.onAssembly(new ObservableSampleWithObservable(this, sampler, emitLast));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> scan(@NonNull BiFunction<T, T, T> accumulator) {
        Objects.requireNonNull(accumulator, "accumulator is null");
        return RxJavaPlugins.onAssembly(new ObservableScan<T>(this, accumulator));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> scan(@NonNull R initialValue, @NonNull BiFunction<R, ? super T, R> accumulator) {
        Objects.requireNonNull(initialValue, "initialValue is null");
        return this.scanWith(Functions.justSupplier(initialValue), accumulator);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> scanWith(@NonNull Supplier<R> seedSupplier, @NonNull BiFunction<R, ? super T, R> accumulator) {
        Objects.requireNonNull(seedSupplier, "seedSupplier is null");
        Objects.requireNonNull(accumulator, "accumulator is null");
        return RxJavaPlugins.onAssembly(new ObservableScanSeed<T, R>(this, seedSupplier, accumulator));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> serialize() {
        return RxJavaPlugins.onAssembly(new ObservableSerialized(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> share() {
        return this.publish().refCount();
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Maybe<T> singleElement() {
        return RxJavaPlugins.onAssembly(new ObservableSingleMaybe(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> single(@NonNull T defaultItem) {
        Objects.requireNonNull(defaultItem, "defaultItem is null");
        return RxJavaPlugins.onAssembly(new ObservableSingleSingle<T>(this, defaultItem));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> singleOrError() {
        return RxJavaPlugins.onAssembly(new ObservableSingleSingle<Object>(this, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> skip(long count2) {
        if (count2 < 0L) {
            throw new IllegalArgumentException("count >= 0 expected but it was " + count2);
        }
        if (count2 == 0L) {
            return RxJavaPlugins.onAssembly(this);
        }
        return RxJavaPlugins.onAssembly(new ObservableSkip(this, count2));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<T> skip(long time, @NonNull TimeUnit unit) {
        return this.skipUntil(Observable.timer(time, unit));
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> skip(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.skipUntil(Observable.timer(time, unit, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> skipLast(int count2) {
        if (count2 < 0) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count2);
        }
        if (count2 == 0) {
            return RxJavaPlugins.onAssembly(this);
        }
        return RxJavaPlugins.onAssembly(new ObservableSkipLast(this, count2));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:trampoline")
    @NonNull
    public final Observable<T> skipLast(long time, @NonNull TimeUnit unit) {
        return this.skipLast(time, unit, Schedulers.trampoline(), false, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:trampoline")
    @NonNull
    public final Observable<T> skipLast(long time, @NonNull TimeUnit unit, boolean delayError) {
        return this.skipLast(time, unit, Schedulers.trampoline(), delayError, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> skipLast(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.skipLast(time, unit, scheduler, false, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> skipLast(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean delayError) {
        return this.skipLast(time, unit, scheduler, delayError, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> skipLast(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean delayError, int bufferSize) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        int s = bufferSize << 1;
        return RxJavaPlugins.onAssembly(new ObservableSkipLastTimed(this, time, unit, scheduler, s, delayError));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Observable<T> skipUntil(@NonNull ObservableSource<U> other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new ObservableSkipUntil(this, other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> skipWhile(@NonNull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new ObservableSkipWhile<T>(this, predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> sorted() {
        return this.toList().toObservable().map(Functions.listSorter(Functions.naturalComparator())).flatMapIterable(Functions.identity());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> sorted(@NonNull Comparator<? super T> comparator2) {
        Objects.requireNonNull(comparator2, "comparator is null");
        return this.toList().toObservable().map(Functions.listSorter(comparator2)).flatMapIterable(Functions.identity());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> startWithIterable(@NonNull Iterable<? extends T> items) {
        return Observable.concatArray(Observable.fromIterable(items), this);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> startWith(@NonNull CompletableSource other) {
        Objects.requireNonNull(other, "other is null");
        return Observable.concat(Completable.wrap(other).toObservable(), this);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> startWith(@NonNull SingleSource<T> other) {
        Objects.requireNonNull(other, "other is null");
        return Observable.concat(Single.wrap(other).toObservable(), this);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> startWith(@NonNull MaybeSource<T> other) {
        Objects.requireNonNull(other, "other is null");
        return Observable.concat(Maybe.wrap(other).toObservable(), this);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> startWith(@NonNull ObservableSource<? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return Observable.concatArray(other, this);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> startWithItem(@NonNull T item) {
        return Observable.concatArray(Observable.just(item), this);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public final Observable<T> startWithArray(T ... items) {
        Observable<T> fromArray = Observable.fromArray(items);
        if (fromArray == Observable.empty()) {
            return RxJavaPlugins.onAssembly(this);
        }
        return Observable.concatArray(fromArray, this);
    }

    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable subscribe() {
        return this.subscribe(Functions.emptyConsumer(), Functions.ON_ERROR_MISSING, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable subscribe(@NonNull Consumer<? super T> onNext) {
        return this.subscribe(onNext, Functions.ON_ERROR_MISSING, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable subscribe(@NonNull Consumer<? super T> onNext, @NonNull Consumer<? super Throwable> onError2) {
        return this.subscribe(onNext, onError2, Functions.EMPTY_ACTION);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable subscribe(@NonNull Consumer<? super T> onNext, @NonNull Consumer<? super Throwable> onError2, @NonNull Action onComplete) {
        Objects.requireNonNull(onNext, "onNext is null");
        Objects.requireNonNull(onError2, "onError is null");
        Objects.requireNonNull(onComplete, "onComplete is null");
        LambdaObserver<? super T> ls = new LambdaObserver<T>(onNext, onError2, onComplete, Functions.emptyConsumer());
        this.subscribe(ls);
        return ls;
    }

    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable subscribe(@NonNull Consumer<? super T> onNext, @NonNull Consumer<? super Throwable> onError2, @NonNull Action onComplete, @NonNull DisposableContainer container) {
        Objects.requireNonNull(onNext, "onNext is null");
        Objects.requireNonNull(onError2, "onError is null");
        Objects.requireNonNull(onComplete, "onComplete is null");
        Objects.requireNonNull(container, "container is null");
        DisposableAutoReleaseObserver<? super T> observer = new DisposableAutoReleaseObserver<T>(container, onNext, onError2, onComplete);
        container.add(observer);
        this.subscribe(observer);
        return observer;
    }

    @Override
    @SchedulerSupport(value="none")
    public final void subscribe(@NonNull Observer<? super T> observer) {
        Objects.requireNonNull(observer, "observer is null");
        try {
            observer = RxJavaPlugins.onSubscribe(this, observer);
            Objects.requireNonNull(observer, "The RxJavaPlugins.onSubscribe hook returned a null Observer. Please change the handler provided to RxJavaPlugins.setOnObservableSubscribe for invalid null returns. Further reading: https://github.com/ReactiveX/RxJava/wiki/Plugins");
            this.subscribeActual(observer);
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(e);
            NullPointerException npe = new NullPointerException("Actually not, but can't throw other exceptions due to RS");
            npe.initCause(e);
            throw npe;
        }
    }

    protected abstract void subscribeActual(@NonNull Observer<? super T> var1);

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <E extends Observer<? super T>> E subscribeWith(E observer) {
        this.subscribe(observer);
        return observer;
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> subscribeOn(@NonNull Scheduler scheduler) {
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableSubscribeOn(this, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> switchIfEmpty(@NonNull ObservableSource<? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new ObservableSwitchIfEmpty<T>(this, other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> switchMap(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        return this.switchMap(mapper, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> switchMap(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper, int bufferSize) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        if (this instanceof ScalarSupplier) {
            Object v = ((ScalarSupplier)((Object)this)).get();
            if (v == null) {
                return Observable.empty();
            }
            return ObservableScalarXMap.scalarXMap(v, mapper);
        }
        return RxJavaPlugins.onAssembly(new ObservableSwitchMap(this, mapper, bufferSize, false));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable switchMapCompletable(@NonNull Function<? super T, ? extends CompletableSource> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new ObservableSwitchMapCompletable<T>(this, mapper, false));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable switchMapCompletableDelayError(@NonNull Function<? super T, ? extends CompletableSource> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new ObservableSwitchMapCompletable<T>(this, mapper, true));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> switchMapMaybe(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new ObservableSwitchMapMaybe(this, mapper, false));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> switchMapMaybeDelayError(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new ObservableSwitchMapMaybe(this, mapper, true));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> switchMapSingle(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new ObservableSwitchMapSingle(this, mapper, false));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> switchMapSingleDelayError(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new ObservableSwitchMapSingle(this, mapper, true));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> switchMapDelayError(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        return this.switchMapDelayError(mapper, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> switchMapDelayError(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper, int bufferSize) {
        Objects.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        if (this instanceof ScalarSupplier) {
            Object v = ((ScalarSupplier)((Object)this)).get();
            if (v == null) {
                return Observable.empty();
            }
            return ObservableScalarXMap.scalarXMap(v, mapper);
        }
        return RxJavaPlugins.onAssembly(new ObservableSwitchMap(this, mapper, bufferSize, true));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> take(long count2) {
        if (count2 < 0L) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count2);
        }
        return RxJavaPlugins.onAssembly(new ObservableTake(this, count2));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> take(long time, @NonNull TimeUnit unit) {
        return this.takeUntil(Observable.timer(time, unit));
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> take(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.takeUntil(Observable.timer(time, unit, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> takeLast(int count2) {
        if (count2 < 0) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count2);
        }
        if (count2 == 0) {
            return RxJavaPlugins.onAssembly(new ObservableIgnoreElements(this));
        }
        if (count2 == 1) {
            return RxJavaPlugins.onAssembly(new ObservableTakeLastOne(this));
        }
        return RxJavaPlugins.onAssembly(new ObservableTakeLast(this, count2));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:trampoline")
    @NonNull
    public final Observable<T> takeLast(long count2, long time, @NonNull TimeUnit unit) {
        return this.takeLast(count2, time, unit, Schedulers.trampoline(), false, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> takeLast(long count2, long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.takeLast(count2, time, unit, scheduler, false, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> takeLast(long count2, long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean delayError, int bufferSize) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        if (count2 < 0L) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count2);
        }
        return RxJavaPlugins.onAssembly(new ObservableTakeLastTimed(this, count2, time, unit, scheduler, bufferSize, delayError));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:trampoline")
    @NonNull
    public final Observable<T> takeLast(long time, @NonNull TimeUnit unit) {
        return this.takeLast(time, unit, Schedulers.trampoline(), false, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:trampoline")
    @NonNull
    public final Observable<T> takeLast(long time, @NonNull TimeUnit unit, boolean delayError) {
        return this.takeLast(time, unit, Schedulers.trampoline(), delayError, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> takeLast(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.takeLast(time, unit, scheduler, false, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> takeLast(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean delayError) {
        return this.takeLast(time, unit, scheduler, delayError, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> takeLast(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean delayError, int bufferSize) {
        return this.takeLast(Long.MAX_VALUE, time, unit, scheduler, delayError, bufferSize);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Observable<T> takeUntil(@NonNull ObservableSource<U> other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new ObservableTakeUntil(this, other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> takeUntil(@NonNull Predicate<? super T> stopPredicate) {
        Objects.requireNonNull(stopPredicate, "stopPredicate is null");
        return RxJavaPlugins.onAssembly(new ObservableTakeUntilPredicate<T>(this, stopPredicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> takeWhile(@NonNull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new ObservableTakeWhile<T>(this, predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<T> throttleFirst(long windowDuration, @NonNull TimeUnit unit) {
        return this.throttleFirst(windowDuration, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> throttleFirst(long skipDuration, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableThrottleFirstTimed(this, skipDuration, unit, scheduler, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    @Experimental
    public final Observable<T> throttleFirst(long skipDuration, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, @NonNull Consumer<? super T> onDropped) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        Objects.requireNonNull(onDropped, "onDropped is null");
        return RxJavaPlugins.onAssembly(new ObservableThrottleFirstTimed<T>(this, skipDuration, unit, scheduler, onDropped));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<T> throttleLast(long intervalDuration, @NonNull TimeUnit unit) {
        return this.sample(intervalDuration, unit);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    @Experimental
    public final Observable<T> throttleLast(long intervalDuration, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, @NonNull Consumer<? super T> onDropped) {
        return this.sample(intervalDuration, unit, scheduler, false, onDropped);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> throttleLast(long intervalDuration, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.sample(intervalDuration, unit, scheduler);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<T> throttleLatest(long timeout, @NonNull TimeUnit unit) {
        return this.throttleLatest(timeout, unit, Schedulers.computation(), false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<T> throttleLatest(long timeout, @NonNull TimeUnit unit, boolean emitLast) {
        return this.throttleLatest(timeout, unit, Schedulers.computation(), emitLast);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> throttleLatest(long timeout, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.throttleLatest(timeout, unit, scheduler, false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> throttleLatest(long timeout, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean emitLast) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableThrottleLatest(this, timeout, unit, scheduler, emitLast, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    @Experimental
    public final Observable<T> throttleLatest(long timeout, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean emitLast, @NonNull Consumer<? super T> onDropped) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        Objects.requireNonNull(onDropped, "onDropped is null");
        return RxJavaPlugins.onAssembly(new ObservableThrottleLatest<T>(this, timeout, unit, scheduler, emitLast, onDropped));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<T> throttleWithTimeout(long timeout, @NonNull TimeUnit unit) {
        return this.debounce(timeout, unit);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> throttleWithTimeout(long timeout, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.debounce(timeout, unit, scheduler);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    @Experimental
    public final Observable<T> throttleWithTimeout(long timeout, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, @NonNull Consumer<? super T> onDropped) {
        return this.debounce(timeout, unit, scheduler, onDropped);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<Timed<T>> timeInterval() {
        return this.timeInterval(TimeUnit.MILLISECONDS, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<Timed<T>> timeInterval(@NonNull Scheduler scheduler) {
        return this.timeInterval(TimeUnit.MILLISECONDS, scheduler);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<Timed<T>> timeInterval(@NonNull TimeUnit unit) {
        return this.timeInterval(unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<Timed<T>> timeInterval(@NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableTimeInterval(this, unit, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <V> Observable<T> timeout(@NonNull Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator) {
        return this.timeout0(null, itemTimeoutIndicator, null);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <V> Observable<T> timeout(@NonNull Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator, @NonNull ObservableSource<? extends T> fallback) {
        Objects.requireNonNull(fallback, "fallback is null");
        return this.timeout0(null, itemTimeoutIndicator, fallback);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<T> timeout(long timeout, @NonNull TimeUnit unit) {
        return this.timeout0(timeout, unit, null, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<T> timeout(long timeout, @NonNull TimeUnit unit, @NonNull ObservableSource<? extends T> fallback) {
        Objects.requireNonNull(fallback, "fallback is null");
        return this.timeout0(timeout, unit, fallback, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> timeout(long timeout, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, @NonNull ObservableSource<? extends T> fallback) {
        Objects.requireNonNull(fallback, "fallback is null");
        return this.timeout0(timeout, unit, fallback, scheduler);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> timeout(long timeout, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.timeout0(timeout, unit, null, scheduler);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, V> Observable<T> timeout(@NonNull ObservableSource<U> firstTimeoutIndicator, @NonNull Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator) {
        Objects.requireNonNull(firstTimeoutIndicator, "firstTimeoutIndicator is null");
        return this.timeout0(firstTimeoutIndicator, itemTimeoutIndicator, null);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, V> Observable<T> timeout(@NonNull ObservableSource<U> firstTimeoutIndicator, @NonNull Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator, @NonNull ObservableSource<? extends T> fallback) {
        Objects.requireNonNull(firstTimeoutIndicator, "firstTimeoutIndicator is null");
        Objects.requireNonNull(fallback, "fallback is null");
        return this.timeout0(firstTimeoutIndicator, itemTimeoutIndicator, fallback);
    }

    @NonNull
    private Observable<T> timeout0(long timeout, @NonNull TimeUnit unit, @Nullable ObservableSource<? extends T> fallback, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableTimeoutTimed<T>(this, timeout, unit, scheduler, fallback));
    }

    @NonNull
    private <U, V> Observable<T> timeout0(@NonNull ObservableSource<U> firstTimeoutIndicator, @NonNull Function<? super T, ? extends ObservableSource<V>> itemTimeoutIndicator, @Nullable ObservableSource<? extends T> fallback) {
        Objects.requireNonNull(itemTimeoutIndicator, "itemTimeoutIndicator is null");
        return RxJavaPlugins.onAssembly(new ObservableTimeout(this, firstTimeoutIndicator, itemTimeoutIndicator, fallback));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<Timed<T>> timestamp() {
        return this.timestamp(TimeUnit.MILLISECONDS, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<Timed<T>> timestamp(@NonNull Scheduler scheduler) {
        return this.timestamp(TimeUnit.MILLISECONDS, scheduler);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<Timed<T>> timestamp(@NonNull TimeUnit unit) {
        return this.timestamp(unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<Timed<T>> timestamp(@NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return this.map(Functions.timestampWith(unit, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> R to(@NonNull ObservableConverter<T, ? extends R> converter) {
        return Objects.requireNonNull(converter, "converter is null").apply(this);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final @NonNull Single<@NonNull List<T>> toList() {
        return this.toList(16);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final @NonNull Single<@NonNull List<T>> toList(int capacityHint) {
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        return RxJavaPlugins.onAssembly(new ObservableToListSingle(this, capacityHint));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U extends Collection<? super T>> Single<U> toList(@NonNull Supplier<U> collectionSupplier) {
        Objects.requireNonNull(collectionSupplier, "collectionSupplier is null");
        return RxJavaPlugins.onAssembly(new ObservableToListSingle(this, collectionSupplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <K> @NonNull Single<@NonNull Map<K, T>> toMap(@NonNull Function<? super T, ? extends K> keySelector) {
        Objects.requireNonNull(keySelector, "keySelector is null");
        return this.collect(HashMapSupplier.asSupplier(), Functions.toMapKeySelector(keySelector));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <K, V> Single<Map<K, V>> toMap(@NonNull Function<? super T, ? extends K> keySelector, @NonNull Function<? super T, ? extends V> valueSelector) {
        Objects.requireNonNull(keySelector, "keySelector is null");
        Objects.requireNonNull(valueSelector, "valueSelector is null");
        return this.collect(HashMapSupplier.asSupplier(), Functions.toMapKeyValueSelector(keySelector, valueSelector));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <K, V> Single<Map<K, V>> toMap(@NonNull Function<? super T, ? extends K> keySelector, @NonNull Function<? super T, ? extends V> valueSelector, @NonNull Supplier<? extends Map<K, V>> mapSupplier) {
        Objects.requireNonNull(keySelector, "keySelector is null");
        Objects.requireNonNull(valueSelector, "valueSelector is null");
        Objects.requireNonNull(mapSupplier, "mapSupplier is null");
        return this.collect(mapSupplier, Functions.toMapKeyValueSelector(keySelector, valueSelector));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <K> @NonNull Single<@NonNull Map<K, Collection<T>>> toMultimap(@NonNull Function<? super T, ? extends K> keySelector) {
        Function valueSelector = Functions.identity();
        Supplier mapSupplier = HashMapSupplier.asSupplier();
        Function collectionFactory = ArrayListSupplier.asFunction();
        return this.toMultimap(keySelector, valueSelector, mapSupplier, collectionFactory);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <K, V> @NonNull Single<@NonNull Map<K, Collection<V>>> toMultimap(@NonNull Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector) {
        Supplier mapSupplier = HashMapSupplier.asSupplier();
        Function collectionFactory = ArrayListSupplier.asFunction();
        return this.toMultimap(keySelector, valueSelector, mapSupplier, collectionFactory);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <K, V> @NonNull Single<@NonNull Map<K, Collection<V>>> toMultimap(@NonNull Function<? super T, ? extends K> keySelector, @NonNull Function<? super T, ? extends V> valueSelector, @NonNull Supplier<? extends Map<K, Collection<V>>> mapSupplier, @NonNull Function<? super K, ? extends Collection<? super V>> collectionFactory) {
        Objects.requireNonNull(keySelector, "keySelector is null");
        Objects.requireNonNull(valueSelector, "valueSelector is null");
        Objects.requireNonNull(mapSupplier, "mapSupplier is null");
        Objects.requireNonNull(collectionFactory, "collectionFactory is null");
        return this.collect(mapSupplier, Functions.toMultimapKeyValueSelector(keySelector, valueSelector, collectionFactory));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <K, V> @NonNull Single<@NonNull Map<K, Collection<V>>> toMultimap(@NonNull Function<? super T, ? extends K> keySelector, @NonNull Function<? super T, ? extends V> valueSelector, @NonNull Supplier<Map<K, Collection<V>>> mapSupplier) {
        return this.toMultimap(keySelector, valueSelector, mapSupplier, ArrayListSupplier.asFunction());
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> toFlowable(@NonNull BackpressureStrategy strategy) {
        Objects.requireNonNull(strategy, "strategy is null");
        FlowableFromObservable f = new FlowableFromObservable(this);
        switch (strategy) {
            case DROP: {
                return f.onBackpressureDrop();
            }
            case LATEST: {
                return f.onBackpressureLatest();
            }
            case MISSING: {
                return f;
            }
            case ERROR: {
                return RxJavaPlugins.onAssembly(new FlowableOnBackpressureError(f));
            }
        }
        return f.onBackpressureBuffer();
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final @NonNull Single<@NonNull List<T>> toSortedList() {
        return this.toSortedList(Functions.naturalComparator());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final @NonNull Single<@NonNull List<T>> toSortedList(@NonNull Comparator<? super T> comparator2) {
        Objects.requireNonNull(comparator2, "comparator is null");
        return this.toList().map(Functions.listSorter(comparator2));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final @NonNull Single<@NonNull List<T>> toSortedList(@NonNull Comparator<? super T> comparator2, int capacityHint) {
        Objects.requireNonNull(comparator2, "comparator is null");
        return this.toList(capacityHint).map(Functions.listSorter(comparator2));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final @NonNull Single<@NonNull List<T>> toSortedList(int capacityHint) {
        return this.toSortedList(Functions.naturalComparator(), capacityHint);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<T> unsubscribeOn(@NonNull Scheduler scheduler) {
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new ObservableUnsubscribeOn(this, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<Observable<T>> window(long count2) {
        return this.window(count2, count2, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<Observable<T>> window(long count2, long skip) {
        return this.window(count2, skip, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<Observable<T>> window(long count2, long skip, int bufferSize) {
        ObjectHelper.verifyPositive(count2, "count");
        ObjectHelper.verifyPositive(skip, "skip");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableWindow(this, count2, skip, bufferSize));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<Observable<T>> window(long timespan, long timeskip, @NonNull TimeUnit unit) {
        return this.window(timespan, timeskip, unit, Schedulers.computation(), Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<Observable<T>> window(long timespan, long timeskip, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.window(timespan, timeskip, unit, scheduler, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<Observable<T>> window(long timespan, long timeskip, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, int bufferSize) {
        ObjectHelper.verifyPositive(timespan, "timespan");
        ObjectHelper.verifyPositive(timeskip, "timeskip");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        Objects.requireNonNull(scheduler, "scheduler is null");
        Objects.requireNonNull(unit, "unit is null");
        return RxJavaPlugins.onAssembly(new ObservableWindowTimed(this, timespan, timeskip, unit, scheduler, Long.MAX_VALUE, bufferSize, false));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<Observable<T>> window(long timespan, @NonNull TimeUnit unit) {
        return this.window(timespan, unit, Schedulers.computation(), Long.MAX_VALUE, false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<Observable<T>> window(long timespan, @NonNull TimeUnit unit, long count2) {
        return this.window(timespan, unit, Schedulers.computation(), count2, false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Observable<Observable<T>> window(long timespan, @NonNull TimeUnit unit, long count2, boolean restart) {
        return this.window(timespan, unit, Schedulers.computation(), count2, restart);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<Observable<T>> window(long timespan, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.window(timespan, unit, scheduler, Long.MAX_VALUE, false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<Observable<T>> window(long timespan, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, long count2) {
        return this.window(timespan, unit, scheduler, count2, false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<Observable<T>> window(long timespan, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, long count2, boolean restart) {
        return this.window(timespan, unit, scheduler, count2, restart, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Observable<Observable<T>> window(long timespan, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, long count2, boolean restart, int bufferSize) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        Objects.requireNonNull(scheduler, "scheduler is null");
        Objects.requireNonNull(unit, "unit is null");
        ObjectHelper.verifyPositive(count2, "count");
        return RxJavaPlugins.onAssembly(new ObservableWindowTimed(this, timespan, timespan, unit, scheduler, count2, bufferSize, restart));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <B> Observable<Observable<T>> window(@NonNull ObservableSource<B> boundaryIndicator) {
        return this.window(boundaryIndicator, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <B> Observable<Observable<T>> window(@NonNull ObservableSource<B> boundaryIndicator, int bufferSize) {
        Objects.requireNonNull(boundaryIndicator, "boundaryIndicator is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableWindowBoundary(this, boundaryIndicator, bufferSize));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, V> Observable<Observable<T>> window(@NonNull ObservableSource<U> openingIndicator, @NonNull Function<? super U, ? extends ObservableSource<V>> closingIndicator) {
        return this.window(openingIndicator, closingIndicator, Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, V> Observable<Observable<T>> window(@NonNull ObservableSource<U> openingIndicator, @NonNull Function<? super U, ? extends ObservableSource<V>> closingIndicator, int bufferSize) {
        Objects.requireNonNull(openingIndicator, "openingIndicator is null");
        Objects.requireNonNull(closingIndicator, "closingIndicator is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new ObservableWindowBoundarySelector(this, openingIndicator, closingIndicator, bufferSize));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Observable<R> withLatestFrom(@NonNull ObservableSource<? extends U> other, @NonNull BiFunction<? super T, ? super U, ? extends R> combiner) {
        Objects.requireNonNull(other, "other is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return RxJavaPlugins.onAssembly(new ObservableWithLatestFrom<T, U, R>(this, combiner, other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <T1, T2, R> Observable<R> withLatestFrom(@NonNull ObservableSource<T1> source1, @NonNull ObservableSource<T2> source2, @NonNull Function3<? super T, ? super T1, ? super T2, R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        Function<Object[], R> f = Functions.toFunction(combiner);
        return this.withLatestFrom(new ObservableSource[]{source1, source2}, f);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <T1, T2, T3, R> Observable<R> withLatestFrom(@NonNull ObservableSource<T1> source1, @NonNull ObservableSource<T2> source2, @NonNull ObservableSource<T3> source3, @NonNull Function4<? super T, ? super T1, ? super T2, ? super T3, R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        Function<Object[], R> f = Functions.toFunction(combiner);
        return this.withLatestFrom(new ObservableSource[]{source1, source2, source3}, f);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <T1, T2, T3, T4, R> Observable<R> withLatestFrom(@NonNull ObservableSource<T1> source1, @NonNull ObservableSource<T2> source2, @NonNull ObservableSource<T3> source3, @NonNull ObservableSource<T4> source4, @NonNull Function5<? super T, ? super T1, ? super T2, ? super T3, ? super T4, R> combiner) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(combiner, "combiner is null");
        Function<Object[], R> f = Functions.toFunction(combiner);
        return this.withLatestFrom(new ObservableSource[]{source1, source2, source3, source4}, f);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> withLatestFrom(@NonNull ObservableSource<?>[] others, @NonNull Function<? super Object[], R> combiner) {
        Objects.requireNonNull(others, "others is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return RxJavaPlugins.onAssembly(new ObservableWithLatestFromMany(this, others, combiner));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> withLatestFrom(@NonNull @NonNull Iterable<@NonNull ? extends ObservableSource<?>> others, @NonNull Function<? super Object[], R> combiner) {
        Objects.requireNonNull(others, "others is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return RxJavaPlugins.onAssembly(new ObservableWithLatestFromMany(this, others, combiner));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Observable<R> zipWith(@NonNull Iterable<U> other, @NonNull BiFunction<? super T, ? super U, ? extends R> zipper) {
        Objects.requireNonNull(other, "other is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return RxJavaPlugins.onAssembly(new ObservableZipIterable<T, U, R>(this, other, zipper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Observable<R> zipWith(@NonNull ObservableSource<? extends U> other, @NonNull BiFunction<? super T, ? super U, ? extends R> zipper) {
        Objects.requireNonNull(other, "other is null");
        return Observable.zip(this, other, zipper);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Observable<R> zipWith(@NonNull ObservableSource<? extends U> other, @NonNull BiFunction<? super T, ? super U, ? extends R> zipper, boolean delayError) {
        return Observable.zip(this, other, zipper, delayError);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Observable<R> zipWith(@NonNull ObservableSource<? extends U> other, @NonNull BiFunction<? super T, ? super U, ? extends R> zipper, boolean delayError, int bufferSize) {
        return Observable.zip(this, other, zipper, delayError, bufferSize);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final TestObserver<T> test() {
        TestObserver to = new TestObserver();
        this.subscribe(to);
        return to;
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final TestObserver<T> test(boolean dispose) {
        TestObserver to = new TestObserver();
        if (dispose) {
            to.dispose();
        }
        this.subscribe(to);
        return to;
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> @NonNull Observable<@NonNull T> fromOptional(@NonNull Optional<T> optional2) {
        Objects.requireNonNull(optional2, "optional is null");
        return optional2.map(Observable::just).orElseGet(Observable::empty);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> @NonNull Observable<@NonNull T> fromCompletionStage(@NonNull CompletionStage<T> stage) {
        Objects.requireNonNull(stage, "stage is null");
        return RxJavaPlugins.onAssembly(new ObservableFromCompletionStage<T>(stage));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> @NonNull Observable<@NonNull T> fromStream(@NonNull Stream<T> stream) {
        Objects.requireNonNull(stream, "stream is null");
        return RxJavaPlugins.onAssembly(new ObservableFromStream<T>(stream));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> mapOptional(@NonNull @NonNull Function<? super T, @NonNull Optional<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new ObservableMapOptional<T, R>(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R, A> Single<R> collect(@NonNull Collector<? super T, A, R> collector2) {
        Objects.requireNonNull(collector2, "collector is null");
        return RxJavaPlugins.onAssembly(new ObservableCollectWithCollectorSingle<T, A, R>(this, collector2));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final CompletionStage<T> firstStage(@Nullable T defaultItem) {
        return this.subscribeWith(new ObservableFirstStageObserver<T>(true, defaultItem));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final CompletionStage<T> singleStage(@Nullable T defaultItem) {
        return this.subscribeWith(new ObservableSingleStageObserver<T>(true, defaultItem));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final CompletionStage<T> lastStage(@Nullable T defaultItem) {
        return this.subscribeWith(new ObservableLastStageObserver<T>(true, defaultItem));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final CompletionStage<T> firstOrErrorStage() {
        return this.subscribeWith(new ObservableFirstStageObserver<Object>(false, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final CompletionStage<T> singleOrErrorStage() {
        return this.subscribeWith(new ObservableSingleStageObserver<Object>(false, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final CompletionStage<T> lastOrErrorStage() {
        return this.subscribeWith(new ObservableLastStageObserver<Object>(false, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Stream<T> blockingStream() {
        return this.blockingStream(Observable.bufferSize());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Stream<T> blockingStream(int capacityHint) {
        Iterator<T> iterator2 = this.blockingIterable(capacityHint).iterator();
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator2, 0), false).onClose(((Disposable)((Object)iterator2))::dispose);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> concatMapStream(@NonNull @NonNull Function<? super T, @NonNull ? extends Stream<? extends R>> mapper) {
        return this.flatMapStream(mapper);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> flatMapStream(@NonNull @NonNull Function<? super T, @NonNull ? extends Stream<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new ObservableFlatMapStream(this, mapper));
    }
}

