/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.core;

import io.reactivex.rxjava3.annotations.BackpressureKind;
import io.reactivex.rxjava3.annotations.BackpressureSupport;
import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.annotations.SchedulerSupport;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Notification;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.core.SingleConverter;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleOnSubscribe;
import io.reactivex.rxjava3.core.SingleOperator;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.core.SingleTransformer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.disposables.DisposableContainer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.BiConsumer;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.BiPredicate;
import io.reactivex.rxjava3.functions.BooleanSupplier;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Function3;
import io.reactivex.rxjava3.functions.Function4;
import io.reactivex.rxjava3.functions.Function5;
import io.reactivex.rxjava3.functions.Function6;
import io.reactivex.rxjava3.functions.Function7;
import io.reactivex.rxjava3.functions.Function8;
import io.reactivex.rxjava3.functions.Function9;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.fuseable.FuseToFlowable;
import io.reactivex.rxjava3.internal.fuseable.FuseToMaybe;
import io.reactivex.rxjava3.internal.fuseable.FuseToObservable;
import io.reactivex.rxjava3.internal.jdk8.CompletionStageConsumer;
import io.reactivex.rxjava3.internal.jdk8.SingleFlattenStreamAsFlowable;
import io.reactivex.rxjava3.internal.jdk8.SingleFlattenStreamAsObservable;
import io.reactivex.rxjava3.internal.jdk8.SingleFromCompletionStage;
import io.reactivex.rxjava3.internal.jdk8.SingleMapOptional;
import io.reactivex.rxjava3.internal.observers.BiConsumerSingleObserver;
import io.reactivex.rxjava3.internal.observers.BlockingDisposableMultiObserver;
import io.reactivex.rxjava3.internal.observers.BlockingMultiObserver;
import io.reactivex.rxjava3.internal.observers.ConsumerSingleObserver;
import io.reactivex.rxjava3.internal.observers.DisposableAutoReleaseMultiObserver;
import io.reactivex.rxjava3.internal.observers.FutureMultiObserver;
import io.reactivex.rxjava3.internal.observers.SafeSingleObserver;
import io.reactivex.rxjava3.internal.operators.completable.CompletableFromSingle;
import io.reactivex.rxjava3.internal.operators.completable.CompletableToFlowable;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableFlatMapSinglePublisher;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableSingleSingle;
import io.reactivex.rxjava3.internal.operators.maybe.MaybeFilterSingle;
import io.reactivex.rxjava3.internal.operators.maybe.MaybeFromSingle;
import io.reactivex.rxjava3.internal.operators.maybe.MaybeToSingle;
import io.reactivex.rxjava3.internal.operators.mixed.FlowableConcatMapSinglePublisher;
import io.reactivex.rxjava3.internal.operators.mixed.FlowableSwitchMapSinglePublisher;
import io.reactivex.rxjava3.internal.operators.mixed.ObservableConcatMapSingle;
import io.reactivex.rxjava3.internal.operators.mixed.SingleFlatMapObservable;
import io.reactivex.rxjava3.internal.operators.observable.ObservableSingleSingle;
import io.reactivex.rxjava3.internal.operators.single.SingleAmb;
import io.reactivex.rxjava3.internal.operators.single.SingleCache;
import io.reactivex.rxjava3.internal.operators.single.SingleContains;
import io.reactivex.rxjava3.internal.operators.single.SingleCreate;
import io.reactivex.rxjava3.internal.operators.single.SingleDefer;
import io.reactivex.rxjava3.internal.operators.single.SingleDelay;
import io.reactivex.rxjava3.internal.operators.single.SingleDelayWithCompletable;
import io.reactivex.rxjava3.internal.operators.single.SingleDelayWithObservable;
import io.reactivex.rxjava3.internal.operators.single.SingleDelayWithPublisher;
import io.reactivex.rxjava3.internal.operators.single.SingleDelayWithSingle;
import io.reactivex.rxjava3.internal.operators.single.SingleDematerialize;
import io.reactivex.rxjava3.internal.operators.single.SingleDetach;
import io.reactivex.rxjava3.internal.operators.single.SingleDoAfterSuccess;
import io.reactivex.rxjava3.internal.operators.single.SingleDoAfterTerminate;
import io.reactivex.rxjava3.internal.operators.single.SingleDoFinally;
import io.reactivex.rxjava3.internal.operators.single.SingleDoOnDispose;
import io.reactivex.rxjava3.internal.operators.single.SingleDoOnError;
import io.reactivex.rxjava3.internal.operators.single.SingleDoOnEvent;
import io.reactivex.rxjava3.internal.operators.single.SingleDoOnLifecycle;
import io.reactivex.rxjava3.internal.operators.single.SingleDoOnSubscribe;
import io.reactivex.rxjava3.internal.operators.single.SingleDoOnSuccess;
import io.reactivex.rxjava3.internal.operators.single.SingleDoOnTerminate;
import io.reactivex.rxjava3.internal.operators.single.SingleEquals;
import io.reactivex.rxjava3.internal.operators.single.SingleError;
import io.reactivex.rxjava3.internal.operators.single.SingleFlatMap;
import io.reactivex.rxjava3.internal.operators.single.SingleFlatMapBiSelector;
import io.reactivex.rxjava3.internal.operators.single.SingleFlatMapCompletable;
import io.reactivex.rxjava3.internal.operators.single.SingleFlatMapIterableFlowable;
import io.reactivex.rxjava3.internal.operators.single.SingleFlatMapIterableObservable;
import io.reactivex.rxjava3.internal.operators.single.SingleFlatMapMaybe;
import io.reactivex.rxjava3.internal.operators.single.SingleFlatMapNotification;
import io.reactivex.rxjava3.internal.operators.single.SingleFlatMapPublisher;
import io.reactivex.rxjava3.internal.operators.single.SingleFromCallable;
import io.reactivex.rxjava3.internal.operators.single.SingleFromPublisher;
import io.reactivex.rxjava3.internal.operators.single.SingleFromSupplier;
import io.reactivex.rxjava3.internal.operators.single.SingleFromUnsafeSource;
import io.reactivex.rxjava3.internal.operators.single.SingleHide;
import io.reactivex.rxjava3.internal.operators.single.SingleInternalHelper;
import io.reactivex.rxjava3.internal.operators.single.SingleJust;
import io.reactivex.rxjava3.internal.operators.single.SingleLift;
import io.reactivex.rxjava3.internal.operators.single.SingleMap;
import io.reactivex.rxjava3.internal.operators.single.SingleMaterialize;
import io.reactivex.rxjava3.internal.operators.single.SingleNever;
import io.reactivex.rxjava3.internal.operators.single.SingleObserveOn;
import io.reactivex.rxjava3.internal.operators.single.SingleOnErrorComplete;
import io.reactivex.rxjava3.internal.operators.single.SingleOnErrorReturn;
import io.reactivex.rxjava3.internal.operators.single.SingleResumeNext;
import io.reactivex.rxjava3.internal.operators.single.SingleSubscribeOn;
import io.reactivex.rxjava3.internal.operators.single.SingleTakeUntil;
import io.reactivex.rxjava3.internal.operators.single.SingleTimeInterval;
import io.reactivex.rxjava3.internal.operators.single.SingleTimeout;
import io.reactivex.rxjava3.internal.operators.single.SingleTimer;
import io.reactivex.rxjava3.internal.operators.single.SingleToFlowable;
import io.reactivex.rxjava3.internal.operators.single.SingleToObservable;
import io.reactivex.rxjava3.internal.operators.single.SingleUnsubscribeOn;
import io.reactivex.rxjava3.internal.operators.single.SingleUsing;
import io.reactivex.rxjava3.internal.operators.single.SingleZipArray;
import io.reactivex.rxjava3.internal.operators.single.SingleZipIterable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.observers.TestObserver;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.schedulers.Timed;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

public abstract class Single<@NonNull T>
implements SingleSource<T> {
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<T> amb(@NonNull @NonNull Iterable<@NonNull ? extends SingleSource<? extends T>> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new SingleAmb(null, sources));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Single<T> ambArray(SingleSource<? extends T> ... sources) {
        Objects.requireNonNull(sources, "sources is null");
        if (sources.length == 0) {
            return Single.error(SingleInternalHelper.emptyThrower());
        }
        if (sources.length == 1) {
            SingleSource<? extends T> source = sources[0];
            return Single.wrap(source);
        }
        return RxJavaPlugins.onAssembly(new SingleAmb<T>(sources, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public static <T> Flowable<T> concat(@NonNull @NonNull Iterable<@NonNull ? extends SingleSource<? extends T>> sources) {
        return Flowable.fromIterable(sources).concatMapSingleDelayError(Functions.identity(), false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Observable<T> concat(@NonNull ObservableSource<? extends SingleSource<? extends T>> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new ObservableConcatMapSingle(sources, Functions.identity(), ErrorMode.IMMEDIATE, 2));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concat(@NonNull @NonNull Publisher<@NonNull ? extends SingleSource<? extends T>> sources) {
        return Single.concat(sources, 2);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concat(@NonNull @NonNull Publisher<@NonNull ? extends SingleSource<? extends T>> sources, int prefetch) {
        Objects.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableConcatMapSinglePublisher(sources, Functions.identity(), ErrorMode.IMMEDIATE, prefetch));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concat(@NonNull SingleSource<? extends T> source1, @NonNull SingleSource<? extends T> source2) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        return Flowable.fromArray(source1, source2).concatMapSingleDelayError(Functions.identity(), false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concat(@NonNull SingleSource<? extends T> source1, @NonNull SingleSource<? extends T> source2, @NonNull SingleSource<? extends T> source3) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        return Flowable.fromArray(source1, source2, source3).concatMapSingleDelayError(Functions.identity(), false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concat(@NonNull SingleSource<? extends T> source1, @NonNull SingleSource<? extends T> source2, @NonNull SingleSource<? extends T> source3, @NonNull SingleSource<? extends T> source4) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        return Flowable.fromArray(source1, source2, source3, source4).concatMapSingleDelayError(Functions.identity(), false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Flowable<T> concatArray(SingleSource<? extends T> ... sources) {
        return Flowable.fromArray(sources).concatMapSingleDelayError(Functions.identity(), false);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Flowable<T> concatArrayDelayError(SingleSource<? extends T> ... sources) {
        return Flowable.fromArray(sources).concatMapSingleDelayError(Functions.identity(), true);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Flowable<T> concatArrayEager(SingleSource<? extends T> ... sources) {
        return Flowable.fromArray(sources).concatMapEager(SingleInternalHelper.toFlowable());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Flowable<T> concatArrayEagerDelayError(SingleSource<? extends T> ... sources) {
        return Flowable.fromArray(sources).concatMapEagerDelayError(SingleInternalHelper.toFlowable(), true);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concatDelayError(@NonNull @NonNull Iterable<@NonNull ? extends SingleSource<? extends T>> sources) {
        return Flowable.fromIterable(sources).concatMapSingleDelayError(Functions.identity());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concatDelayError(@NonNull @NonNull Publisher<@NonNull ? extends SingleSource<? extends T>> sources) {
        return Flowable.fromPublisher(sources).concatMapSingleDelayError(Functions.identity());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concatDelayError(@NonNull @NonNull Publisher<@NonNull ? extends SingleSource<? extends T>> sources, int prefetch) {
        return Flowable.fromPublisher(sources).concatMapSingleDelayError(Functions.identity(), true, prefetch);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concatEager(@NonNull @NonNull Iterable<@NonNull ? extends SingleSource<? extends T>> sources) {
        return Flowable.fromIterable(sources).concatMapEagerDelayError(SingleInternalHelper.toFlowable(), false);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concatEager(@NonNull @NonNull Iterable<@NonNull ? extends SingleSource<? extends T>> sources, int maxConcurrency) {
        return Flowable.fromIterable(sources).concatMapEagerDelayError(SingleInternalHelper.toFlowable(), false, maxConcurrency, 1);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concatEager(@NonNull @NonNull Publisher<@NonNull ? extends SingleSource<? extends T>> sources) {
        return Flowable.fromPublisher(sources).concatMapEager(SingleInternalHelper.toFlowable());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concatEager(@NonNull @NonNull Publisher<@NonNull ? extends SingleSource<? extends T>> sources, int maxConcurrency) {
        return Flowable.fromPublisher(sources).concatMapEager(SingleInternalHelper.toFlowable(), maxConcurrency, 1);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concatEagerDelayError(@NonNull @NonNull Iterable<@NonNull ? extends SingleSource<? extends T>> sources) {
        return Flowable.fromIterable(sources).concatMapEagerDelayError(SingleInternalHelper.toFlowable(), true);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concatEagerDelayError(@NonNull @NonNull Iterable<@NonNull ? extends SingleSource<? extends T>> sources, int maxConcurrency) {
        return Flowable.fromIterable(sources).concatMapEagerDelayError(SingleInternalHelper.toFlowable(), true, maxConcurrency, 1);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concatEagerDelayError(@NonNull @NonNull Publisher<@NonNull ? extends SingleSource<? extends T>> sources) {
        return Flowable.fromPublisher(sources).concatMapEagerDelayError(SingleInternalHelper.toFlowable(), true);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> concatEagerDelayError(@NonNull @NonNull Publisher<@NonNull ? extends SingleSource<? extends T>> sources, int maxConcurrency) {
        return Flowable.fromPublisher(sources).concatMapEagerDelayError(SingleInternalHelper.toFlowable(), true, maxConcurrency, 1);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<T> create(@NonNull SingleOnSubscribe<T> source) {
        Objects.requireNonNull(source, "source is null");
        return RxJavaPlugins.onAssembly(new SingleCreate<T>(source));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<T> defer(@NonNull @NonNull Supplier<? extends @NonNull SingleSource<? extends T>> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return RxJavaPlugins.onAssembly(new SingleDefer(supplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<T> error(@NonNull @NonNull Supplier<? extends @NonNull Throwable> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return RxJavaPlugins.onAssembly(new SingleError(supplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<T> error(@NonNull Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable is null");
        return Single.error(Functions.justSupplier(throwable));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<T> fromCallable(@NonNull Callable<? extends T> callable) {
        Objects.requireNonNull(callable, "callable is null");
        return RxJavaPlugins.onAssembly(new SingleFromCallable<T>(callable));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<T> fromFuture(@NonNull Future<? extends T> future) {
        return Single.toSingle(Flowable.fromFuture(future));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<T> fromFuture(@NonNull Future<? extends T> future, long timeout, @NonNull TimeUnit unit) {
        return Single.toSingle(Flowable.fromFuture(future, timeout, unit));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<T> fromMaybe(@NonNull MaybeSource<T> maybe) {
        Objects.requireNonNull(maybe, "maybe is null");
        return RxJavaPlugins.onAssembly(new MaybeToSingle<Object>(maybe, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<T> fromMaybe(@NonNull MaybeSource<T> maybe, @NonNull T defaultItem) {
        Objects.requireNonNull(maybe, "maybe is null");
        Objects.requireNonNull(defaultItem, "defaultItem is null");
        return RxJavaPlugins.onAssembly(new MaybeToSingle<T>(maybe, defaultItem));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<T> fromPublisher(@NonNull Publisher<? extends T> publisher) {
        Objects.requireNonNull(publisher, "publisher is null");
        return RxJavaPlugins.onAssembly(new SingleFromPublisher<T>(publisher));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<T> fromObservable(@NonNull ObservableSource<? extends T> observable2) {
        Objects.requireNonNull(observable2, "observable is null");
        return RxJavaPlugins.onAssembly(new ObservableSingleSingle<Object>(observable2, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<T> fromSupplier(@NonNull Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return RxJavaPlugins.onAssembly(new SingleFromSupplier<T>(supplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<T> just(T item) {
        Objects.requireNonNull(item, "item is null");
        return RxJavaPlugins.onAssembly(new SingleJust<T>(item));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> merge(@NonNull @NonNull Iterable<@NonNull ? extends SingleSource<? extends T>> sources) {
        return Flowable.fromIterable(sources).flatMapSingle(Functions.identity());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> merge(@NonNull @NonNull Publisher<@NonNull ? extends SingleSource<? extends T>> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new FlowableFlatMapSinglePublisher(sources, Functions.identity(), false, Integer.MAX_VALUE));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<T> merge(@NonNull SingleSource<? extends SingleSource<? extends T>> source) {
        Objects.requireNonNull(source, "source is null");
        return RxJavaPlugins.onAssembly(new SingleFlatMap(source, Functions.identity()));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> merge(@NonNull SingleSource<? extends T> source1, @NonNull SingleSource<? extends T> source2) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        return Flowable.fromArray(source1, source2).flatMapSingle(Functions.identity(), false, Integer.MAX_VALUE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> merge(@NonNull SingleSource<? extends T> source1, @NonNull SingleSource<? extends T> source2, @NonNull SingleSource<? extends T> source3) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        return Flowable.fromArray(source1, source2, source3).flatMapSingle(Functions.identity(), false, Integer.MAX_VALUE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> merge(@NonNull SingleSource<? extends T> source1, @NonNull SingleSource<? extends T> source2, @NonNull SingleSource<? extends T> source3, @NonNull SingleSource<? extends T> source4) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        return Flowable.fromArray(source1, source2, source3, source4).flatMapSingle(Functions.identity(), false, Integer.MAX_VALUE);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Flowable<T> mergeArray(SingleSource<? extends T> ... sources) {
        return Flowable.fromArray(sources).flatMapSingle(Functions.identity(), false, Math.max(1, sources.length));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T> Flowable<T> mergeArrayDelayError(SingleSource<? extends T> ... sources) {
        return Flowable.fromArray(sources).flatMapSingle(Functions.identity(), true, Math.max(1, sources.length));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> mergeDelayError(@NonNull @NonNull Iterable<@NonNull ? extends SingleSource<? extends T>> sources) {
        return Flowable.fromIterable(sources).flatMapSingle(Functions.identity(), true, Integer.MAX_VALUE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> mergeDelayError(@NonNull @NonNull Publisher<@NonNull ? extends SingleSource<? extends T>> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new FlowableFlatMapSinglePublisher(sources, Functions.identity(), true, Integer.MAX_VALUE));
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> mergeDelayError(@NonNull SingleSource<? extends T> source1, @NonNull SingleSource<? extends T> source2) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        return Flowable.fromArray(source1, source2).flatMapSingle(Functions.identity(), true, Integer.MAX_VALUE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> mergeDelayError(@NonNull SingleSource<? extends T> source1, @NonNull SingleSource<? extends T> source2, @NonNull SingleSource<? extends T> source3) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        return Flowable.fromArray(source1, source2, source3).flatMapSingle(Functions.identity(), true, Integer.MAX_VALUE);
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> mergeDelayError(@NonNull SingleSource<? extends T> source1, @NonNull SingleSource<? extends T> source2, @NonNull SingleSource<? extends T> source3, @NonNull SingleSource<? extends T> source4) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        return Flowable.fromArray(source1, source2, source3, source4).flatMapSingle(Functions.identity(), true, Integer.MAX_VALUE);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<T> never() {
        return RxJavaPlugins.onAssembly(SingleNever.INSTANCE);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public static Single<Long> timer(long delay, @NonNull TimeUnit unit) {
        return Single.timer(delay, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public static Single<Long> timer(long delay, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new SingleTimer(delay, unit, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<Boolean> sequenceEqual(@NonNull SingleSource<? extends T> source1, @NonNull SingleSource<? extends T> source2) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        return RxJavaPlugins.onAssembly(new SingleEquals<T>(source1, source2));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> switchOnNext(@NonNull @NonNull Publisher<@NonNull ? extends SingleSource<? extends T>> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new FlowableSwitchMapSinglePublisher(sources, Functions.identity(), false));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Flowable<T> switchOnNextDelayError(@NonNull @NonNull Publisher<@NonNull ? extends SingleSource<? extends T>> sources) {
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new FlowableSwitchMapSinglePublisher(sources, Functions.identity(), true));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<T> unsafeCreate(@NonNull SingleSource<T> onSubscribe) {
        Objects.requireNonNull(onSubscribe, "onSubscribe is null");
        if (onSubscribe instanceof Single) {
            throw new IllegalArgumentException("unsafeCreate(Single) should be upgraded");
        }
        return RxJavaPlugins.onAssembly(new SingleFromUnsafeSource<T>(onSubscribe));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, U> Single<T> using(@NonNull Supplier<U> resourceSupplier, @NonNull Function<? super U, ? extends SingleSource<? extends T>> sourceSupplier, @NonNull Consumer<? super U> resourceCleanup) {
        return Single.using(resourceSupplier, sourceSupplier, resourceCleanup, true);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, U> Single<T> using(@NonNull Supplier<U> resourceSupplier, @NonNull Function<? super U, ? extends SingleSource<? extends T>> sourceSupplier, @NonNull Consumer<? super U> resourceCleanup, boolean eager) {
        Objects.requireNonNull(resourceSupplier, "resourceSupplier is null");
        Objects.requireNonNull(sourceSupplier, "sourceSupplier is null");
        Objects.requireNonNull(resourceCleanup, "resourceCleanup is null");
        return RxJavaPlugins.onAssembly(new SingleUsing(resourceSupplier, sourceSupplier, resourceCleanup, eager));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> Single<T> wrap(@NonNull SingleSource<T> source) {
        Objects.requireNonNull(source, "source is null");
        if (source instanceof Single) {
            return RxJavaPlugins.onAssembly((Single)source);
        }
        return RxJavaPlugins.onAssembly(new SingleFromUnsafeSource<T>(source));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T, R> Single<R> zip(@NonNull @NonNull Iterable<@NonNull ? extends SingleSource<? extends T>> sources, @NonNull Function<? super Object[], ? extends R> zipper) {
        Objects.requireNonNull(zipper, "zipper is null");
        Objects.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new SingleZipIterable(sources, zipper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, R> Single<R> zip(@NonNull SingleSource<? extends T1> source1, @NonNull SingleSource<? extends T2> source2, @NonNull BiFunction<? super T1, ? super T2, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Single.zipArray(Functions.toFunction(zipper), source1, source2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, R> Single<R> zip(@NonNull SingleSource<? extends T1> source1, @NonNull SingleSource<? extends T2> source2, @NonNull SingleSource<? extends T3> source3, @NonNull Function3<? super T1, ? super T2, ? super T3, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Single.zipArray(Functions.toFunction(zipper), source1, source2, source3);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, R> Single<R> zip(@NonNull SingleSource<? extends T1> source1, @NonNull SingleSource<? extends T2> source2, @NonNull SingleSource<? extends T3> source3, @NonNull SingleSource<? extends T4> source4, @NonNull Function4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Single.zipArray(Functions.toFunction(zipper), source1, source2, source3, source4);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, R> Single<R> zip(@NonNull SingleSource<? extends T1> source1, @NonNull SingleSource<? extends T2> source2, @NonNull SingleSource<? extends T3> source3, @NonNull SingleSource<? extends T4> source4, @NonNull SingleSource<? extends T5> source5, @NonNull Function5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Single.zipArray(Functions.toFunction(zipper), source1, source2, source3, source4, source5);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, R> Single<R> zip(@NonNull SingleSource<? extends T1> source1, @NonNull SingleSource<? extends T2> source2, @NonNull SingleSource<? extends T3> source3, @NonNull SingleSource<? extends T4> source4, @NonNull SingleSource<? extends T5> source5, @NonNull SingleSource<? extends T6> source6, @NonNull Function6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Single.zipArray(Functions.toFunction(zipper), source1, source2, source3, source4, source5, source6);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, T7, R> Single<R> zip(@NonNull SingleSource<? extends T1> source1, @NonNull SingleSource<? extends T2> source2, @NonNull SingleSource<? extends T3> source3, @NonNull SingleSource<? extends T4> source4, @NonNull SingleSource<? extends T5> source5, @NonNull SingleSource<? extends T6> source6, @NonNull SingleSource<? extends T7> source7, @NonNull Function7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(source7, "source7 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Single.zipArray(Functions.toFunction(zipper), source1, source2, source3, source4, source5, source6, source7);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Single<R> zip(@NonNull SingleSource<? extends T1> source1, @NonNull SingleSource<? extends T2> source2, @NonNull SingleSource<? extends T3> source3, @NonNull SingleSource<? extends T4> source4, @NonNull SingleSource<? extends T5> source5, @NonNull SingleSource<? extends T6> source6, @NonNull SingleSource<? extends T7> source7, @NonNull SingleSource<? extends T8> source8, @NonNull Function8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(source7, "source7 is null");
        Objects.requireNonNull(source8, "source8 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Single.zipArray(Functions.toFunction(zipper), source1, source2, source3, source4, source5, source6, source7, source8);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Single<R> zip(@NonNull SingleSource<? extends T1> source1, @NonNull SingleSource<? extends T2> source2, @NonNull SingleSource<? extends T3> source3, @NonNull SingleSource<? extends T4> source4, @NonNull SingleSource<? extends T5> source5, @NonNull SingleSource<? extends T6> source6, @NonNull SingleSource<? extends T7> source7, @NonNull SingleSource<? extends T8> source8, @NonNull SingleSource<? extends T9> source9, @NonNull Function9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> zipper) {
        Objects.requireNonNull(source1, "source1 is null");
        Objects.requireNonNull(source2, "source2 is null");
        Objects.requireNonNull(source3, "source3 is null");
        Objects.requireNonNull(source4, "source4 is null");
        Objects.requireNonNull(source5, "source5 is null");
        Objects.requireNonNull(source6, "source6 is null");
        Objects.requireNonNull(source7, "source7 is null");
        Objects.requireNonNull(source8, "source8 is null");
        Objects.requireNonNull(source9, "source9 is null");
        Objects.requireNonNull(zipper, "zipper is null");
        return Single.zipArray(Functions.toFunction(zipper), source1, source2, source3, source4, source5, source6, source7, source8, source9);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @SafeVarargs
    @NonNull
    public static <T, R> Single<R> zipArray(@NonNull Function<? super Object[], ? extends R> zipper, SingleSource<? extends T> ... sources) {
        Objects.requireNonNull(zipper, "zipper is null");
        Objects.requireNonNull(sources, "sources is null");
        if (sources.length == 0) {
            return Single.error(new NoSuchElementException());
        }
        return RxJavaPlugins.onAssembly(new SingleZipArray<T, R>(sources, zipper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> ambWith(@NonNull SingleSource<? extends T> other) {
        Objects.requireNonNull(other, "other is null");
        return Single.ambArray(this, other);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> hide() {
        return RxJavaPlugins.onAssembly(new SingleHide(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Single<R> compose(@NonNull SingleTransformer<? super T, ? extends R> transformer) {
        return Single.wrap(Objects.requireNonNull(transformer, "transformer is null").apply(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> cache() {
        return RxJavaPlugins.onAssembly(new SingleCache(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Single<U> cast(@NonNull Class<? extends U> clazz) {
        Objects.requireNonNull(clazz, "clazz is null");
        return this.map(Functions.castFunction(clazz));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Single<R> concatMap(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new SingleFlatMap(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable concatMapCompletable(@NonNull Function<? super T, ? extends CompletableSource> mapper) {
        return this.flatMapCompletable(mapper);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Maybe<R> concatMapMaybe(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper) {
        return this.flatMapMaybe(mapper);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> concatWith(@NonNull SingleSource<? extends T> other) {
        return Single.concat(this, other);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Single<T> delay(long time, @NonNull TimeUnit unit) {
        return this.delay(time, unit, Schedulers.computation(), false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Single<T> delay(long time, @NonNull TimeUnit unit, boolean delayError) {
        return this.delay(time, unit, Schedulers.computation(), delayError);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Single<T> delay(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.delay(time, unit, scheduler, false);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Single<T> delay(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, boolean delayError) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new SingleDelay(this, time, unit, scheduler, delayError));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> delaySubscription(@NonNull CompletableSource subscriptionIndicator) {
        Objects.requireNonNull(subscriptionIndicator, "subscriptionIndicator is null");
        return RxJavaPlugins.onAssembly(new SingleDelayWithCompletable(this, subscriptionIndicator));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Single<T> delaySubscription(@NonNull SingleSource<U> subscriptionIndicator) {
        Objects.requireNonNull(subscriptionIndicator, "subscriptionIndicator is null");
        return RxJavaPlugins.onAssembly(new SingleDelayWithSingle(this, subscriptionIndicator));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Single<T> delaySubscription(@NonNull ObservableSource<U> subscriptionIndicator) {
        Objects.requireNonNull(subscriptionIndicator, "subscriptionIndicator is null");
        return RxJavaPlugins.onAssembly(new SingleDelayWithObservable(this, subscriptionIndicator));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Single<T> delaySubscription(@NonNull Publisher<U> subscriptionIndicator) {
        Objects.requireNonNull(subscriptionIndicator, "subscriptionIndicator is null");
        return RxJavaPlugins.onAssembly(new SingleDelayWithPublisher(this, subscriptionIndicator));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Single<T> delaySubscription(long time, @NonNull TimeUnit unit) {
        return this.delaySubscription(time, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Single<T> delaySubscription(long time, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.delaySubscription(Observable.timer(time, unit, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Maybe<R> dematerialize(@NonNull @NonNull Function<? super T, @NonNull Notification<R>> selector) {
        Objects.requireNonNull(selector, "selector is null");
        return RxJavaPlugins.onAssembly(new SingleDematerialize<T, R>(this, selector));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> doAfterSuccess(@NonNull Consumer<? super T> onAfterSuccess) {
        Objects.requireNonNull(onAfterSuccess, "onAfterSuccess is null");
        return RxJavaPlugins.onAssembly(new SingleDoAfterSuccess<T>(this, onAfterSuccess));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> doAfterTerminate(@NonNull Action onAfterTerminate) {
        Objects.requireNonNull(onAfterTerminate, "onAfterTerminate is null");
        return RxJavaPlugins.onAssembly(new SingleDoAfterTerminate(this, onAfterTerminate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> doFinally(@NonNull Action onFinally) {
        Objects.requireNonNull(onFinally, "onFinally is null");
        return RxJavaPlugins.onAssembly(new SingleDoFinally(this, onFinally));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> doOnLifecycle(@NonNull Consumer<? super Disposable> onSubscribe, @NonNull Action onDispose) {
        Objects.requireNonNull(onSubscribe, "onSubscribe is null");
        Objects.requireNonNull(onDispose, "onDispose is null");
        return RxJavaPlugins.onAssembly(new SingleDoOnLifecycle(this, onSubscribe, onDispose));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> doOnSubscribe(@NonNull Consumer<? super Disposable> onSubscribe) {
        Objects.requireNonNull(onSubscribe, "onSubscribe is null");
        return RxJavaPlugins.onAssembly(new SingleDoOnSubscribe(this, onSubscribe));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> doOnTerminate(@NonNull Action onTerminate) {
        Objects.requireNonNull(onTerminate, "onTerminate is null");
        return RxJavaPlugins.onAssembly(new SingleDoOnTerminate(this, onTerminate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> doOnSuccess(@NonNull Consumer<? super T> onSuccess) {
        Objects.requireNonNull(onSuccess, "onSuccess is null");
        return RxJavaPlugins.onAssembly(new SingleDoOnSuccess<T>(this, onSuccess));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> doOnEvent(@NonNull BiConsumer<@Nullable ? super T, @Nullable ? super Throwable> onEvent) {
        Objects.requireNonNull(onEvent, "onEvent is null");
        return RxJavaPlugins.onAssembly(new SingleDoOnEvent<T>(this, onEvent));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> doOnError(@NonNull Consumer<? super Throwable> onError2) {
        Objects.requireNonNull(onError2, "onError is null");
        return RxJavaPlugins.onAssembly(new SingleDoOnError(this, onError2));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> doOnDispose(@NonNull Action onDispose) {
        Objects.requireNonNull(onDispose, "onDispose is null");
        return RxJavaPlugins.onAssembly(new SingleDoOnDispose(this, onDispose));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Maybe<T> filter(@NonNull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new MaybeFilterSingle<T>(this, predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Single<R> flatMap(@NonNull Function<? super T, ? extends SingleSource<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new SingleFlatMap(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Single<R> flatMap(@NonNull Function<? super T, ? extends SingleSource<? extends U>> mapper, @NonNull BiFunction<? super T, ? super U, ? extends R> combiner) {
        Objects.requireNonNull(mapper, "mapper is null");
        Objects.requireNonNull(combiner, "combiner is null");
        return RxJavaPlugins.onAssembly(new SingleFlatMapBiSelector<T, U, R>(this, mapper, combiner));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Single<R> flatMap(@NonNull Function<? super T, ? extends SingleSource<? extends R>> onSuccessMapper, @NonNull Function<? super Throwable, ? extends SingleSource<? extends R>> onErrorMapper) {
        Objects.requireNonNull(onSuccessMapper, "onSuccessMapper is null");
        Objects.requireNonNull(onErrorMapper, "onErrorMapper is null");
        return RxJavaPlugins.onAssembly(new SingleFlatMapNotification(this, onSuccessMapper, onErrorMapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Maybe<R> flatMapMaybe(@NonNull Function<? super T, ? extends MaybeSource<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new SingleFlatMapMaybe(this, mapper));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Flowable<R> flatMapPublisher(@NonNull @NonNull Function<? super T, @NonNull ? extends Publisher<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new SingleFlatMapPublisher(this, mapper));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Flowable<U> flattenAsFlowable(@NonNull @NonNull Function<? super T, @NonNull ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new SingleFlatMapIterableFlowable(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Observable<U> flattenAsObservable(@NonNull @NonNull Function<@NonNull ? super T, @NonNull ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new SingleFlatMapIterableObservable(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> flatMapObservable(@NonNull Function<? super T, ? extends ObservableSource<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new SingleFlatMapObservable(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable flatMapCompletable(@NonNull Function<? super T, ? extends CompletableSource> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new SingleFlatMapCompletable<T>(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final T blockingGet() {
        BlockingMultiObserver observer = new BlockingMultiObserver();
        this.subscribe(observer);
        return observer.blockingGet();
    }

    @SchedulerSupport(value="none")
    public final void blockingSubscribe() {
        this.blockingSubscribe(Functions.emptyConsumer(), Functions.ERROR_CONSUMER);
    }

    @SchedulerSupport(value="none")
    public final void blockingSubscribe(@NonNull Consumer<? super T> onSuccess) {
        this.blockingSubscribe(onSuccess, Functions.ERROR_CONSUMER);
    }

    @SchedulerSupport(value="none")
    public final void blockingSubscribe(@NonNull Consumer<? super T> onSuccess, @NonNull Consumer<? super Throwable> onError2) {
        Objects.requireNonNull(onSuccess, "onSuccess is null");
        Objects.requireNonNull(onError2, "onError is null");
        BlockingMultiObserver<? super T> observer = new BlockingMultiObserver<T>();
        this.subscribe(observer);
        observer.blockingConsume(onSuccess, onError2, Functions.EMPTY_ACTION);
    }

    @SchedulerSupport(value="none")
    public final void blockingSubscribe(@NonNull SingleObserver<? super T> observer) {
        Objects.requireNonNull(observer, "observer is null");
        BlockingDisposableMultiObserver<T> blockingObserver = new BlockingDisposableMultiObserver<T>();
        observer.onSubscribe(blockingObserver);
        this.subscribe(blockingObserver);
        blockingObserver.blockingConsume(observer);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Single<R> lift(@NonNull SingleOperator<? extends R, ? super T> lift) {
        Objects.requireNonNull(lift, "lift is null");
        return RxJavaPlugins.onAssembly(new SingleLift<T, R>(this, lift));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Single<R> map(@NonNull Function<? super T, ? extends R> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new SingleMap<T, R>(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<Notification<T>> materialize() {
        return RxJavaPlugins.onAssembly(new SingleMaterialize(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<Boolean> contains(@NonNull Object item) {
        return this.contains(item, ObjectHelper.equalsPredicate());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<Boolean> contains(@NonNull Object item, @NonNull BiPredicate<Object, Object> comparer) {
        Objects.requireNonNull(item, "item is null");
        Objects.requireNonNull(comparer, "comparer is null");
        return RxJavaPlugins.onAssembly(new SingleContains(this, item, comparer));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> mergeWith(@NonNull SingleSource<? extends T> other) {
        return Single.merge(this, other);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U> Maybe<U> ofType(@NonNull Class<U> clazz) {
        Objects.requireNonNull(clazz, "clazz is null");
        return this.filter(Functions.isInstanceOf(clazz)).cast(clazz);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Single<T> observeOn(@NonNull Scheduler scheduler) {
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new SingleObserveOn(this, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> onErrorReturn(@NonNull Function<Throwable, ? extends T> itemSupplier) {
        Objects.requireNonNull(itemSupplier, "itemSupplier is null");
        return RxJavaPlugins.onAssembly(new SingleOnErrorReturn<Object>(this, itemSupplier, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> onErrorReturnItem(@NonNull T item) {
        Objects.requireNonNull(item, "item is null");
        return RxJavaPlugins.onAssembly(new SingleOnErrorReturn<T>(this, null, item));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> onErrorResumeWith(@NonNull SingleSource<? extends T> fallback) {
        Objects.requireNonNull(fallback, "fallback is null");
        return this.onErrorResumeNext(Functions.justFunction(fallback));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Maybe<T> onErrorComplete() {
        return this.onErrorComplete(Functions.alwaysTrue());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Maybe<T> onErrorComplete(@NonNull Predicate<? super Throwable> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new SingleOnErrorComplete(this, predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> onErrorResumeNext(@NonNull Function<? super Throwable, ? extends SingleSource<? extends T>> fallbackSupplier) {
        Objects.requireNonNull(fallbackSupplier, "fallbackSupplier is null");
        return RxJavaPlugins.onAssembly(new SingleResumeNext(this, fallbackSupplier));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> onTerminateDetach() {
        return RxJavaPlugins.onAssembly(new SingleDetach(this));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> repeat() {
        return this.toFlowable().repeat();
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> repeat(long times) {
        return this.toFlowable().repeat(times);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> repeatWhen(@NonNull @NonNull Function<? super Flowable<Object>, @NonNull ? extends Publisher<@NonNull ?>> handler) {
        return this.toFlowable().repeatWhen(handler);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> repeatUntil(@NonNull BooleanSupplier stop2) {
        return this.toFlowable().repeatUntil(stop2);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> retry() {
        return Single.toSingle(this.toFlowable().retry());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> retry(long times) {
        return Single.toSingle(this.toFlowable().retry(times));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> retry(@NonNull BiPredicate<? super Integer, ? super Throwable> predicate) {
        return Single.toSingle(this.toFlowable().retry(predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> retry(long times, @NonNull Predicate<? super Throwable> predicate) {
        return Single.toSingle(this.toFlowable().retry(times, predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> retry(@NonNull Predicate<? super Throwable> predicate) {
        return Single.toSingle(this.toFlowable().retry(predicate));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> retryUntil(@NonNull BooleanSupplier stop2) {
        Objects.requireNonNull(stop2, "stop is null");
        return this.retry(Long.MAX_VALUE, Functions.predicateReverseFor(stop2));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> retryWhen(@NonNull @NonNull Function<? super Flowable<Throwable>, @NonNull ? extends Publisher<@NonNull ?>> handler) {
        return Single.toSingle(this.toFlowable().retryWhen(handler));
    }

    @SchedulerSupport(value="none")
    public final void safeSubscribe(@NonNull SingleObserver<? super T> observer) {
        Objects.requireNonNull(observer, "observer is null");
        this.subscribe(new SafeSingleObserver<T>(observer));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public final Flowable<T> startWith(@NonNull CompletableSource other) {
        Objects.requireNonNull(other, "other is null");
        return Flowable.concat(Completable.wrap(other).toFlowable(), this.toFlowable());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public final Flowable<T> startWith(@NonNull SingleSource<T> other) {
        Objects.requireNonNull(other, "other is null");
        return Flowable.concat(Single.wrap(other).toFlowable(), this.toFlowable());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public final Flowable<T> startWith(@NonNull MaybeSource<T> other) {
        Objects.requireNonNull(other, "other is null");
        return Flowable.concat(Maybe.wrap(other).toFlowable(), this.toFlowable());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> startWith(@NonNull ObservableSource<T> other) {
        Objects.requireNonNull(other, "other is null");
        return Observable.wrap(other).concatWith(this.toObservable());
    }

    @CheckReturnValue
    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> startWith(@NonNull Publisher<T> other) {
        Objects.requireNonNull(other, "other is null");
        return this.toFlowable().startWith(other);
    }

    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable subscribe() {
        return this.subscribe(Functions.emptyConsumer(), Functions.ON_ERROR_MISSING);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable subscribe(@NonNull BiConsumer<@Nullable ? super T, @Nullable ? super Throwable> onCallback) {
        Objects.requireNonNull(onCallback, "onCallback is null");
        BiConsumerSingleObserver<? super T> observer = new BiConsumerSingleObserver<T>(onCallback);
        this.subscribe(observer);
        return observer;
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable subscribe(@NonNull Consumer<? super T> onSuccess) {
        return this.subscribe(onSuccess, Functions.ON_ERROR_MISSING);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable subscribe(@NonNull Consumer<? super T> onSuccess, @NonNull Consumer<? super Throwable> onError2) {
        Objects.requireNonNull(onSuccess, "onSuccess is null");
        Objects.requireNonNull(onError2, "onError is null");
        ConsumerSingleObserver<? super T> observer = new ConsumerSingleObserver<T>(onSuccess, onError2);
        this.subscribe(observer);
        return observer;
    }

    @SchedulerSupport(value="none")
    @NonNull
    public final Disposable subscribe(@NonNull Consumer<? super T> onSuccess, @NonNull Consumer<? super Throwable> onError2, @NonNull DisposableContainer container) {
        Objects.requireNonNull(onSuccess, "onSuccess is null");
        Objects.requireNonNull(onError2, "onError is null");
        Objects.requireNonNull(container, "container is null");
        DisposableAutoReleaseMultiObserver<? super T> observer = new DisposableAutoReleaseMultiObserver<T>(container, onSuccess, onError2, Functions.EMPTY_ACTION);
        container.add(observer);
        this.subscribe(observer);
        return observer;
    }

    @Override
    @SchedulerSupport(value="none")
    public final void subscribe(@NonNull SingleObserver<? super T> observer) {
        Objects.requireNonNull(observer, "observer is null");
        observer = RxJavaPlugins.onSubscribe(this, observer);
        Objects.requireNonNull(observer, "The RxJavaPlugins.onSubscribe hook returned a null SingleObserver. Please check the handler provided to RxJavaPlugins.setOnSingleSubscribe for invalid null returns. Further reading: https://github.com/ReactiveX/RxJava/wiki/Plugins");
        try {
            this.subscribeActual(observer);
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            NullPointerException npe = new NullPointerException("subscribeActual failed");
            npe.initCause(ex);
            throw npe;
        }
    }

    protected abstract void subscribeActual(@NonNull SingleObserver<? super T> var1);

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <E extends SingleObserver<? super T>> E subscribeWith(E observer) {
        this.subscribe(observer);
        return observer;
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Single<T> subscribeOn(@NonNull Scheduler scheduler) {
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new SingleSubscribeOn(this, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Single<Timed<T>> timeInterval() {
        return this.timeInterval(TimeUnit.MILLISECONDS, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Single<Timed<T>> timeInterval(@NonNull Scheduler scheduler) {
        return this.timeInterval(TimeUnit.MILLISECONDS, scheduler);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Single<Timed<T>> timeInterval(@NonNull TimeUnit unit) {
        return this.timeInterval(unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Single<Timed<T>> timeInterval(@NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new SingleTimeInterval(this, unit, scheduler, true));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Single<Timed<T>> timestamp() {
        return this.timestamp(TimeUnit.MILLISECONDS, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Single<Timed<T>> timestamp(@NonNull Scheduler scheduler) {
        return this.timestamp(TimeUnit.MILLISECONDS, scheduler);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Single<Timed<T>> timestamp(@NonNull TimeUnit unit) {
        return this.timestamp(unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Single<Timed<T>> timestamp(@NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new SingleTimeInterval(this, unit, scheduler, false));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Single<T> takeUntil(@NonNull CompletableSource other) {
        Objects.requireNonNull(other, "other is null");
        return this.takeUntil(new CompletableToFlowable(other));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <E> Single<T> takeUntil(@NonNull Publisher<E> other) {
        Objects.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new SingleTakeUntil(this, other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <E> Single<T> takeUntil(@NonNull SingleSource<? extends E> other) {
        Objects.requireNonNull(other, "other is null");
        return this.takeUntil(new SingleToFlowable<E>(other));
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Single<T> timeout(long timeout, @NonNull TimeUnit unit) {
        return this.timeout0(timeout, unit, Schedulers.computation(), null);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Single<T> timeout(long timeout, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        return this.timeout0(timeout, unit, scheduler, null);
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Single<T> timeout(long timeout, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, @NonNull SingleSource<? extends T> fallback) {
        Objects.requireNonNull(fallback, "fallback is null");
        return this.timeout0(timeout, unit, scheduler, fallback);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @NonNull
    public final Single<T> timeout(long timeout, @NonNull TimeUnit unit, @NonNull SingleSource<? extends T> fallback) {
        Objects.requireNonNull(fallback, "fallback is null");
        return this.timeout0(timeout, unit, Schedulers.computation(), fallback);
    }

    private Single<T> timeout0(long timeout, TimeUnit unit, Scheduler scheduler, SingleSource<? extends T> fallback) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new SingleTimeout<T>(this, timeout, unit, scheduler, fallback));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    public final <R> R to(@NonNull SingleConverter<T, ? extends R> converter) {
        return Objects.requireNonNull(converter, "converter is null").apply(this);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Completable ignoreElement() {
        return RxJavaPlugins.onAssembly(new CompletableFromSingle(this));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Flowable<T> toFlowable() {
        if (this instanceof FuseToFlowable) {
            return ((FuseToFlowable)((Object)this)).fuseToFlowable();
        }
        return RxJavaPlugins.onAssembly(new SingleToFlowable(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Future<T> toFuture() {
        return this.subscribeWith(new FutureMultiObserver());
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Maybe<T> toMaybe() {
        if (this instanceof FuseToMaybe) {
            return ((FuseToMaybe)((Object)this)).fuseToMaybe();
        }
        return RxJavaPlugins.onAssembly(new MaybeFromSingle(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final Observable<T> toObservable() {
        if (this instanceof FuseToObservable) {
            return ((FuseToObservable)((Object)this)).fuseToObservable();
        }
        return RxJavaPlugins.onAssembly(new SingleToObservable(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @NonNull
    public final Single<T> unsubscribeOn(@NonNull Scheduler scheduler) {
        Objects.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new SingleUnsubscribeOn(this, scheduler));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <U, R> Single<R> zipWith(@NonNull SingleSource<U> other, @NonNull BiFunction<? super T, ? super U, ? extends R> zipper) {
        return Single.zip(this, other, zipper);
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final TestObserver<T> test() {
        TestObserver to = new TestObserver();
        this.subscribe(to);
        return to;
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final TestObserver<T> test(boolean dispose) {
        TestObserver to = new TestObserver();
        if (dispose) {
            to.dispose();
        }
        this.subscribe(to);
        return to;
    }

    @NonNull
    private static <T> Single<T> toSingle(@NonNull Flowable<T> source) {
        return RxJavaPlugins.onAssembly(new FlowableSingleSingle<Object>(source, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public static <T> @NonNull Single<@NonNull T> fromCompletionStage(@NonNull CompletionStage<T> stage) {
        Objects.requireNonNull(stage, "stage is null");
        return RxJavaPlugins.onAssembly(new SingleFromCompletionStage<T>(stage));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Maybe<R> mapOptional(@NonNull @NonNull Function<? super T, @NonNull Optional<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new SingleMapOptional<T, R>(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final CompletionStage<T> toCompletionStage() {
        return this.subscribeWith(new CompletionStageConsumer<Object>(false, null));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    @NonNull
    public final <R> Flowable<R> flattenStreamAsFlowable(@NonNull @NonNull Function<? super T, @NonNull ? extends Stream<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new SingleFlattenStreamAsFlowable(this, mapper));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @NonNull
    public final <R> Observable<R> flattenStreamAsObservable(@NonNull @NonNull Function<? super T, @NonNull ? extends Stream<? extends R>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new SingleFlattenStreamAsObservable(this, mapper));
    }
}

