/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.observers.BasicFuseableObserver;
import java.util.Objects;
import java.util.Optional;

public final class ObservableMapOptional<T, R>
extends Observable<R> {
    final Observable<T> source;
    final Function<? super T, Optional<? extends R>> mapper;

    public ObservableMapOptional(Observable<T> source, Function<? super T, Optional<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Observer<? super R> observer) {
        this.source.subscribe(new MapOptionalObserver<T, R>(observer, this.mapper));
    }

    static final class MapOptionalObserver<T, R>
    extends BasicFuseableObserver<T, R> {
        final Function<? super T, Optional<? extends R>> mapper;

        MapOptionalObserver(Observer<? super R> downstream, Function<? super T, Optional<? extends R>> mapper) {
            super(downstream);
            this.mapper = mapper;
        }

        @Override
        public void onNext(T t) {
            Optional<R> result2;
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(null);
                return;
            }
            try {
                result2 = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null Optional");
            }
            catch (Throwable ex) {
                this.fail(ex);
                return;
            }
            if (result2.isPresent()) {
                this.downstream.onNext(result2.get());
            }
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        public R poll() throws Throwable {
            Object item;
            Optional<R> result2;
            do {
                if ((item = this.qd.poll()) != null) continue;
                return null;
            } while (!(result2 = Objects.requireNonNull(this.mapper.apply(item), "The mapper returned a null Optional")).isPresent());
            return result2.get();
        }
    }
}

