/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.disposables.DisposableContainer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.observers.AbstractDisposableAutoRelease;

public final class DisposableAutoReleaseObserver<T>
extends AbstractDisposableAutoRelease
implements Observer<T> {
    private static final long serialVersionUID = 8924480688481408726L;
    final Consumer<? super T> onNext;

    public DisposableAutoReleaseObserver(DisposableContainer composite, Consumer<? super T> onNext, Consumer<? super Throwable> onError2, Action onComplete) {
        super(composite, onError2, onComplete);
        this.onNext = onNext;
    }

    @Override
    public void onNext(T t) {
        if (this.get() != DisposableHelper.DISPOSED) {
            try {
                this.onNext.accept(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                ((Disposable)this.get()).dispose();
                this.onError(e);
            }
        }
    }
}

