/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.observers.QueueDrainSubscriberPad2;
import io.reactivex.rxjava3.internal.util.ObservableQueueDrain;
import io.reactivex.rxjava3.internal.util.QueueDrainHelper;
import io.reactivex.rxjava3.operators.SimplePlainQueue;

public abstract class QueueDrainObserver<T, U, V>
extends QueueDrainSubscriberPad2
implements Observer<T>,
ObservableQueueDrain<U, V> {
    protected final Observer<? super V> downstream;
    protected final SimplePlainQueue<U> queue;
    protected volatile boolean cancelled;
    protected volatile boolean done;
    protected Throwable error;

    public QueueDrainObserver(Observer<? super V> actual2, SimplePlainQueue<U> queue) {
        this.downstream = actual2;
        this.queue = queue;
    }

    @Override
    public final boolean cancelled() {
        return this.cancelled;
    }

    @Override
    public final boolean done() {
        return this.done;
    }

    @Override
    public final boolean enter() {
        return this.wip.getAndIncrement() == 0;
    }

    protected final void fastPathEmit(U value, boolean delayError, Disposable dispose) {
        Observer<? super V> observer = this.downstream;
        SimplePlainQueue<U> q = this.queue;
        if (this.wip.get() == 0 && this.wip.compareAndSet(0, 1)) {
            this.accept(observer, value);
            if (this.leave(-1) == 0) {
                return;
            }
        } else {
            q.offer(value);
            if (!this.enter()) {
                return;
            }
        }
        QueueDrainHelper.drainLoop(q, observer, delayError, dispose, this);
    }

    protected final void fastPathOrderedEmit(U value, boolean delayError, Disposable disposable2) {
        Observer<? super V> observer = this.downstream;
        SimplePlainQueue<U> q = this.queue;
        if (this.wip.get() == 0 && this.wip.compareAndSet(0, 1)) {
            if (q.isEmpty()) {
                this.accept(observer, value);
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                q.offer(value);
            }
        } else {
            q.offer(value);
            if (!this.enter()) {
                return;
            }
        }
        QueueDrainHelper.drainLoop(q, observer, delayError, disposable2, this);
    }

    @Override
    public final Throwable error() {
        return this.error;
    }

    @Override
    public final int leave(int m) {
        return this.wip.addAndGet(m);
    }

    @Override
    public void accept(Observer<? super V> a, U v) {
    }
}

