/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.completable;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class CompletableCache
extends Completable
implements CompletableObserver {
    static final InnerCompletableCache[] EMPTY = new InnerCompletableCache[0];
    static final InnerCompletableCache[] TERMINATED = new InnerCompletableCache[0];
    final CompletableSource source;
    final AtomicReference<InnerCompletableCache[]> observers;
    final AtomicBoolean once;
    Throwable error;

    public CompletableCache(CompletableSource source) {
        this.source = source;
        this.observers = new AtomicReference<InnerCompletableCache[]>(EMPTY);
        this.once = new AtomicBoolean();
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        InnerCompletableCache inner2 = new InnerCompletableCache(observer);
        observer.onSubscribe(inner2);
        if (this.add(inner2)) {
            if (inner2.isDisposed()) {
                this.remove(inner2);
            }
            if (this.once.compareAndSet(false, true)) {
                this.source.subscribe(this);
            }
        } else {
            Throwable ex = this.error;
            if (ex != null) {
                observer.onError(ex);
            } else {
                observer.onComplete();
            }
        }
    }

    @Override
    public void onSubscribe(Disposable d) {
    }

    @Override
    public void onError(Throwable e) {
        this.error = e;
        for (InnerCompletableCache inner2 : this.observers.getAndSet(TERMINATED)) {
            if (inner2.get()) continue;
            inner2.downstream.onError(e);
        }
    }

    @Override
    public void onComplete() {
        for (InnerCompletableCache inner2 : this.observers.getAndSet(TERMINATED)) {
            if (inner2.get()) continue;
            inner2.downstream.onComplete();
        }
    }

    boolean add(InnerCompletableCache inner2) {
        InnerCompletableCache[] b;
        InnerCompletableCache[] a;
        do {
            if ((a = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new InnerCompletableCache[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = inner2;
        } while (!this.observers.compareAndSet(a, b));
        return true;
    }

    void remove(InnerCompletableCache inner2) {
        InnerCompletableCache[] b;
        InnerCompletableCache[] a;
        do {
            int n;
            if ((n = (a = this.observers.get()).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != inner2) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY;
                continue;
            }
            b = new InnerCompletableCache[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!this.observers.compareAndSet(a, b));
    }

    final class InnerCompletableCache
    extends AtomicBoolean
    implements Disposable {
        private static final long serialVersionUID = 8943152917179642732L;
        final CompletableObserver downstream;

        InnerCompletableCache(CompletableObserver downstream) {
            this.downstream = downstream;
        }

        @Override
        public boolean isDisposed() {
            return this.get();
        }

        @Override
        public void dispose() {
            if (this.compareAndSet(false, true)) {
                CompletableCache.this.remove(this);
            }
        }
    }
}

