/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.completable;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.concurrent.atomic.AtomicReference;

public final class CompletableObserveOn
extends Completable {
    final CompletableSource source;
    final Scheduler scheduler;

    public CompletableObserveOn(CompletableSource source, Scheduler scheduler) {
        this.source = source;
        this.scheduler = scheduler;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        this.source.subscribe(new ObserveOnCompletableObserver(observer, this.scheduler));
    }

    static final class ObserveOnCompletableObserver
    extends AtomicReference<Disposable>
    implements CompletableObserver,
    Disposable,
    Runnable {
        private static final long serialVersionUID = 8571289934935992137L;
        final CompletableObserver downstream;
        final Scheduler scheduler;
        Throwable error;

        ObserveOnCompletableObserver(CompletableObserver actual2, Scheduler scheduler) {
            this.downstream = actual2;
            this.scheduler = scheduler;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.setOnce(this, d)) {
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onError(Throwable e) {
            this.error = e;
            DisposableHelper.replace(this, this.scheduler.scheduleDirect(this));
        }

        @Override
        public void onComplete() {
            DisposableHelper.replace(this, this.scheduler.scheduleDirect(this));
        }

        @Override
        public void run() {
            Throwable ex = this.error;
            if (ex != null) {
                this.error = null;
                this.downstream.onError(ex);
            } else {
                this.downstream.onComplete();
            }
        }
    }
}

