/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscribers.InnerQueuedSubscriber;
import io.reactivex.rxjava3.internal.subscribers.InnerQueuedSubscriberSupport;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableConcatMapEager<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final int maxConcurrency;
    final int prefetch;
    final ErrorMode errorMode;

    public FlowableConcatMapEager(Flowable<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int prefetch, ErrorMode errorMode) {
        super(source);
        this.mapper = mapper;
        this.maxConcurrency = maxConcurrency;
        this.prefetch = prefetch;
        this.errorMode = errorMode;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new ConcatMapEagerDelayErrorSubscriber<T, R>(s, this.mapper, this.maxConcurrency, this.prefetch, this.errorMode));
    }

    static final class ConcatMapEagerDelayErrorSubscriber<T, R>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    InnerQueuedSubscriberSupport<R> {
        private static final long serialVersionUID = -4255299542215038287L;
        final Subscriber<? super R> downstream;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final int maxConcurrency;
        final int prefetch;
        final ErrorMode errorMode;
        final AtomicThrowable errors;
        final AtomicLong requested;
        final SpscLinkedArrayQueue<InnerQueuedSubscriber<R>> subscribers;
        Subscription upstream;
        volatile boolean cancelled;
        volatile boolean done;
        volatile InnerQueuedSubscriber<R> current;

        ConcatMapEagerDelayErrorSubscriber(Subscriber<? super R> actual2, Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int prefetch, ErrorMode errorMode) {
            this.downstream = actual2;
            this.mapper = mapper;
            this.maxConcurrency = maxConcurrency;
            this.prefetch = prefetch;
            this.errorMode = errorMode;
            this.subscribers = new SpscLinkedArrayQueue(Math.min(prefetch, maxConcurrency));
            this.errors = new AtomicThrowable();
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
                s.request(this.maxConcurrency == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)this.maxConcurrency);
            }
        }

        @Override
        public void onNext(T t) {
            Publisher<R> p;
            try {
                p = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null Publisher");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.upstream.cancel();
                this.onError(ex);
                return;
            }
            InnerQueuedSubscriber inner2 = new InnerQueuedSubscriber(this, this.prefetch);
            if (this.cancelled) {
                return;
            }
            this.subscribers.offer(inner2);
            p.subscribe(inner2);
            if (this.cancelled) {
                inner2.cancel();
                this.drainAndCancel();
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.errors.tryAddThrowableOrReport(t)) {
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.upstream.cancel();
            this.errors.tryTerminateAndReport();
            this.drainAndCancel();
        }

        void drainAndCancel() {
            if (this.getAndIncrement() == 0) {
                do {
                    this.cancelAll();
                } while (this.decrementAndGet() != 0);
            }
        }

        void cancelAll() {
            InnerQueuedSubscriber<R> inner2 = this.current;
            this.current = null;
            if (inner2 != null) {
                inner2.cancel();
            }
            while ((inner2 = this.subscribers.poll()) != null) {
                inner2.cancel();
            }
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void innerNext(InnerQueuedSubscriber<R> inner2, R value) {
            if (inner2.queue().offer(value)) {
                this.drain();
            } else {
                inner2.cancel();
                this.innerError(inner2, (Throwable)MissingBackpressureException.createDefault());
            }
        }

        @Override
        public void innerError(InnerQueuedSubscriber<R> inner2, Throwable e) {
            if (this.errors.tryAddThrowableOrReport(e)) {
                inner2.setDone();
                if (this.errorMode != ErrorMode.END) {
                    this.upstream.cancel();
                }
                this.drain();
            }
        }

        @Override
        public void innerComplete(InnerQueuedSubscriber<R> inner2) {
            inner2.setDone();
            this.drain();
        }

        @Override
        public void drain() {
            boolean continueNextSource;
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            InnerQueuedSubscriber<R> inner2 = this.current;
            Subscriber<R> a = this.downstream;
            ErrorMode em = this.errorMode;
            do {
                SimpleQueue<R> q;
                long r = this.requested.get();
                long e = 0L;
                if (inner2 == null) {
                    Throwable ex;
                    if (em != ErrorMode.END && (ex = (Throwable)this.errors.get()) != null) {
                        this.cancelAll();
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    boolean outerDone = this.done;
                    inner2 = this.subscribers.poll();
                    if (outerDone && inner2 == null) {
                        this.errors.tryTerminateConsumer(this.downstream);
                        return;
                    }
                    if (inner2 != null) {
                        this.current = inner2;
                    }
                }
                continueNextSource = false;
                if (inner2 != null && (q = inner2.queue()) != null) {
                    boolean d;
                    while (e != r) {
                        boolean empty2;
                        R v;
                        Throwable ex;
                        if (this.cancelled) {
                            this.cancelAll();
                            return;
                        }
                        if (em == ErrorMode.IMMEDIATE && (ex = (Throwable)this.errors.get()) != null) {
                            this.current = null;
                            inner2.cancel();
                            this.cancelAll();
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        d = inner2.isDone();
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex2) {
                            Exceptions.throwIfFatal(ex2);
                            this.current = null;
                            inner2.cancel();
                            this.cancelAll();
                            a.onError(ex2);
                            return;
                        }
                        boolean bl = empty2 = v == null;
                        if (d && empty2) {
                            inner2 = null;
                            this.current = null;
                            this.upstream.request(1L);
                            continueNextSource = true;
                            break;
                        }
                        if (empty2) break;
                        a.onNext(v);
                        ++e;
                        inner2.request(1L);
                    }
                    if (e == r) {
                        Throwable ex;
                        if (this.cancelled) {
                            this.cancelAll();
                            return;
                        }
                        if (em == ErrorMode.IMMEDIATE && (ex = (Throwable)this.errors.get()) != null) {
                            this.current = null;
                            inner2.cancel();
                            this.cancelAll();
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        d = inner2.isDone();
                        boolean empty3 = q.isEmpty();
                        if (d && empty3) {
                            inner2 = null;
                            this.current = null;
                            this.upstream.request(1L);
                            continueNextSource = true;
                        }
                    }
                }
                if (e == 0L || r == Long.MAX_VALUE) continue;
                this.requested.addAndGet(-e);
            } while (continueNextSource || (missed = this.addAndGet(-missed)) != 0);
        }
    }
}

