/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.subscribers.SerializedSubscriber;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableDebounceTimed<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Consumer<? super T> onDropped;

    public FlowableDebounceTimed(Flowable<T> source, long timeout, TimeUnit unit, Scheduler scheduler, Consumer<? super T> onDropped) {
        super(source);
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.onDropped = onDropped;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new DebounceTimedSubscriber<T>(new SerializedSubscriber<T>(s), this.timeout, this.unit, this.scheduler.createWorker(), this.onDropped));
    }

    static final class DebounceEmitter<T>
    extends AtomicReference<Disposable>
    implements Runnable,
    Disposable {
        private static final long serialVersionUID = 6812032969491025141L;
        final T value;
        final long idx;
        final DebounceTimedSubscriber<T> parent;
        final AtomicBoolean once = new AtomicBoolean();

        DebounceEmitter(T value, long idx, DebounceTimedSubscriber<T> parent) {
            this.value = value;
            this.idx = idx;
            this.parent = parent;
        }

        @Override
        public void run() {
            this.emit();
        }

        void emit() {
            if (this.once.compareAndSet(false, true)) {
                this.parent.emit(this.idx, this.value, this);
            }
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == DisposableHelper.DISPOSED;
        }

        public void setResource(Disposable d) {
            DisposableHelper.replace(this, d);
        }
    }

    static final class DebounceTimedSubscriber<T>
    extends AtomicLong
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -9102637559663639004L;
        final Subscriber<? super T> downstream;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final Consumer<? super T> onDropped;
        Subscription upstream;
        DebounceEmitter<T> timer;
        volatile long index;
        boolean done;

        DebounceTimedSubscriber(Subscriber<? super T> actual2, long timeout, TimeUnit unit, Scheduler.Worker worker, Consumer<? super T> onDropped) {
            this.downstream = actual2;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.onDropped = onDropped;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            DebounceEmitter<T> currentEmitter = this.timer;
            if (currentEmitter != null) {
                currentEmitter.dispose();
            }
            if (this.onDropped != null && currentEmitter != null) {
                try {
                    this.onDropped.accept(currentEmitter.value);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.upstream.cancel();
                    this.done = true;
                    this.downstream.onError(ex);
                    this.worker.dispose();
                }
            }
            DebounceEmitter<T> newEmitter = new DebounceEmitter<T>(t, idx, this);
            this.timer = newEmitter;
            newEmitter.setResource(this.worker.schedule(newEmitter, this.timeout, this.unit));
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            DebounceEmitter<T> d = this.timer;
            if (d != null) {
                d.dispose();
            }
            this.downstream.onError(t);
            this.worker.dispose();
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            DebounceEmitter<T> d = this.timer;
            if (d != null) {
                d.dispose();
            }
            if (d != null) {
                d.emit();
            }
            this.downstream.onComplete();
            this.worker.dispose();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this, n);
            }
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            this.worker.dispose();
        }

        void emit(long idx, T t, DebounceEmitter<T> emitter) {
            if (idx == this.index) {
                long r = this.get();
                if (r != 0L) {
                    this.downstream.onNext(t);
                    BackpressureHelper.produced(this, 1L);
                    emitter.dispose();
                } else {
                    this.cancel();
                    this.downstream.onError(MissingBackpressureException.createDefault());
                }
            }
        }
    }
}

