/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableGroupJoin;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableJoin<TLeft, TRight, TLeftEnd, TRightEnd, R>
extends AbstractFlowableWithUpstream<TLeft, R> {
    final Publisher<? extends TRight> other;
    final Function<? super TLeft, ? extends Publisher<TLeftEnd>> leftEnd;
    final Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd;
    final BiFunction<? super TLeft, ? super TRight, ? extends R> resultSelector;

    public FlowableJoin(Flowable<TLeft> source, Publisher<? extends TRight> other, Function<? super TLeft, ? extends Publisher<TLeftEnd>> leftEnd, Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd, BiFunction<? super TLeft, ? super TRight, ? extends R> resultSelector) {
        super(source);
        this.other = other;
        this.leftEnd = leftEnd;
        this.rightEnd = rightEnd;
        this.resultSelector = resultSelector;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        JoinSubscription parent = new JoinSubscription(s, this.leftEnd, this.rightEnd, this.resultSelector);
        s.onSubscribe(parent);
        FlowableGroupJoin.LeftRightSubscriber left = new FlowableGroupJoin.LeftRightSubscriber(parent, true);
        parent.disposables.add(left);
        FlowableGroupJoin.LeftRightSubscriber right = new FlowableGroupJoin.LeftRightSubscriber(parent, false);
        parent.disposables.add(right);
        this.source.subscribe(left);
        this.other.subscribe(right);
    }

    static final class JoinSubscription<TLeft, TRight, TLeftEnd, TRightEnd, R>
    extends AtomicInteger
    implements Subscription,
    FlowableGroupJoin.JoinSupport {
        private static final long serialVersionUID = -6071216598687999801L;
        final Subscriber<? super R> downstream;
        final AtomicLong requested;
        final SpscLinkedArrayQueue<Object> queue;
        final CompositeDisposable disposables;
        final Map<Integer, TLeft> lefts;
        final Map<Integer, TRight> rights;
        final AtomicReference<Throwable> error;
        final Function<? super TLeft, ? extends Publisher<TLeftEnd>> leftEnd;
        final Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd;
        final BiFunction<? super TLeft, ? super TRight, ? extends R> resultSelector;
        final AtomicInteger active;
        int leftIndex;
        int rightIndex;
        volatile boolean cancelled;
        static final Integer LEFT_VALUE = 1;
        static final Integer RIGHT_VALUE = 2;
        static final Integer LEFT_CLOSE = 3;
        static final Integer RIGHT_CLOSE = 4;

        JoinSubscription(Subscriber<? super R> actual2, Function<? super TLeft, ? extends Publisher<TLeftEnd>> leftEnd, Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd, BiFunction<? super TLeft, ? super TRight, ? extends R> resultSelector) {
            this.downstream = actual2;
            this.requested = new AtomicLong();
            this.disposables = new CompositeDisposable();
            this.queue = new SpscLinkedArrayQueue(Flowable.bufferSize());
            this.lefts = new LinkedHashMap<Integer, TLeft>();
            this.rights = new LinkedHashMap<Integer, TRight>();
            this.error = new AtomicReference();
            this.leftEnd = leftEnd;
            this.rightEnd = rightEnd;
            this.resultSelector = resultSelector;
            this.active = new AtomicInteger(2);
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
            }
        }

        @Override
        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.cancelAll();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        void cancelAll() {
            this.disposables.dispose();
        }

        void errorAll(Subscriber<?> a) {
            Throwable ex = ExceptionHelper.terminate(this.error);
            this.lefts.clear();
            this.rights.clear();
            a.onError(ex);
        }

        void fail(Throwable exc, Subscriber<?> a, SimpleQueue<?> q) {
            Exceptions.throwIfFatal(exc);
            ExceptionHelper.addThrowable(this.error, exc);
            q.clear();
            this.cancelAll();
            this.errorAll(a);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SpscLinkedArrayQueue<Object> q = this.queue;
            Subscriber<R> a = this.downstream;
            while (true) {
                boolean empty2;
                if (this.cancelled) {
                    q.clear();
                    return;
                }
                Throwable ex = this.error.get();
                if (ex != null) {
                    q.clear();
                    this.cancelAll();
                    this.errorAll(a);
                    return;
                }
                boolean d = this.active.get() == 0;
                Integer mode = (Integer)q.poll();
                boolean bl = empty2 = mode == null;
                if (d && empty2) {
                    this.lefts.clear();
                    this.rights.clear();
                    this.disposables.dispose();
                    a.onComplete();
                    return;
                }
                if (!empty2) {
                    FlowableGroupJoin.LeftRightEndSubscriber end;
                    R w;
                    long e;
                    long r;
                    FlowableGroupJoin.LeftRightEndSubscriber end2;
                    Publisher<Object> p;
                    int idx;
                    Object val = q.poll();
                    if (mode == LEFT_VALUE) {
                        Object left = val;
                        ++this.leftIndex;
                        this.lefts.put(idx, left);
                        try {
                            p = Objects.requireNonNull(this.leftEnd.apply(left), "The leftEnd returned a null Publisher");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a, q);
                            return;
                        }
                        end2 = new FlowableGroupJoin.LeftRightEndSubscriber(this, true, idx);
                        this.disposables.add(end2);
                        p.subscribe(end2);
                        ex = this.error.get();
                        if (ex != null) {
                            q.clear();
                            this.cancelAll();
                            this.errorAll(a);
                            return;
                        }
                        r = this.requested.get();
                        e = 0L;
                        for (Object right : this.rights.values()) {
                            try {
                                w = Objects.requireNonNull(this.resultSelector.apply(left, right), "The resultSelector returned a null value");
                            }
                            catch (Throwable exc) {
                                this.fail(exc, a, q);
                                return;
                            }
                            if (e != r) {
                                a.onNext(w);
                                ++e;
                                continue;
                            }
                            ExceptionHelper.addThrowable(this.error, MissingBackpressureException.createDefault());
                            q.clear();
                            this.cancelAll();
                            this.errorAll(a);
                            return;
                        }
                        if (e == 0L) continue;
                        BackpressureHelper.produced(this.requested, e);
                        continue;
                    }
                    if (mode == RIGHT_VALUE) {
                        Object right = val;
                        ++this.rightIndex;
                        this.rights.put(idx, right);
                        try {
                            p = Objects.requireNonNull(this.rightEnd.apply(right), "The rightEnd returned a null Publisher");
                        }
                        catch (Throwable exc) {
                            this.fail(exc, a, q);
                            return;
                        }
                        end2 = new FlowableGroupJoin.LeftRightEndSubscriber(this, false, idx);
                        this.disposables.add(end2);
                        p.subscribe(end2);
                        ex = this.error.get();
                        if (ex != null) {
                            q.clear();
                            this.cancelAll();
                            this.errorAll(a);
                            return;
                        }
                        r = this.requested.get();
                        e = 0L;
                        for (Object left : this.lefts.values()) {
                            try {
                                w = Objects.requireNonNull(this.resultSelector.apply(left, right), "The resultSelector returned a null value");
                            }
                            catch (Throwable exc) {
                                this.fail(exc, a, q);
                                return;
                            }
                            if (e != r) {
                                a.onNext(w);
                                ++e;
                                continue;
                            }
                            ExceptionHelper.addThrowable(this.error, MissingBackpressureException.createDefault());
                            q.clear();
                            this.cancelAll();
                            this.errorAll(a);
                            return;
                        }
                        if (e == 0L) continue;
                        BackpressureHelper.produced(this.requested, e);
                        continue;
                    }
                    if (mode == LEFT_CLOSE) {
                        end = (FlowableGroupJoin.LeftRightEndSubscriber)val;
                        this.lefts.remove(end.index);
                        this.disposables.remove(end);
                        continue;
                    }
                    end = (FlowableGroupJoin.LeftRightEndSubscriber)val;
                    this.rights.remove(end.index);
                    this.disposables.remove(end);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public void innerError(Throwable ex) {
            if (ExceptionHelper.addThrowable(this.error, ex)) {
                this.active.decrementAndGet();
                this.drain();
            } else {
                RxJavaPlugins.onError(ex);
            }
        }

        @Override
        public void innerComplete(FlowableGroupJoin.LeftRightSubscriber sender) {
            this.disposables.delete(sender);
            this.active.decrementAndGet();
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerValue(boolean isLeft, Object o) {
            JoinSubscription joinSubscription = this;
            synchronized (joinSubscription) {
                this.queue.offer(isLeft ? LEFT_VALUE : RIGHT_VALUE, o);
            }
            this.drain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void innerClose(boolean isLeft, FlowableGroupJoin.LeftRightEndSubscriber index) {
            JoinSubscription joinSubscription = this;
            synchronized (joinSubscription) {
                this.queue.offer(isLeft ? LEFT_CLOSE : RIGHT_CLOSE, index);
            }
            this.drain();
        }

        @Override
        public void innerCloseError(Throwable ex) {
            if (ExceptionHelper.addThrowable(this.error, ex)) {
                this.drain();
            } else {
                RxJavaPlugins.onError(ex);
            }
        }
    }
}

