/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.BiPredicate;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSequenceEqual<T>
extends Flowable<Boolean> {
    final Publisher<? extends T> first;
    final Publisher<? extends T> second;
    final BiPredicate<? super T, ? super T> comparer;
    final int prefetch;

    public FlowableSequenceEqual(Publisher<? extends T> first2, Publisher<? extends T> second2, BiPredicate<? super T, ? super T> comparer, int prefetch) {
        this.first = first2;
        this.second = second2;
        this.comparer = comparer;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribeActual(Subscriber<? super Boolean> s) {
        EqualCoordinator<? extends T> parent = new EqualCoordinator<T>(s, this.prefetch, this.comparer);
        s.onSubscribe(parent);
        parent.subscribe(this.first, this.second);
    }

    static final class EqualSubscriber<T>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = 4804128302091633067L;
        final EqualCoordinatorHelper parent;
        final int prefetch;
        final int limit;
        long produced;
        volatile SimpleQueue<T> queue;
        volatile boolean done;
        int sourceMode;

        EqualSubscriber(EqualCoordinatorHelper parent, int prefetch) {
            this.parent = parent;
            this.limit = prefetch - (prefetch >> 2);
            this.prefetch = prefetch;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this, s)) {
                if (s instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s;
                    int m = qs.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = qs;
                        s.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                s.request(this.prefetch);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.sourceMode == 0 && !this.queue.offer(t)) {
                this.onError(MissingBackpressureException.createDefault());
                return;
            }
            this.parent.drain();
        }

        @Override
        public void onError(Throwable t) {
            this.parent.innerError(t);
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        public void request() {
            if (this.sourceMode != 1) {
                long p = this.produced + 1L;
                if (p >= (long)this.limit) {
                    this.produced = 0L;
                    ((Subscription)this.get()).request(p);
                } else {
                    this.produced = p;
                }
            }
        }

        public void cancel() {
            SubscriptionHelper.cancel(this);
        }

        void clear() {
            SimpleQueue<T> sq = this.queue;
            if (sq != null) {
                sq.clear();
            }
        }
    }

    static final class EqualCoordinator<T>
    extends DeferredScalarSubscription<Boolean>
    implements EqualCoordinatorHelper {
        private static final long serialVersionUID = -6178010334400373240L;
        final BiPredicate<? super T, ? super T> comparer;
        final EqualSubscriber<T> first;
        final EqualSubscriber<T> second;
        final AtomicThrowable errors;
        final AtomicInteger wip;
        T v1;
        T v2;

        EqualCoordinator(Subscriber<? super Boolean> actual2, int prefetch, BiPredicate<? super T, ? super T> comparer) {
            super(actual2);
            this.comparer = comparer;
            this.wip = new AtomicInteger();
            this.first = new EqualSubscriber(this, prefetch);
            this.second = new EqualSubscriber(this, prefetch);
            this.errors = new AtomicThrowable();
        }

        void subscribe(Publisher<? extends T> source1, Publisher<? extends T> source2) {
            source1.subscribe(this.first);
            source2.subscribe(this.second);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.first.cancel();
            this.second.cancel();
            this.errors.tryTerminateAndReport();
            if (this.wip.getAndIncrement() == 0) {
                this.first.clear();
                this.second.clear();
            }
        }

        void cancelAndClear() {
            this.first.cancel();
            this.first.clear();
            this.second.cancel();
            this.second.clear();
        }

        @Override
        public void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            block6: do {
                Throwable ex;
                SimpleQueue q1 = this.first.queue;
                SimpleQueue q2 = this.second.queue;
                if (q1 != null && q2 != null) {
                    while (true) {
                        boolean c;
                        boolean e2;
                        if (this.isCancelled()) {
                            this.first.clear();
                            this.second.clear();
                            return;
                        }
                        ex = (Throwable)this.errors.get();
                        if (ex != null) {
                            this.cancelAndClear();
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        boolean d1 = this.first.done;
                        T a = this.v1;
                        if (a == null) {
                            try {
                                a = q1.poll();
                            }
                            catch (Throwable exc) {
                                Exceptions.throwIfFatal(exc);
                                this.cancelAndClear();
                                this.errors.tryAddThrowableOrReport(exc);
                                this.errors.tryTerminateConsumer(this.downstream);
                                return;
                            }
                            this.v1 = a;
                        }
                        boolean e1 = a == null;
                        boolean d2 = this.second.done;
                        T b = this.v2;
                        if (b == null) {
                            try {
                                b = q2.poll();
                            }
                            catch (Throwable exc) {
                                Exceptions.throwIfFatal(exc);
                                this.cancelAndClear();
                                this.errors.tryAddThrowableOrReport(exc);
                                this.errors.tryTerminateConsumer(this.downstream);
                                return;
                            }
                            this.v2 = b;
                        }
                        boolean bl = e2 = b == null;
                        if (d1 && d2 && e1 && e2) {
                            this.complete(true);
                            return;
                        }
                        if (d1 && d2 && e1 != e2) {
                            this.cancelAndClear();
                            this.complete(false);
                            return;
                        }
                        if (e1 || e2) continue block6;
                        try {
                            c = this.comparer.test(a, b);
                        }
                        catch (Throwable exc) {
                            Exceptions.throwIfFatal(exc);
                            this.cancelAndClear();
                            this.errors.tryAddThrowableOrReport(exc);
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        if (!c) {
                            this.cancelAndClear();
                            this.complete(false);
                            return;
                        }
                        this.v1 = null;
                        this.v2 = null;
                        this.first.request();
                        this.second.request();
                    }
                }
                if (this.isCancelled()) {
                    this.first.clear();
                    this.second.clear();
                    return;
                }
                ex = (Throwable)this.errors.get();
                if (ex == null) continue;
                this.cancelAndClear();
                this.errors.tryTerminateConsumer(this.downstream);
                return;
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        @Override
        public void innerError(Throwable t) {
            if (this.errors.tryAddThrowableOrReport(t)) {
                this.drain();
            }
        }
    }

    static interface EqualCoordinatorHelper {
        public void drain();

        public void innerError(Throwable var1);
    }
}

