/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.schedulers.Timed;
import java.util.concurrent.TimeUnit;

public final class MaybeTimeInterval<T>
extends Maybe<Timed<T>> {
    final MaybeSource<T> source;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean start;

    public MaybeTimeInterval(MaybeSource<T> source, TimeUnit unit, Scheduler scheduler, boolean start2) {
        this.source = source;
        this.unit = unit;
        this.scheduler = scheduler;
        this.start = start2;
    }

    @Override
    protected void subscribeActual(@NonNull @NonNull MaybeObserver<? super @NonNull Timed<T>> observer) {
        this.source.subscribe(new TimeIntervalMaybeObserver(observer, this.unit, this.scheduler, this.start));
    }

    static final class TimeIntervalMaybeObserver<T>
    implements MaybeObserver<T>,
    Disposable {
        final MaybeObserver<? super Timed<T>> downstream;
        final TimeUnit unit;
        final Scheduler scheduler;
        final long startTime;
        Disposable upstream;

        TimeIntervalMaybeObserver(MaybeObserver<? super Timed<T>> downstream, TimeUnit unit, Scheduler scheduler, boolean start2) {
            this.downstream = downstream;
            this.unit = unit;
            this.scheduler = scheduler;
            this.startTime = start2 ? scheduler.now(unit) : 0L;
        }

        @Override
        public void onSubscribe(@NonNull Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(@NonNull T t) {
            this.downstream.onSuccess(new Timed<T>(t, this.scheduler.now(this.unit) - this.startTime, this.unit));
        }

        @Override
        public void onError(@NonNull Throwable e) {
            this.downstream.onError(e);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }
    }
}

