/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeUsing<T, D>
extends Maybe<T> {
    final Supplier<? extends D> resourceSupplier;
    final Function<? super D, ? extends MaybeSource<? extends T>> sourceSupplier;
    final Consumer<? super D> resourceDisposer;
    final boolean eager;

    public MaybeUsing(Supplier<? extends D> resourceSupplier, Function<? super D, ? extends MaybeSource<? extends T>> sourceSupplier, Consumer<? super D> resourceDisposer, boolean eager) {
        this.resourceSupplier = resourceSupplier;
        this.sourceSupplier = sourceSupplier;
        this.resourceDisposer = resourceDisposer;
        this.eager = eager;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        MaybeSource<T> source;
        D resource;
        try {
            resource = this.resourceSupplier.get();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        try {
            source = Objects.requireNonNull(this.sourceSupplier.apply(resource), "The sourceSupplier returned a null MaybeSource");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            if (this.eager) {
                try {
                    this.resourceDisposer.accept(resource);
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal(exc);
                    EmptyDisposable.error((Throwable)new CompositeException(ex, exc), observer);
                    return;
                }
            }
            EmptyDisposable.error(ex, observer);
            if (!this.eager) {
                try {
                    this.resourceDisposer.accept(resource);
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal(exc);
                    RxJavaPlugins.onError(exc);
                }
            }
            return;
        }
        source.subscribe(new UsingObserver<T, D>(observer, resource, this.resourceDisposer, this.eager));
    }

    static final class UsingObserver<T, D>
    extends AtomicReference<Object>
    implements MaybeObserver<T>,
    Disposable {
        private static final long serialVersionUID = -674404550052917487L;
        final MaybeObserver<? super T> downstream;
        final Consumer<? super D> disposer;
        final boolean eager;
        Disposable upstream;

        UsingObserver(MaybeObserver<? super T> actual2, D resource, Consumer<? super D> disposer, boolean eager) {
            super(resource);
            this.downstream = actual2;
            this.disposer = disposer;
            this.eager = eager;
        }

        @Override
        public void dispose() {
            if (this.eager) {
                this.disposeResource();
                this.upstream.dispose();
                this.upstream = DisposableHelper.DISPOSED;
            } else {
                this.upstream.dispose();
                this.upstream = DisposableHelper.DISPOSED;
                this.disposeResource();
            }
        }

        void disposeResource() {
            UsingObserver resource = this.getAndSet(this);
            if (resource != this) {
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaPlugins.onError(ex);
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.upstream = DisposableHelper.DISPOSED;
            if (this.eager) {
                UsingObserver resource = this.getAndSet(this);
                if (resource != this) {
                    try {
                        this.disposer.accept(resource);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.downstream.onError(ex);
                        return;
                    }
                } else {
                    return;
                }
            }
            this.downstream.onSuccess(value);
            if (!this.eager) {
                this.disposeResource();
            }
        }

        @Override
        public void onError(Throwable e) {
            this.upstream = DisposableHelper.DISPOSED;
            if (this.eager) {
                UsingObserver resource = this.getAndSet(this);
                if (resource != this) {
                    try {
                        this.disposer.accept(resource);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        e = new CompositeException(e, ex);
                    }
                } else {
                    return;
                }
            }
            this.downstream.onError(e);
            if (!this.eager) {
                this.disposeResource();
            }
        }

        @Override
        public void onComplete() {
            this.upstream = DisposableHelper.DISPOSED;
            if (this.eager) {
                UsingObserver resource = this.getAndSet(this);
                if (resource != this) {
                    try {
                        this.disposer.accept(resource);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.downstream.onError(ex);
                        return;
                    }
                } else {
                    return;
                }
            }
            this.downstream.onComplete();
            if (!this.eager) {
                this.disposeResource();
            }
        }
    }
}

