/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.mixed.ConcatMapXMainObserver;
import io.reactivex.rxjava3.internal.operators.mixed.ScalarXMapZHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.operators.SimpleQueue;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableConcatMapSingle<T, R>
extends Observable<R> {
    final ObservableSource<T> source;
    final Function<? super T, ? extends SingleSource<? extends R>> mapper;
    final ErrorMode errorMode;
    final int prefetch;

    public ObservableConcatMapSingle(ObservableSource<T> source, Function<? super T, ? extends SingleSource<? extends R>> mapper, ErrorMode errorMode, int prefetch) {
        this.source = source;
        this.mapper = mapper;
        this.errorMode = errorMode;
        this.prefetch = prefetch;
    }

    @Override
    protected void subscribeActual(Observer<? super R> observer) {
        if (!ScalarXMapZHelper.tryAsSingle(this.source, this.mapper, observer)) {
            this.source.subscribe(new ConcatMapSingleMainObserver<T, R>(observer, this.mapper, this.prefetch, this.errorMode));
        }
    }

    static final class ConcatMapSingleMainObserver<T, R>
    extends ConcatMapXMainObserver<T> {
        private static final long serialVersionUID = -9140123220065488293L;
        final Observer<? super R> downstream;
        final Function<? super T, ? extends SingleSource<? extends R>> mapper;
        final ConcatMapSingleObserver<R> inner;
        R item;
        volatile int state;
        static final int STATE_INACTIVE = 0;
        static final int STATE_ACTIVE = 1;
        static final int STATE_RESULT_VALUE = 2;

        ConcatMapSingleMainObserver(Observer<? super R> downstream, Function<? super T, ? extends SingleSource<? extends R>> mapper, int prefetch, ErrorMode errorMode) {
            super(prefetch, errorMode);
            this.downstream = downstream;
            this.mapper = mapper;
            this.inner = new ConcatMapSingleObserver(this);
        }

        void innerSuccess(R item) {
            this.item = item;
            this.state = 2;
            this.drain();
        }

        void innerError(Throwable ex) {
            if (this.errors.tryAddThrowableOrReport(ex)) {
                if (this.errorMode != ErrorMode.END) {
                    this.upstream.dispose();
                }
                this.state = 0;
                this.drain();
            }
        }

        @Override
        void disposeInner() {
            this.inner.dispose();
        }

        @Override
        void onSubscribeDownstream() {
            this.downstream.onSubscribe(this);
        }

        @Override
        void clearValue() {
            this.item = null;
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer<R> downstream = this.downstream;
            ErrorMode errorMode = this.errorMode;
            SimpleQueue queue = this.queue;
            AtomicThrowable errors = this.errors;
            while (true) {
                if (this.disposed) {
                    queue.clear();
                    this.item = null;
                } else {
                    int s = this.state;
                    if (errors.get() != null && (errorMode == ErrorMode.IMMEDIATE || errorMode == ErrorMode.BOUNDARY && s == 0)) {
                        queue.clear();
                        this.item = null;
                        errors.tryTerminateConsumer(downstream);
                        return;
                    }
                    if (s == 0) {
                        boolean empty2;
                        Object v;
                        boolean d = this.done;
                        try {
                            v = queue.poll();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.disposed = true;
                            this.upstream.dispose();
                            errors.tryAddThrowableOrReport(ex);
                            errors.tryTerminateConsumer(downstream);
                            return;
                        }
                        boolean bl = empty2 = v == null;
                        if (d && empty2) {
                            errors.tryTerminateConsumer(downstream);
                            return;
                        }
                        if (!empty2) {
                            SingleSource<R> ss;
                            try {
                                ss = Objects.requireNonNull(this.mapper.apply(v), "The mapper returned a null SingleSource");
                            }
                            catch (Throwable ex) {
                                Exceptions.throwIfFatal(ex);
                                this.upstream.dispose();
                                queue.clear();
                                errors.tryAddThrowableOrReport(ex);
                                errors.tryTerminateConsumer(downstream);
                                return;
                            }
                            this.state = 1;
                            ss.subscribe(this.inner);
                        }
                    } else if (s == 2) {
                        R w = this.item;
                        this.item = null;
                        downstream.onNext(w);
                        this.state = 0;
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        static final class ConcatMapSingleObserver<R>
        extends AtomicReference<Disposable>
        implements SingleObserver<R> {
            private static final long serialVersionUID = -3051469169682093892L;
            final ConcatMapSingleMainObserver<?, R> parent;

            ConcatMapSingleObserver(ConcatMapSingleMainObserver<?, R> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.replace(this, d);
            }

            @Override
            public void onSuccess(R t) {
                this.parent.innerSuccess(t);
            }

            @Override
            public void onError(Throwable e) {
                this.parent.innerError(e);
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

