/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ObservableBuffer<T, U extends Collection<? super T>>
extends AbstractObservableWithUpstream<T, U> {
    final int count;
    final int skip;
    final Supplier<U> bufferSupplier;

    public ObservableBuffer(ObservableSource<T> source, int count2, int skip, Supplier<U> bufferSupplier) {
        super(source);
        this.count = count2;
        this.skip = skip;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Observer<? super U> t) {
        if (this.skip == this.count) {
            BufferExactObserver bes = new BufferExactObserver(t, this.count, this.bufferSupplier);
            if (bes.createBuffer()) {
                this.source.subscribe(bes);
            }
        } else {
            this.source.subscribe(new BufferSkipObserver(t, this.count, this.skip, this.bufferSupplier));
        }
    }

    static final class BufferSkipObserver<T, U extends Collection<? super T>>
    extends AtomicBoolean
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -8223395059921494546L;
        final Observer<? super U> downstream;
        final int count;
        final int skip;
        final Supplier<U> bufferSupplier;
        Disposable upstream;
        final ArrayDeque<U> buffers;
        long index;

        BufferSkipObserver(Observer<? super U> actual2, int count2, int skip, Supplier<U> bufferSupplier) {
            this.downstream = actual2;
            this.count = count2;
            this.skip = skip;
            this.bufferSupplier = bufferSupplier;
            this.buffers = new ArrayDeque();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t) {
            if (this.index++ % (long)this.skip == 0L) {
                Collection b;
                try {
                    b = (Collection)ExceptionHelper.nullCheck(this.bufferSupplier.get(), "The bufferSupplier returned a null Collection.");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.buffers.clear();
                    this.upstream.dispose();
                    this.downstream.onError(e);
                    return;
                }
                this.buffers.offer(b);
            }
            Iterator<U> it = this.buffers.iterator();
            while (it.hasNext()) {
                Collection b = (Collection)it.next();
                b.add(t);
                if (this.count > b.size()) continue;
                it.remove();
                this.downstream.onNext(b);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.buffers.clear();
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            while (!this.buffers.isEmpty()) {
                this.downstream.onNext(this.buffers.poll());
            }
            this.downstream.onComplete();
        }
    }

    static final class BufferExactObserver<T, U extends Collection<? super T>>
    implements Observer<T>,
    Disposable {
        final Observer<? super U> downstream;
        final int count;
        final Supplier<U> bufferSupplier;
        U buffer;
        int size;
        Disposable upstream;

        BufferExactObserver(Observer<? super U> actual2, int count2, Supplier<U> bufferSupplier) {
            this.downstream = actual2;
            this.count = count2;
            this.bufferSupplier = bufferSupplier;
        }

        boolean createBuffer() {
            Collection b;
            try {
                b = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "Empty buffer supplied");
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal(t);
                this.buffer = null;
                if (this.upstream == null) {
                    EmptyDisposable.error(t, this.downstream);
                } else {
                    this.upstream.dispose();
                    this.downstream.onError(t);
                }
                return false;
            }
            this.buffer = b;
            return true;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t) {
            U b = this.buffer;
            if (b != null) {
                b.add(t);
                if (++this.size >= this.count) {
                    this.downstream.onNext(b);
                    this.size = 0;
                    this.createBuffer();
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            this.buffer = null;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            U b = this.buffer;
            if (b != null) {
                this.buffer = null;
                if (!b.isEmpty()) {
                    this.downstream.onNext(b);
                }
                this.downstream.onComplete();
            }
        }
    }
}

