/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.fuseable.HasUpstreamObservableSource;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.observables.ConnectableObservable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservablePublish<T>
extends ConnectableObservable<T>
implements HasUpstreamObservableSource<T> {
    final ObservableSource<T> source;
    final AtomicReference<PublishConnection<T>> current;

    public ObservablePublish(ObservableSource<T> source) {
        this.source = source;
        this.current = new AtomicReference();
    }

    @Override
    public void connect(Consumer<? super Disposable> connection) {
        PublishConnection<T> conn;
        boolean doConnect = false;
        while ((conn = this.current.get()) == null || conn.isDisposed()) {
            PublishConnection<T> fresh = new PublishConnection<T>(this.current);
            if (!this.current.compareAndSet(conn, fresh)) continue;
            conn = fresh;
            break;
        }
        doConnect = !conn.connect.get() && conn.connect.compareAndSet(false, true);
        try {
            connection.accept(conn);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        if (doConnect) {
            this.source.subscribe(conn);
        }
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        PublishConnection<Object> conn;
        while ((conn = this.current.get()) == null) {
            PublishConnection<T> fresh = new PublishConnection<T>(this.current);
            if (!this.current.compareAndSet(conn, fresh)) continue;
            conn = fresh;
            break;
        }
        InnerDisposable<T> inner2 = new InnerDisposable<T>(observer, conn);
        observer.onSubscribe(inner2);
        if (conn.add(inner2)) {
            if (inner2.isDisposed()) {
                conn.remove(inner2);
            }
            return;
        }
        Throwable error = conn.error;
        if (error != null) {
            observer.onError(error);
        } else {
            observer.onComplete();
        }
    }

    @Override
    public void reset() {
        PublishConnection<T> conn = this.current.get();
        if (conn != null && conn.isDisposed()) {
            this.current.compareAndSet(conn, null);
        }
    }

    @Override
    public ObservableSource<T> source() {
        return this.source;
    }

    static final class InnerDisposable<T>
    extends AtomicReference<PublishConnection<T>>
    implements Disposable {
        private static final long serialVersionUID = 7463222674719692880L;
        final Observer<? super T> downstream;

        InnerDisposable(Observer<? super T> downstream, PublishConnection<T> parent) {
            this.downstream = downstream;
            this.lazySet(parent);
        }

        @Override
        public void dispose() {
            PublishConnection p = this.getAndSet(null);
            if (p != null) {
                p.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get() == null;
        }
    }

    static final class PublishConnection<T>
    extends AtomicReference<InnerDisposable<T>[]>
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -3251430252873581268L;
        final AtomicBoolean connect = new AtomicBoolean();
        final AtomicReference<PublishConnection<T>> current;
        final AtomicReference<Disposable> upstream;
        static final InnerDisposable[] EMPTY = new InnerDisposable[0];
        static final InnerDisposable[] TERMINATED = new InnerDisposable[0];
        Throwable error;

        PublishConnection(AtomicReference<PublishConnection<T>> current) {
            this.current = current;
            this.upstream = new AtomicReference();
            this.lazySet(EMPTY);
        }

        @Override
        public void dispose() {
            this.getAndSet(TERMINATED);
            this.current.compareAndSet(this, null);
            DisposableHelper.dispose(this.upstream);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == TERMINATED;
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this.upstream, d);
        }

        @Override
        public void onNext(T t) {
            for (InnerDisposable inner2 : (InnerDisposable[])this.get()) {
                inner2.downstream.onNext(t);
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.upstream.get() != DisposableHelper.DISPOSED) {
                this.error = e;
                this.upstream.lazySet(DisposableHelper.DISPOSED);
                for (InnerDisposable inner2 : this.getAndSet(TERMINATED)) {
                    inner2.downstream.onError(e);
                }
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            this.upstream.lazySet(DisposableHelper.DISPOSED);
            for (InnerDisposable inner2 : this.getAndSet(TERMINATED)) {
                inner2.downstream.onComplete();
            }
        }

        public boolean add(InnerDisposable<T> inner2) {
            InnerDisposable[] b;
            InnerDisposable[] a;
            do {
                if ((a = (InnerDisposable[])this.get()) == TERMINATED) {
                    return false;
                }
                int n = a.length;
                b = new InnerDisposable[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = inner2;
            } while (!this.compareAndSet(a, b));
            return true;
        }

        public void remove(InnerDisposable<T> inner2) {
            InnerDisposable[] b;
            InnerDisposable[] a;
            do {
                int n;
                if ((n = (a = (InnerDisposable[])this.get()).length) == 0) {
                    return;
                }
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (a[i] != inner2) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                b = EMPTY;
                if (n == 1) continue;
                b = new InnerDisposable[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            } while (!this.compareAndSet(a, b));
        }
    }
}

