/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.internal.observers.BasicIntQueueDisposable;

public final class ObservableRange
extends Observable<Integer> {
    private final int start;
    private final long end;

    public ObservableRange(int start2, int count2) {
        this.start = start2;
        this.end = (long)start2 + (long)count2;
    }

    @Override
    protected void subscribeActual(Observer<? super Integer> o) {
        RangeDisposable parent = new RangeDisposable(o, this.start, this.end);
        o.onSubscribe(parent);
        parent.run();
    }

    static final class RangeDisposable
    extends BasicIntQueueDisposable<Integer> {
        private static final long serialVersionUID = 396518478098735504L;
        final Observer<? super Integer> downstream;
        final long end;
        long index;
        boolean fused;

        RangeDisposable(Observer<? super Integer> actual2, long start2, long end) {
            this.downstream = actual2;
            this.index = start2;
            this.end = end;
        }

        void run() {
            if (this.fused) {
                return;
            }
            Observer<? super Integer> actual2 = this.downstream;
            long e = this.end;
            for (long i = this.index; i != e && this.get() == 0; ++i) {
                actual2.onNext((Integer)((int)i));
            }
            if (this.get() == 0) {
                this.lazySet(1);
                actual2.onComplete();
            }
        }

        @Override
        @Nullable
        public Integer poll() {
            long i = this.index;
            if (i != this.end) {
                this.index = i + 1L;
                return (int)i;
            }
            this.lazySet(1);
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.index == this.end;
        }

        @Override
        public void clear() {
            this.index = this.end;
            this.lazySet(1);
        }

        @Override
        public void dispose() {
            this.set(1);
        }

        @Override
        public boolean isDisposed() {
            return this.get() != 0;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 1) != 0) {
                this.fused = true;
                return 1;
            }
            return 0;
        }
    }
}

