/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.internal.observers.BasicIntQueueDisposable;

public final class ObservableRangeLong
extends Observable<Long> {
    private final long start;
    private final long count;

    public ObservableRangeLong(long start2, long count2) {
        this.start = start2;
        this.count = count2;
    }

    @Override
    protected void subscribeActual(Observer<? super Long> o) {
        RangeDisposable parent = new RangeDisposable(o, this.start, this.start + this.count);
        o.onSubscribe(parent);
        parent.run();
    }

    static final class RangeDisposable
    extends BasicIntQueueDisposable<Long> {
        private static final long serialVersionUID = 396518478098735504L;
        final Observer<? super Long> downstream;
        final long end;
        long index;
        boolean fused;

        RangeDisposable(Observer<? super Long> actual2, long start2, long end) {
            this.downstream = actual2;
            this.index = start2;
            this.end = end;
        }

        void run() {
            if (this.fused) {
                return;
            }
            Observer<? super Long> actual2 = this.downstream;
            long e = this.end;
            for (long i = this.index; i != e && this.get() == 0; ++i) {
                actual2.onNext((Long)i);
            }
            if (this.get() == 0) {
                this.lazySet(1);
                actual2.onComplete();
            }
        }

        @Override
        @Nullable
        public Long poll() {
            long i = this.index;
            if (i != this.end) {
                this.index = i + 1L;
                return i;
            }
            this.lazySet(1);
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.index == this.end;
        }

        @Override
        public void clear() {
            this.index = this.end;
            this.lazySet(1);
        }

        @Override
        public void dispose() {
            this.set(1);
        }

        @Override
        public boolean isDisposed() {
            return this.get() != 0;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 1) != 0) {
                this.fused = true;
                return 1;
            }
            return 0;
        }
    }
}

